@extends('home.layout-index')
@section('content')

<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/modules/exporting.js"></script>
<script src="https://rawgit.com/highcharts/rounded-corners/master/rounded-corners.js"></script>
<script src="https://code.highcharts.com/highcharts-more.js"></script>
<script src="https://code.highcharts.com/modules/solid-gauge.js"></script>

<style>
.highcharts-figure, .highcharts-data-table table {
    min-width: 320px;
    max-width: 800px;
    margin: 1em auto;
}

.highcharts-data-table table {
    font-family: Verdana, sans-serif;
    border-collapse: collapse;
    border: 1px solid #EBEBEB;
    margin: 10px auto;
    text-align: center;
    width: 100%;
    max-width: 500px;
}
.highcharts-data-table caption {
    padding: 1em 0;
    font-size: 1.2em;
    color: #555;
}
.highcharts-data-table th {
    font-weight: 600;
    padding: 0.5em;
}
.highcharts-data-table td, .highcharts-data-table th, .highcharts-data-table caption {
    padding: 0.5em;
}
.highcharts-data-table thead tr, .highcharts-data-table tr:nth-child(even) {
    background: #f8f8f8;
}
.highcharts-data-table tr:hover {
    background: #f1f7ff;
}
#grafik1,#grafik2,
#grafik3,#grafik4,
#grafik5,#grafik6,
#grafik7
{
    height: 400px;
    width: 400px;
}

.tbl{
    padding:5px;
    font-size:12px;
}
.font_tbl{
    padding-top:5px;
    padding-right:5px;
    padding-bottom:5px;
    font-size:12px;
}
.a{
    border:1px red;
}
.batas{
    border:1px solid #e3e3e3;
    border-radius: 10px;
}
.tbl th{
    text-align:center;
}
</style>

<link href="{{asset('media/assets/node_modules/icheck/skins/all.css')}}" rel="stylesheet">
<style>
.has-error{
    color:#ff5e5e;
}
.profile-pica{
    height:40px;
    border-radius:50%;
}
.module{
    padding:20px;
}
</style>
<style>
.jdl1{
    font-size:15pt;
}
.sellevel{
    margin-left:35px;
}
.sellevel2{
    margin-left:35px;
    margin-top:685px;
}
.nama{
    font-weight:500;
    font-size:8pt;
    text-align:center;
}
</style>
<style>
.bootCols{
  height:325px;
  margin:0;
  box-sizing:border-box;
  padding:5px;
  border:0px solid transparent;
}

   #map-canvas {
       margin-top: 20px; width: 100%; height: 600px;
   }
   .gm-style-iw button:focus {
     outline: 0;
   }
   .linkinfo{
            color:maroon;
        font-weight:500;
   }
   

:after,
:before,
*{
    box-sizing: border-box;
}
.container {
  width:1200px;
  padding-right: 15px;
  padding-left: 15px;
  margin-right: auto;
  margin-left: auto;
}
body {
  margin: 0;
  font-family: 'Rajdhani', sans-serif;
}
h2 {
      line-height:1.1;
}
.hero-slider {
  width: 100%;
  height: 700px;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  position: relative;
  z-index: 0;
}

@media (max-width: 991px) {
  .hero-slider {
    height: 600px;
  }
}

@media (max-width: 767px) {
  .hero-slider {
    height: 500px;
  }
}

.hero-slider .swiper-slide {
  overflow: hidden;
  color: #fff;
}

.hero-slider .swiper-container {
  width: 100%;
  height: 100%;
  position: absolute;
  left: 0;
  top: 0;
}

.hero-slider .slide-inner {
  width: 100%;
  height: 100%;
  position: absolute;
  left: 0;
  top: 0;
  z-index: 1;
  background-size: cover;
  background-position: center;
  display: flex;
  justify-content: center;
  align-items: center;
  text-align: left;
}

.hero-slider .swiper-button-prev,
.hero-slider .swiper-button-next {
  background: transparent;
  width: 55px;
  height: 55px;
  line-height: 53px;
  margin-top: -30px;
  text-align: center;
  border: 2px solid #d4d3d3;
  border-radius: 55px;
  opacity:0;
  visibility:hidden;
  transition:all .3s ease;
}
.hero-slider:hover .swiper-button-prev,
.hero-slider:hover .swiper-button-next {
  transform:translateX(0);
  opacity:1;
  visibility:visible;
}

@media (max-width: 767px) {
  .hero-slider .swiper-button-prev,
  .hero-slider .swiper-button-next {
    display: none;
  }
}

.hero-slider .swiper-button-prev {
  left: 25px;
  transform:translateX(50px);
}

.hero-slider .swiper-button-prev:before {
  font-family: "Font Awesome 5 Free";
  content: "\f060";
  font-size: 15px;
  color: #d4d3d3;
  font-style: normal;
  display: inline-block
  vertical-align: middle;
  font-weight: 900;
}

.hero-slider .swiper-button-next {
  right: 25px;
  transform:translateX(-50px);
}

.hero-slider .swiper-button-next:before {
  font-family: "Font Awesome 5 Free";
  content: "\f061";
  font-size: 15px;
  color: #d4d3d3;
  font-style: normal;
  display: inline-block
  vertical-align: middle;
  font-weight: 900;
}

.hero-slider .swiper-pagination-bullet {
  width: 12px;
  height: 12px;
  text-align: left;
  line-height: 12px;
  font-size: 12px;
  color: #000;
  opacity: 0.3;
  background:#fff;
  transition:all .2s ease;
}

.hero-slider .swiper-pagination-bullet-active {
  opacity:1;
}

.hero-slider .swiper-container-horizontal > .swiper-pagination-bullets,
.hero-slider .swiper-pagination-custom,
.hero-slider .swiper-pagination-fraction {
  bottom: 30px;
}

@media screen and (min-width: 992px) {
  .hero-slider .swiper-container-horizontal > .swiper-pagination-bullets,
  .hero-slider .swiper-pagination-custom,
  .hero-slider .swiper-pagination-fraction {
/*     display: none; */
  }
}
.swiper-pagination {
  text-align:left;
}

.hero-slider .swiper-container-horizontal > .swiper-pagination-bullets{
  bottom:50px;
    max-width: 1200px;
    padding: 0 15px;
    margin: 0 auto;
    left: 50%;
    transform: translateX(-50%);
}
}
@media (min-width: 767px) {
  .hero-slider .swiper-container-horizontal > .swiper-pagination-bullets{
  bottom:30px;
 
}
}
/*--------------------------------------------------------------
    #hero-style
--------------------------------------------------------------*/
.hero-style {
  height: 500px;
  transition:all .4s ease;
}

@media (max-width: 991px) {
  .hero-style {
    height: 600px;
  }
}

@media (max-width: 767px) {
  .hero-style{
    height: 500px;
  }
}

@media screen and (min-width: 992px) {
  .hero-style .container {
    padding-top: 95px;
  }
}

.hero-style .slide-title,
.hero-style .slide-text,
.hero-style .slide-btns {
  max-width: 690px;
}

.hero-style .slide-title h2 {
  font-size: 100px;
  font-weight: 600;
  line-height: 1;
  color: #ffffff;
  margin: 0 0 40px;
  text-transform: capitalize;
  transition:all .4s ease;
}

@media (max-width: 1199px) {
  .hero-style .slide-title h2 {
    font-size: 75px;
  }
}

@media (max-width: 991px) {
  .hero-style .slide-title h2 {
    font-size: 50px;
    margin: 0 0 35px;
  }
}

@media (max-width: 767px) {
  .hero-style .slide-title h2 {
    font-size: 35px;
    margin: 0 0 30px;
  }
}

.hero-style .slide-text p {
  opacity: 0.8;
  font-family: Rajdhani;
  font-size: 32px;
  font-weight: 500;
  line-height: 1.25;
  letter-spacing: normal;
  color: #ffffff;
  margin: 0 0 40px;
  transition:all .4s ease;
}

@media (max-width: 767px) {
  .hero-style .slide-text p {
    font-size: 16px;
    font-size: 1rem;
    font-weight: normal;
    margin: 0 0 30px;
  }
}

.hero-style .slide-btns > a:first-child {
  margin-right: 10px;
}


/*--------------------------------------------------------------
    #button-style
--------------------------------------------------------------*/
.theme-btn, .theme-btn-s2{
    background-color: #ffffff;
    font-size: 20px;
  font-weight: 500;
  line-height: 1.4;
  text-align: center;
  color:#2b3b95;
    padding: 9px 32px;
    border: 0;
  border-radius: 3px;
    text-transform: uppercase;
    display: inline-block;
    line-height: initial;
  transition:all .4s ease;
}
a {
    text-decoration: none;
    transition: all 0.2s ease;
}
.theme-btn-s2{
    background-color: rgba(255, 255, 255, 0.9);
    color: #131e4a;
}
.theme-btn:hover, .theme-btn-s2:hover, .theme-btn:focus, .theme-btn-s2:focus, .theme-btn:active, .theme-btn-s2:active {
    background-color:#2b3b95 ;
    color: #fff;
}
.theme-btn-s3{
  font-size: 16px;
  font-weight: 500;
  line-height: 1.5;
  color: #ffffff;
  text-transform: uppercase;
}
i.fa-chevron-circle-right{
  height:22px;
  width:22px;
}
a:hover {
    text-decoration: none;
}
@media (max-width: 991px){
  .theme-btn, .theme-btn-s2, .theme-btn-s3 {
    font-size: 13px;
    padding: 15px 25px;
  }
}
@media (max-width: 767px){
  .theme-btn, .theme-btn-s2{
    padding: 13px 20px;
    font-size: 13px;
  }
}


   
</style>
<link href="{{asset('media/dist/css/pages/form-icheck.css')}}" rel="stylesheet">
<link href="https://fonts.googleapis.com/css?family=Rajdhani&display=swap" rel="stylesheet">
<!-- start of hero -->
<section class="hero-slider hero-style">
  <div class="swiper-container">
    <div class="swiper-wrapper">
      <div class="swiper-slide">
        <div class="slide-inner slide-bg-image" data-background="{{ asset('media').'/'.$listslide->satu; }}">
          <div class="container">
            <div data-swiper-parallax="300" class="slide-title">
              <h2 style="color: transparent;">SigapLapor 1</h2>
            </div>
            <div data-swiper-parallax="400" class="slide-text">
              <p style="color: transparent;">Text description 1</p>
            </div>
            <div class="clearfix"></div>
            <div data-swiper-parallax="500" class="slide-btns">
              <!--<a href="#" class="theme-btn-s2">Register now</a>
              <a href="#" class="theme-btn-s3"><i class="fas fa-chevron-circle-right"></i> Get Info</a>-->
            </div>
          </div>
        </div>
        <!-- end slide-inner -->
      </div>
      <!-- end swiper-slide -->
 
      <div class="swiper-slide">
        <div class="slide-inner slide-bg-image" data-background="{{ asset('media').'/'.$listslide->dua; }}">
          <div class="container">
            <div data-swiper-parallax="300" class="slide-title">
              <h2 style="color: transparent;">SigapLapor 1</h2>
            </div>
            <div data-swiper-parallax="400" class="slide-text">
              <p style="color: transparent;">Text description 1</p>
            </div>
            <div class="clearfix"></div>
            <div data-swiper-parallax="500" class="slide-btns">
              <!--<a href="#" class="theme-btn-s2">Register now</a>
              <a href="#" class="theme-btn-s3"><i class="fas fa-chevron-circle-right"></i> Get Info</a>-->
            </div>
          </div>
        </div>
        <!-- end slide-inner -->
      </div>
      <!-- end swiper-slide -->

      <div class="swiper-slide">
        <div class="slide-inner slide-bg-image" data-background="{{ asset('media').'/'.$listslide->tiga; }}">
          <div class="container">
            <div data-swiper-parallax="300" class="slide-title">
              <h2 style="color: transparent;">SigapLapor 1</h2>
            </div>
            <div data-swiper-parallax="400" class="slide-text">
              <p style="color: transparent;">Text description 1</p>
            </div>
            <div class="clearfix"></div>
            <div data-swiper-parallax="500" class="slide-btns">
              <!--<a href="#" class="theme-btn-s2">Register now</a>
              <a href="#" class="theme-btn-s3"><i class="fas fa-chevron-circle-right"></i> Get Info</a>-->
            </div>
          </div>
        </div>
        <!-- end slide-inner -->
      </div>
      <!-- end swiper-slide -->
    
     <div class="swiper-slide">
        <div class="slide-inner slide-bg-image" data-background="{{ asset('media').'/'.$listslide->empat; }}">
          <div class="container">
            <div data-swiper-parallax="300" class="slide-title">
              <h2 style="color: transparent;">SigapLapor 1</h2>
            </div>
            <div data-swiper-parallax="400" class="slide-text">
              <p style="color: transparent;">Text description 1</p>
            </div>
            <div class="clearfix"></div>
            <div data-swiper-parallax="500" class="slide-btns">
              <!--<a href="#" class="theme-btn-s2">Register now</a>
              <a href="#" class="theme-btn-s3"><i class="fas fa-chevron-circle-right"></i> Get Info</a>-->
            </div>
          </div>
        </div>
        <!-- end slide-inner -->
      </div>
      <!-- end swiper-slide -->
    </div>
    <!-- end swiper-wrapper -->

    <!-- swipper controls -->
    <div class="swiper-pagination"></div>
    <div class="swiper-button-next"></div>
    <div class="swiper-button-prev"></div>
  </div>
</section>
<!-- end of hero slider -->
<div class="row" style="height:30px"></div>
<div style="text-align: center; font-size: 30px; font-weight: bold; padding-bottom: 30px;">DATA PENANGANAN PELANGGARAN SE-INDONESIA</div>

<form name-frm action="{{ url('home') }}" method=post>
@csrf
<div class="row d-flex justify-content-center">
<div class="col-10 text-center">
<div class="form-group row justify-content-center">
    <div class="input-group col-sm-5">
        <select class='form-control select2' id=id_jenislaporan name=id_jenislaporan>
            <option value='2' {{ ($id_jenislaporan==2?'selected':'') }}>Pemilu</option>
            <option value='1' {{ ($id_jenislaporan==1||$id_jenislaporan==''||empty($id_jenislaporan)?'selected':'') }}>Pemilihan</option>
       </select>
           <div class="input-group-append">
            <button type=submit class="btn btn-outline-secondary">Cari</button>
          </div>
    </div>
</div>
</div>
</div>
</form>

<div class="row">
    <div class="col  d-flex justify-content-center">
        <div class="row" style="width:85%;">
            <div class="col-sm mb-2"><div id=grafik0 class="batas" style="width:330px;height:300px"></div></div>
            <div class="col-sm mb-2"><div id=grafik2 class="batas" style="width:330px;height:300px"></div></div>
            <div class="col-sm mb-2"><div id=grafik_pelanggaran class="batas" style="width:330px;height:300px"></div></div>
            <div class="col-sm mb-2"><div id=grafik3 class="batas" style="width:330px;height:300px"></div></div>
            <div class="col-sm mb-2"><div id=grafik4 class="batas" style="width:330px;height:300px"></div></div>
            <div class="col-sm mb-2"><div id=grafik5 class="batas" style="width:330px;height:300px"></div></div>
            <div class="col-sm mb-2"><div id=grafik6 class="batas" style="width:330px;height:300px"></div></div>
            <div class="col-sm mb-2"><div id=grafik7 class="batas" style="width:330px;height:300px"></div></div>
        </div>
    </div>
</div>


@php
$data_pelanggaran_nm="";$data_pelanggaran_pelanggaran="";$data_pelanggaran_bukanpelanggaran="";
if (!empty($data_pelanggaran)) {
   foreach ($data_pelanggaran as $row1) {
        $data_pelanggaran_nm.="'".$row1->periode."',";
        $data_pelanggaran_pelanggaran.=$row1->jml_pelanggaran.",";
        $data_pelanggaran_bukanpelanggaran.=$row1->jml_bukan_pelanggaran.",";
    }
}
$data_pelanggaran_pelanggaran=delkoma($data_pelanggaran_pelanggaran);
$data_pelanggaran_bukanpelanggaran=delkoma($data_pelanggaran_bukanpelanggaran);

$data1_nm="";$data1_laporan="";$data1_temuan="";
if (!empty($data1)) {
   foreach ($data1 as $row1) {
        $data1_nm.="'".$row1->periode."',";
        $data1_laporan.=$row1->jmllaporan.",";
        $data1_temuan.=$row1->jmltemuan.",";
    }
}
$data1_laporan=delkoma($data1_laporan);
$data1_temuan=delkoma($data1_temuan);

$data2_nm="";$data2_register="";$data2_tidakregister="";$data2_proses="";
if (!empty($data2)) {
   foreach ($data2 as $row2) {
        $data2_nm.="'".$row2->periode."',";
        $data2_register.=$row2->jmlregister.",";
        $data2_tidakregister.=$row2->jmltidakregister.",";
        $data2_proses.=$row2->jmlproses.",";
    }
}
$data2_register=delkoma($data2_register);
$data2_tidakregister=delkoma($data2_tidakregister);
$data2_proses=delkoma($data2_proses);

$data3_a["pct"]=0;
$data3_a["nama"]="";
$data3_b["pct"]=0;
$data3_b["nama"]="";
$data3_c["pct"]=0;
$data3_c["nama"]="";
$data3_d["pct"]=0;
$data3_d["nama"]="";
$data3_e["pct"]=0;
$data3_e["nama"]="";
if (!empty($data3)) {
    foreach ($data3 as $row) {
        if($row->id==1){
            $data3_a["pct"]=$row->pct;
            $data3_a["nama"]=$row->nama;
        }
        if($row->id==2){
            $data3_b["pct"]=$row->pct;
            $data3_b["nama"]=$row->nama;
        }
        if($row->id==3){
            $data3_c["pct"]=$row->pct;
            $data3_c["nama"]=$row->nama;
        }
        if($row->id==4){
            $data3_d["pct"]=$row->pct;
            $data3_d["nama"]=$row->nama;
        }
        if($row->id==5){
            $data3_e["pct"]=$row->pct;
            $data3_e["nama"]=$row->nama;
        }
    }
}

$data4_a["pct"]=0;
$data4_a["nama"]="";
$data4_b["pct"]=0;
$data4_b["nama"]="";
if (!empty($data4)) {
    foreach ($data4 as $row) {
        if($row->id==6){
            $data4_a["pct"]=$row->pct;
            $data4_a["nama"]=$row->nama;
        }
        if($row->id==7){
            $data4_b["pct"]=$row->pct;
            $data4_b["nama"]=$row->nama;
        }
    }
}

$data5_a["pct"]=0;
$data5_a["nama"]="";
$data5_b["pct"]=0;
$data5_b["nama"]="";
$data5_c["pct"]=0;
$data5_c["nama"]="";
if (!empty($data5)) {
    foreach ($data5 as $row) {
        if($row->id==8){
            $data5_a["pct"]=$row->pct;
            $data5_a["nama"]=$row->nama;
        }
        if($row->id==9){
            $data5_b["pct"]=$row->pct;
            $data5_b["nama"]=$row->nama;
        }
        if($row->id==10){
            $data5_c["pct"]=$row->pct;
            $data5_c["nama"]=$row->nama;
        }
    }
}

$data6_a["pct"]=0;
$data6_a["nama"]="";
$data6_b["pct"]=0;
$data6_b["nama"]="";
$data6_c["pct"]=0;
$data6_c["nama"]="";
if (!empty($data6)) {
    foreach ($data6 as $row) {
        if($row->id==11){
            $data6_a["pct"]=$row->pct;
            $data6_a["nama"]=$row->nama;
        }
        if($row->id==12){
            $data6_b["pct"]=$row->pct;
            $data6_b["nama"]=$row->nama;
        }
        if($row->id==13){
            $data6_c["pct"]=$row->pct;
            $data6_c["nama"]=$row->nama;
        }
    }
}

$data7_a["pct"]=0;
$data7_a["nama"]="";
$data7_b["pct"]=0;
$data7_b["nama"]="";
if (!empty($data7)) {
    foreach ($data7 as $row) {
        if($row->id==14){
            $data7_a["pct"]=$row->pct;
            $data7_a["nama"]=$row->nama;
        }
        if($row->id==15){
            $data7_b["pct"]=$row->pct;
            $data7_b["nama"]=$row->nama;
        }
    }
}
@endphp
<script>


    // HERO SLIDER
    var menu = [];
    jQuery('.swiper-slide').each( function(index){
        menu.push( jQuery(this).find('.slide-inner').attr("data-text") );
    });
    var interleaveOffset = 0.5;
    var swiperOptions = {
        loop: true,
        speed: 1000,
        parallax: true,
        autoplay: {
            delay: 6500,
            disableOnInteraction: false,
        },
        watchSlidesProgress: true,
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },

        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },

        on: {
            progress: function() {
                var swiper = this;
                for (var i = 0; i < swiper.slides.length; i++) {
                    var slideProgress = swiper.slides[i].progress;
                    var innerOffset = swiper.width * interleaveOffset;
                    var innerTranslate = slideProgress * innerOffset;
                    swiper.slides[i].querySelector(".slide-inner").style.transform =
                    "translate3d(" + innerTranslate + "px, 0, 0)";
                }
            },

            touchStart: function() {
              var swiper = this;
              for (var i = 0; i < swiper.slides.length; i++) {
                swiper.slides[i].style.transition = "";
              }
            },

            setTransition: function(speed) {
                var swiper = this;
                for (var i = 0; i < swiper.slides.length; i++) {
                    swiper.slides[i].style.transition = speed + "ms";
                    swiper.slides[i].querySelector(".slide-inner").style.transition =
                    speed + "ms";
                }
            }
        }
    };

    var swiper = new Swiper(".swiper-container", swiperOptions);

    // DATA BACKGROUND IMAGE
    var sliderBgSetting = $(".slide-bg-image");
    sliderBgSetting.each(function(indx){
        if ($(this).attr("data-background")){
            $(this).css("background-image", "url(" + $(this).data("background") + ")");
        }
    });

// end hero slider

Highcharts.chart('grafik_pelanggaran', {
    title: {
        text:"Jumlah Pelangaran/Bukan Pelanggaran {{($id_jenislaporan==2?'Pemilu':'Pemilihan')}}",
        style: {
            color: '#000',
            font: 'bold 14px "Trebuchet MS", Verdana, sans-serif'
        }
    },
    xAxis: {
        categories: ['']
    },
    plotOptions: {
        series: {
            borderRadiusTopLeft: '15%',
            borderRadiusTopRight: '15%'
        }
    },
    series: [{
           name: 'Pelanggaran',
           data: [{{$data_pelanggaran_pelanggaran}}],
              type: 'column',
           color: '#ff7900'

       }, {
           name: 'Bukan Pelanggaran',
           data: [{{$data_pelanggaran_bukanpelanggaran}}],
              type: 'column',
           color: '#e2b665'

       }
    ]
});
Highcharts.chart('grafik0', {
    title: {
        text:"Laporan & Temuan {{($id_jenislaporan==2?'Pemilu':'Pemilihan');}}",
        style: {
            color: '#000',
            font: 'bold 14px "Trebuchet MS", Verdana, sans-serif'
        }
    },
    xAxis: {
        categories: ['']
    },
    plotOptions: {
        series: {
            borderRadiusTopLeft: '15%',
            borderRadiusTopRight: '15%'
        }
    },
    series: [{
           name: 'Laporan',
           data: [{{$data1_laporan}}],
              type: 'column',
           color: '#ff7900'

       }, {
           name: 'Temuan',
           data: [{{$data1_temuan}}],
              type: 'column',
           color: '#e2b665'

       }
    ]
});
Highcharts.chart('grafik2', {
    title: {
        text:"Register, Unregister & Proses {{($id_jenislaporan==2?'Pemilu':'Pemilihan');}}",
        style: {
            color: '#000',
            font: 'bold 14px "Trebuchet MS", Verdana, sans-serif'
        }
    },

    xAxis: {
        categories: ['']
    },
    plotOptions: {
        series: {
            borderRadiusTopLeft: '15%',
            borderRadiusTopRight: '15%'
        }
    },
    series: [{
           name: 'Register',
           data: [{{$data2_register}}],
              type: 'column',
           color: '#ff7900'

       }, {
           name: 'Unregister',
           data: [{{$data2_tidakregister}}],
              type: 'column',
           color: '#e2b665'

       }, {
           name: 'Proses',
           data: [{{$data2_proses}}],
              type: 'column',
           color: '#eed3b5'

       }
    ]
});

Highcharts.chart('grafik3', {
   chart: {
     type: 'solidgauge',
     marginTop: 50
   },
   title: {
     text: "{{ $data3_judul->nama }}<br>(Total Penerusan {{$data3_judul->jml}} Rekomendasi)",
     style: {
        color: '#000',
        font: 'bold 14px "Trebuchet MS", Verdana, sans-serif'
     }
   },
   tooltip: {
     borderWidth: 0,
     backgroundColor: 'none',
     shadow: false,
     style: {
       fontSize: '16px'
     },
     pointFormat: '<span style="font-size:0.8em;">{series.name}</span>&nbsp;<span style="font-size:0.8em; color: {point.color}; font-weight: bold">{point.y}%</span>',
     positioner: function(labelWidth, labelHeight) {
       return {
         x: 150 - labelWidth / 2,
         y: 203
       };
     }
   },
   pane: {
     startAngle: 0,
     endAngle: 360,
     background: [{
       outerRadius: '116%',
       innerRadius: '100%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     },{
       outerRadius: '100%',
       innerRadius: '82%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }, {
       outerRadius: '82%',
       innerRadius: '66%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }, {
       outerRadius: '66%',
       innerRadius: '50%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }, {
       outerRadius: '50%',
       innerRadius: '34%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }]
   },
   yAxis: {
     min: 0,
     max: 100,
     lineWidth: 0,
     tickPositions: []
   },
   plotOptions: {
     solidgauge: {
       borderWidth: '10px',
       dataLabels: {
         enabled: false
       },
       linecap: 'round',
       stickyTracking: false
     }
   },
   legend: {
     labelFormatter: function() {
       return '<span style="text-weight:bold;color:' + this.userOptions.color + '">&nbsp;' + this.name + '</span>';
     },
     symbolWidth: 0
   },
   series: [{
     name: '{{$data3_a["nama"]}}',
     marker: {enabled:false},
     borderColor: '#e2b665',
     color: '#e2b665',
     data: [{
       color: '#e2b665',
       radius: '107%',
       innerRadius: '107%',
       y: {{$data3_a["pct"]}}
     }],
     showInLegend: true
   },{
     name: '{{$data3_b["nama"]}}',
     marker: {enabled:false},
     borderColor: '#ff7900',
     color: '#ff7900',
     data: [{
       color: '#ff7900',
       radius: '91%',
       innerRadius: '91%',
       y: {{$data3_b["pct"]}}
     }],
     showInLegend: true
   }, {
     name: '{{$data3_c["nama"]}}',
     marker: {enabled:false},
     borderColor: '#d60f1b',
     color: '#d60f1b',
     data: [{
       color: '#d60f1b',
       radius: '75%',
       innerRadius: '75%',
       y: {{$data3_c["pct"]}}
     }],
     showInLegend: true
   }, {
     name: '{{$data3_d["nama"]}}',
     marker: {enabled:false},
     borderColor: '#ba9c5c',
     color:'#ba9c5c',
     data: [{
       color: '#ba9c5c',
       radius: '59%',
       innerRadius: '59%',
       y: {{$data3_d["pct"]}}
     }],
     showInLegend: true
   }, {
     name: '{{$data3_e["nama"]}}',
     marker: {enabled:false},
     borderColor: '#ffc000',
     color:'#ffc000',
     data: [{
       color: '#ffc000',
       radius: '43%',
       innerRadius: '43%',
       y: {{$data3_e["pct"]}}
     }],
     showInLegend: true
   }]
 });

 Highcharts.chart('grafik4', {
   chart: {
     type: 'solidgauge',
     marginTop: 50
   },
   title: {
     text: '{{$data4_judul->nama}}<br>(Total Penerusan {{$data4_judul->jml}} Rekomendasi)',
     style: {
        color: '#000',
        font: 'bold 14px "Trebuchet MS", Verdana, sans-serif'
     }
   },
   tooltip: {
     borderWidth: 0,
     backgroundColor: 'none',
     shadow: false,
     style: {
       fontSize: '16px'
     },
     pointFormat: '<span style="font-size:0.8em;">{series.name}</span>&nbsp;<span style="font-size:0.8em; color: {point.color}; font-weight: bold">{point.y}%</span>',
     positioner: function(labelWidth, labelHeight) {
       return {
         x: 150 - labelWidth / 2,
         y: 225
       };
     }
   },
   pane: {
     startAngle: 0,
     endAngle: 360,
     background: [{
       outerRadius: '100%',
       innerRadius: '82%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }, {
       outerRadius: '82%',
       innerRadius: '66%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }]
   },
   yAxis: {
     min: 0,
     max: 100,
     lineWidth: 0,
     tickPositions: []
   },
   plotOptions: {
     solidgauge: {
       borderWidth: '10px',
       dataLabels: {
         enabled: false
       },
       linecap: 'round',
       stickyTracking: false
     }
   },
   legend: {
     labelFormatter: function() {
       return '<span style="text-weight:bold;color:' + this.userOptions.color + '">&nbsp;' + this.name + '</span>';
     },
     symbolWidth: 0
   },
   series: [{
     name: '{{$data4_a["nama"]}}',
     marker: {enabled:false},
     borderColor: '#ff7900',
     color: '#ff7900',
     data: [{
       color: '#ff7900',
       radius: '91%',
       innerRadius: '91%',
       y: {{$data4_a["pct"]}}
     }],
     showInLegend: true
   }, {
     name: '{{$data4_b["nama"]}}',
     marker: {enabled:false},
     borderColor: '#d60f1b',
     color: '#d60f1b',
     data: [{
       color: '#d60f1b',
       radius: '75%',
       innerRadius: '75%',
       y: {{$data4_b["pct"]}}
     }],
     showInLegend: true
   }]
 });

Highcharts.chart('grafik5', {
   chart: {
     type: 'solidgauge',
     marginTop: 50
   },
   title: {
     text: '{{$data5_judul->nama}}<br>(Total Penerusan {{$data5_judul->jml}} Rekomendasi)',
     style: {
        color: '#000',
        font: 'bold 14px "Trebuchet MS", Verdana, sans-serif'
     }
   },
   tooltip: {
     borderWidth: 0,
     backgroundColor: 'none',
     shadow: false,
     style: {
       fontSize: '16px'
     },
     pointFormat: '<span style="font-size:0.8em;">{series.name}</span>&nbsp;<span style="font-size:0.8em; color: {point.color}; font-weight: bold">{point.y}%</span>',
     positioner: function(labelWidth, labelHeight) {
       return {
         x: 150 - labelWidth / 2,
         y: 200
       };
     }
   },
   pane: {
     startAngle: 0,
     endAngle: 360,
     background: [{
       outerRadius: '100%',
       innerRadius: '82%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }, {
       outerRadius: '82%',
       innerRadius: '66%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }, {
       outerRadius: '66%',
       innerRadius: '50%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }]
   },
   yAxis: {
     min: 0,
     max: 100,
     lineWidth: 0,
     tickPositions: []
   },
   plotOptions: {
     solidgauge: {
       borderWidth: '10px',
       dataLabels: {
         enabled: false
       },
       linecap: 'round',
       stickyTracking: false
     }
   },
   legend: {
     labelFormatter: function() {
       return '<span style="text-weight:bold;color:' + this.userOptions.color + '">&nbsp;' + this.name + '</span>';
     },
     symbolWidth: 0
   },
   series: [{
     name: '{{$data5_a["nama"]}}',
     marker: {enabled:false},
     borderColor: '#ff7900',
     color: '#ff7900',
     data: [{
       color: '#ff7900',
       radius: '91%',
       innerRadius: '91%',
       y: {{$data5_a["pct"]}}
     }],
     showInLegend: true
   }, {
     name: '{{$data5_b["nama"]}}',
     marker: {enabled:false},
     borderColor: '#ba9c5c',
     color: '#ba9c5c',
     data: [{
       color: '#ba9c5c',
       radius: '75%',
       innerRadius: '75%',
       y: {{$data5_b["pct"]}}
     }],
     showInLegend: true
   }, {
     name: '{{$data5_c["nama"]}}',
     marker: {enabled:false},
     borderColor: '#d60f1b',
     color:'#d60f1b',
     data: [{
       color: '#d60f1b',
       radius: '59%',
       innerRadius: '59%',
       y: {{$data5_c["pct"]}}
     }],
     showInLegend: true
   }]
 });

Highcharts.chart('grafik6', {
   chart: {
     type: 'solidgauge',
     marginTop: 50
   },
   title: {
     text: '{{$data6_judul->nama}}<br>(Total Penerusan {{$data6_judul->jml}} Rekomendasi)',
     style: {
        color: '#000',
        font: 'bold 14px "Trebuchet MS", Verdana, sans-serif'
     }
   },
   tooltip: {
     borderWidth: 0,
     backgroundColor: 'none',
     shadow: false,
     style: {
       fontSize: '16px'
     },
     pointFormat: '<span style="font-size:0.8em;">{series.name}</span>&nbsp;<span style="font-size:0.8em; color: {point.color}; font-weight: bold">{point.y}%</span>',
     positioner: function(labelWidth, labelHeight) {
       return {
         x: 150 - labelWidth / 2,
         y: 225
       };
     }
   },
   pane: {
     startAngle: 0,
     endAngle: 360,
     background: [{
       outerRadius: '100%',
       innerRadius: '82%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }, {
       outerRadius: '82%',
       innerRadius: '66%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }, {
       outerRadius: '66%',
       innerRadius: '50%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }]
   },
   yAxis: {
     min: 0,
     max: 100,
     lineWidth: 0,
     tickPositions: []
   },
   plotOptions: {
     solidgauge: {
       borderWidth: '10px',
       dataLabels: {
         enabled: false
       },
       linecap: 'round',
       stickyTracking: false
     }
   },
   legend: {
     labelFormatter: function() {
       return '<span style="text-weight:bold;color:' + this.userOptions.color + '">&nbsp;' + this.name + '</span>';
     },
     symbolWidth: 0
   },
   series: [{
     name: '{{$data6_a["nama"]}}',
     marker: {enabled:false},
     borderColor: '#ff7900',
     color: '#ff7900',
     data: [{
       color: '#ff7900',
       radius: '91%',
       innerRadius: '91%',
       y: {{$data6_a["pct"]}}
     }],
     showInLegend: true
   }, {
     name: '{{$data6_b["nama"]}}',
     marker: {enabled:false},
     borderColor: '#ba9c5c',
     color: '#ba9c5c',
     data: [{
       color: '#ba9c5c',
       radius: '75%',
       innerRadius: '75%',
       y: {{$data6_b["pct"]}}
     }],
     showInLegend: true
   }, {
     name: '{{$data6_c["nama"]}}',
     marker: {enabled:false},
     borderColor: '#d60f1b',
     color:'#d60f1b',
     data: [{
       color: '#d60f1b',
       radius: '59%',
       innerRadius: '59%',
       y: {{$data6_c["pct"]}}
     }],
     showInLegend: true
   }]
 });
 
 Highcharts.chart('grafik7', {
   chart: {
     type: 'solidgauge',
     marginTop: 50
   },
   title: {
     text: '{{ isset($data7_judul->nama) ? $data7_judul->nama : "No title available"; }}<br>(Total Penerusan {{ isset($data7_judul->jml) ? $data7_judul->jml : 0; }} Rekomendasi)',
     style: {
        color: '#000',
        font: 'bold 14px "Trebuchet MS", Verdana, sans-serif'
     }
   },
   tooltip: {
     borderWidth: 0,
     backgroundColor: 'none',
     shadow: false,
     style: {
       fontSize: '16px'
     },
     pointFormat: '<span style="font-size:0.8em;">{series.name}</span>&nbsp;<span style="font-size:0.8em; color: {point.color}; font-weight: bold">{point.y}%</span>',
     positioner: function(labelWidth, labelHeight) {
       return {
         x: 150 - labelWidth / 2,
         y: 225
       };
     }
   },
   pane: {
     startAngle: 0,
     endAngle: 360,
     background: [{
       outerRadius: '100%',
       innerRadius: '82%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }, {
       outerRadius: '82%',
       innerRadius: '66%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }]
   },
   yAxis: {
     min: 0,
     max: 100,
     lineWidth: 0,
     tickPositions: []
   },
   plotOptions: {
     solidgauge: {
       borderWidth: '10px',
       dataLabels: {
         enabled: false
       },
       linecap: 'round',
       stickyTracking: false
     }
   },
   legend: {
     labelFormatter: function() {
       return '<span style="text-weight:bold;color:' + this.userOptions.color + '">&nbsp;' + this.name + '</span>';
     },
     symbolWidth: 0
   },
   series: [{
     name: '{{$data7_b["nama"]}}',
     marker: {enabled:false},
     borderColor: '#ff7900',
     color: '#ff7900',
     data: [{
       color: '#ff7900',
       radius: '91%',
       innerRadius: '91%',
       y: {{$data7_b["pct"]}}
     }],
     showInLegend: true
   }, {
     name: '{{$data7_a["nama"]}}',
     marker: {enabled:false},
     borderColor: '#d60f1b',
     color: '#d60f1b',
     data: [{
       color: '#d60f1b',
       radius: '75%',
       innerRadius: '75%',
       y: {{$data7_a["pct"]}}
     }],
     showInLegend: true
   }]
 });
</script>
    
    
    <div class=row style="height:20px"></div>
    <div class="row">
        <div class="col-1">
        </div>
        <div class="col-11 d-flex justify-content-left jdl1">
            <div>Informasi dan Data Penanganan Pelanggaran secara rinci pada tingkat RI, Provinsi dan Kabupaten/Kota Juga Dapat Diakses</div>
        </div>
    </div>
    <div class="row">
        <div class="col-1">
        </div>
        <div class="col-11 d-flex justify-content-left jdl1">
            <div>Level Data :</div>
        </div>
    </div>
    <form name=frm1>
	@csrf
    <div class="row">
        <div class="col-1">
        </div>
        <div class="col-11 d-flex justify-content-left">
            <ul class="icheck-list">
               <li>
                   <input type="radio" class="check wil_bawaslu" id="wil_bawaslu" name="wilayah" data-radio="iradio_square-red" value=1>
                   <label for="square-radio-1" class="wil_bawaslu">Bawaslu RI</label>
               </li>
               <li>
                   <input type="radio" class="check wil_provinsi" id="wil_provinsi" name="wilayah" data-radio="iradio_square-red" value=2>
                   <label for="square-radio-2">Propinsi</label><br>
               </li>
               <li>
                   <input type="radio" class="check wil_kabkota" id="wil_kabkota" name="wilayah" data-radio="iradio_square-red" value=3>
                   <label for="square-radio-2">Kota/Kabupaten</label><br>
                   <span class="sellevel hide" id=sel_provinsib>
                       <select style="width:200px" class='form-control select2' id=provinsib name=provb>
                            <option value=''>- Pilih Provinsi -</option>
                            @php
                                $zoom=7;
                                foreach($provinsi as $prov)
                                {
                                    if(substr($prov->kode,0,2)=='12'){
                                        $zoom=11;
                                    }
                                    elseif(substr($prov->kode,0,2)=='11'){
                                        $zoom=9;
                                    }
                                    elseif(substr($prov->kode,0,2)=='13'){
                                        $zoom=8;
                                    }
                                    echo '<option value="'.$prov->latitude.','.$prov->longitude.','.$prov->nama.','.$prov->kode.','.$zoom.'">'.$prov->nama.'</option>';
                                }
                           @endphp
                       </select>
                   </span>
               </li>
            </ul>
        </div>
        </form>
        <div class="col-6 d-flex justify-content-left">
        </div>
    </div>
    <div class="hide row justify-content-left pusat">
        <div class="col-2"></div>
        <div class="col-5 d-flex justify-content-center module">
            <a href="{{route('pemilihan')}}"><img src="{{asset('media/image/menu/pemilihan.png')}}" border=0 class=responsive></a>
        </div>
        <div class="col-5 d-flex justify-content-left module">
            <a href="{{route('pemilu')}}"><img src="{{asset('media/image/menu/pemilu.png')}}" class=responsive></a>
        </div>
    </div>
    <div class="row d-flex justify-content-left">
        <div  id=mapa class="col-12">
            <div id="map-canvas" class="hide col-sm-12" style="height:550px"></div>
        </div>
    </div>
    <div style="height:60px"></div>
    </div>
    </div>
</div>
<div class="modal fade transparent" id="Modal_Notif" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog transparent" role="document">
         
        <a href="https://forms.gle/mccxCVueaBVrCb3g7" target="_blank">
            <div class="modal-content transparent">
            <div class="tutup"  data-dismiss="modal">
                <img src="{{asset('media/image/close.png')}}" class="img-responsive" >
            </div>
            <img height=300 src="{{asset('media/image/survey4.png')}}" class="img-responsive  imgpopup" >
            </div>
        </a>
    </div>
</div>
<style>
.transparent{
    background:transparent!important;
    border:0px;
}
.imgpopup{
    border-radius:2em 0 2em 2em;
}
.tutup{
    position: absolute;
    top: -22px;
    right: -22px;
}
</style>
<script>
$(document).ready(function(){
$('#Modal_Notif').modal('show');
});
function goto(s){
    kd=$("input[name=wilayah]:checked").val();
    var w='';
    var sts=false;
    if(typeof(kd)=="undefined"){
        alert('Level data harus dipilih terlebih dahulu ')
    }
    else{
        if(kd==1){
            sts=true;
        }
        else if(kd==2){
            w=$('#provinsi').val();
            if(w==""){
                alert('Wilayah Propinsi harus dipilih terlebih dahulu');
            }
            else{
                sts=true;
            }
        }
        else if(kd==3){
            w=$('#hkabupaten').val();
            if(w==""||w==null){
                $("#sel_provinsi").addClass("hide");
                $("#sel_provinsi").removeClass("show");
                $("#sel_provinsib").removeClass("hide");
                $("#sel_kabupatenb").removeClass("hide");
                $("#sel_provinsib").addClass("show");
                $("#sel_kabupatenb").addClass("show");
                alert('Wilayah kabupaten harus dipilih terlebih dahulu');
            }
            else{
                sts=true;
            }
        }
    }
    if(sts){
        document.location.href=s+'/'+w;
    }
}
</script>
<style>

        .map-canvas {
            height: 550px;
            width: 1000px;
            max-width: 100%;
            max-height: 100%;
        }
</style>
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.5.1/dist/leaflet.css"
          integrity="sha512-xwE/Az9zrjBIphAcBb3F6JVqxf46+CDLwfLMHloNu6KEQCAWi6HcDUbeOfBIptF7tcCzusKFjFw2yuvEpDL9wQ=="
          crossorigin=""/>
<script src="https://unpkg.com/leaflet@1.5.1/dist/leaflet.js"
        integrity="sha512-GffPMF3RvMeYyc1LWMHtK8EbPv0iNZ8/oTtHPx9/cc2ILxQ+u905qIwdpULaqDkyBKgOaB57QTMg7ztg8Jm2Og=="
        crossorigin=""></script>
<code class="script-example">
<script>
     var geocoder;
    var map;
    var infoWindow;
    var mapOptions;
    var bounds;
     var wilp='';
    var g_lat=0.538659;
    var g_long=116.419389;
    var g_pesan="";
    var g_zoom=5;
    function initmap(){
         if(map != undefined || map != null){
            map.remove();
           $("#map-canvas").html("");
           $("#preMap").empty();
           $( "<div id=\"map-canvas\" style=\"height: 550px;\"></div>" ).appendTo("#preMap");
         }
         map = L.map('map-canvas').setView([g_lat,g_long], 14);
         map.invalidateSize();
         L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
             minZoom: 0,
             maxZoom: g_zoom,
             attribution: 'Map data © <a href="https://openstreetmap.org">OpenStreetMap</a> contributors'
         }).addTo(map);
    
    
         if(wilp!=''){
            arr_wil=wilp.split('#');
            for(var i=0;i<arr_wil.length;i++){
                arr_wild=arr_wil[i].split(',');
                lat=arr_wild[0];
                long=arr_wild[1];
                nama=arr_wild[2];
                kode=arr_wild[3];
                g_zoom=arr_wild[4];
                if(lat!=""&&lat!="undefined"&&long!=""&&long!="undefined"){
                    nm=nama+'<br><br><img src="{{asset("media/image/panah.png")}}" align=absmiddle>&nbsp;<a href="{{ url("/pemilihan") }}/'+kode+'"><font class="linkinfo">Pemilihan</font></a><br><img src="{{asset('media/image/panah.png')}}" align=absmiddle>&nbsp;<a href="{{ url("/pemilu") }}/'+kode+'"><font class="linkinfo">Pemilu</font></a>';
                    marker = L.marker([lat,long]).addTo(map);
                    marker.bindPopup(nm).openPopup();
                }
            }
         }
         
         
        if(g_pesan==""){g_pesan="Peta Wilayah Indonesia"}
        const popup = L.popup()
            .setLatLng([g_lat, g_long])
            .setContent(g_pesan)
            .openOn(map);
        
    }
    function setprop(){
        @php
            $s="";
            foreach($provinsi as $prov){
                $nama    =$prov->nama;
                $lat    =$prov->latitude;
                $lon    =$prov->longitude;
                $kode    =$prov->kode;
                $zoom    =7;
                if(substr($kode,0,2)=='12'){
                    $zoom    =11;
                }
                elseif(substr($kode,0,2)=='11'){
                    $zoom    =9;
                }
                elseif(substr($kode,0,2)=='13'){
                    $zoom    =8;
                }
                $s.=$lat.",".$lon.",".$nama.",".$kode.",".$zoom."#";
            }
            echo "wilp='".$s."';\n";
            //echo "initmap();\n";
        @endphp
    }
  </script>
</code>

<script>
  //$(document).ready(function(){
     $("#provinsib").change(function (){
        var m=$(this).val();
        arrm=m.split(',')
        kode=arrm[3];
        g_lat=arrm[0];
        g_long=arrm[1];
        g_zoom=parseInt(arrm[4]);
        g_pesan=arrm[2];
		/*
		var form_data = new FormData();
		form_data.append('id_prov', kode);
		form_data.append('_token', '{{csrf_token()}}')
		*/
        $.ajax({
            type: "GET",
            url: "{{route('add_ajax_kaba')}}/"+kode,
            contentType: false,
            processData: false,
            beforeSend: function() {
            },
            success: function(msg){
                $("#map-canvas").show();
                wilp=msg;
                initmap();
                
            },
            error: function(xhr, status, error) {
			  alert(xhr.responseText);
			}
        });
    })
    $('input[name="wilayah"]').on('ifClicked', function (event) {
        s=this.value;
        switch(s){
            case '1':
                $(".pusat").removeClass("hide");
                $(".pusat").addClass("show");
                $(".pusat").addClass("d-flex");
                $("#sel_provinsib").removeClass("show");
                $("#sel_provinsib").addClass("hide");
                $("#map-canvas").hide();
                break;
            case '2':
                setprop();
                $(".pusat").removeClass("show");
                $(".pusat").removeClass("d-flex");
                $(".pusat").addClass("hide");
                $("#sel_provinsib").removeClass("show");
                $("#sel_provinsib").addClass("hide");
                $("#map-canvas").show();
                initmap();
                break;
            case '3':
                $(".pusat").removeClass("show");
                $(".pusat").removeClass("d-flex");
                $(".pusat").addClass("hide");
                $("#sel_provinsib").removeClass("hide");
                $("#sel_provinsib").addClass("show");
                $("#map-canvas").hide();
                break;
        }
    });
 // });
</script>
<script src="{{asset('media/assets/node_modules/icheck/icheck.min.js')}}"></script>
<script src="{{asset('media/assets/node_modules/icheck/icheck.init.js')}}"></script>
@endsection