@extends('be.layout-index')
@section('content')
@php
	$modul="Sidang";
    $modula="m_sidang";
	$showlocus=0;
    if(session('be_uwilayah')=="0"||substr(session('be_uwilayah'),3,2)=='00'){
        $showlocus=1;
    }
@endphp
<script src="{{asset('media/js/datatables/js/jquery.dataTables.min1.js')}}"></script>
<script src="{{asset('media/js/datatables/js/dataTables.responsive.min1.js')}}"></script>
<link href="{{asset('media/js/datatables/js/responsive.dataTables.min1.css')}}" rel="stylesheet">
<style>
@media (max-width: 767px) {
    .table-responsive{
        overflow-x: auto;
        overflow-y: auto;
    }
}
@media (min-width: 767px) {
    .table-responsive{
        overflow: inherit !important; /* Sometimes needs !important */
    }
}
</style>
<style>
.borderless tr td{
    padding:2px;
    border:0;
    text-align:left;
    background-color:transparent!important;
}
.borderless tr{
    background-color:transparent!important;
}
</style>
<div style="padding:10px">
    <div class="row">
        <div class="col-12">
			@if(session('success'))
				<div class="col-5 alert alert-success alert-dismissible">
					<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
					{{ session('success') }}
				</div>
			@endif
			@if(session('failed'))
				<div class="col-5 alert alert-danger alert-dismissible">
					<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
					{{ session('failed') }}
				</div>
			@endif
			<div class="table-responsive">
            <table width="100%" class="table table-hover table-striped" id="mytable">
                <thead>
                    <tr>
						<th class="control sorting_asc" rowspan="1" colspan="1" style="width: 13px; display: none; background-image: none;" aria-label="" valign=top></th>
						<th width="1" class="d-none">id</th>
						<th width="1" class="d-none">no</th>
						<th width=18%>No Laporan/Temuan</th>
                        <th width=18%>Pelapor/Penemu</th>
						@if($showlocus==1)
							<th width=25%>Locus</th>
						@endif
						<th width=15%>Jadwal</th>
                        <th width=30%>Acara</th>
                        <th width=10% style="text-align: center;">Actions</th>
                    </tr>
                </thead>
				<tbody id="show_data"></tbody>
            </table>
			</div>
        </div>
    </div>        
</div>
<script type="text/javascript">
    $(document).ready(function () {
        $.fn.dataTableExt.oApi.fnPagingInfo = function (oSettings)
        {
            return {
                "iStart": oSettings._iDisplayStart,
                "iEnd": oSettings.fnDisplayEnd(),
                "iLength": oSettings._iDisplayLength,
                "iTotal": oSettings.fnRecordsTotal(),
                "iFilteredTotal": oSettings.fnRecordsDisplay(),
                "iPage": Math.ceil(oSettings._iDisplayStart / oSettings._iDisplayLength),
                "iTotalPages": Math.ceil(oSettings.fnRecordsDisplay() / oSettings._iDisplayLength)
            };
        };

        var t = $('#mytable').DataTable({
            "processing": true,
            "serverSide": true,
            "ajax": "{!!route('m_sidang.list_result').'/'.$ec_id_jenislaporan!!}",
			"responsive": {
			    details: {
			        type: "column",
			        target: "tr"
			    }
		    },
			"columnDefs": [
	            {
				    className: "control",
				    orderable: false,
				    targets:0,
					width:"5%",
	            },
	            {
	                "targets": [1],
	                "visible": false,
	                "searchable": false,
	            }
			],
	        "order": [[ 1, "desc" ]],
			"language": {
	            "search": "_INPUT_",
	            "searchPlaceholder": " Search"   
	        },
            "columns": [
				{"data": null,"class":"control d-lg-d-none"},
				{"data": "id","class":"d-none"},
				{"data": "no","class":"d-none"},
                {"data": null,
				 "render": function(data,type,full,meta){
					return $.parseHTML(data.no_ringkasan_short)[0]['wholeText'];
					}
				},
                {"data": "pelapornm"},
                @if($showlocus==1)
					{"data": "wilayahlocus"},
				@endif
                {"data": "tanggal_jadwal"},
                {"data": "proses_short"},
                {"data": null,
				 "render": function(data,type,full,meta){
					return $.parseHTML(data.aksi)[0]['wholeText'];
					}
				},
            ],
            "order": [[1, 'asc']],
            "aLengthMenu": [[10, 25, 50], [10, 25, 50]],
            "iDisplayLength": 10,
            "rowCallback": function (row, data, iDisplayIndex) {
                var info = this.fnPagingInfo();
                var page = info.iPage;
                var length = info.iLength;
                var index = page * length + (iDisplayIndex + 1);
                $('td:eq(0)', row).html(index);
            }
        });
    });
	g_initdatatable=1;
</script>
<!--MODAL DELETE-->
  <form id=del>
      <div class="modal fade" id="Modal_Delete" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="exampleModalLabel">Hapus {!!$modul!!}</h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body" id="nm_del"></div>
            <div class="modal-footer">
			  <input type="hidden" name="id_del" id="id_del">
              <button type="button" class="btn btn-secondary" data-dismiss="modal">No</button>
              <button type="button" type="submit" id="btn_delete" class="btn btn-primary">Yes</button>
            </div>
          </div>
        </div>
      </div>
  </form>
  <!--END MODAL DELETE-->
  <script>
	$(document).ready(function(){
		var a=0;
        $('#show_data').on('click','.item_delete',function(){
            var id = $(this).data('id');
            var nm = $(this).data('nm');
            $('#nm_del').html('<strong>{!!$modul!!} '+nm+' akan dihapus?</strong>');
            $('#Modal_Delete').modal('show');
            $('[name="id_del"]').val(id);
        });
        $('#btn_delete').on('click',function(){
            var id_del = $('#id_del').val();
            document.location.href="{!!route('m_sidang.del').'/'.$ec_id_jenislaporan!!}/"+id_del;
        });
	});
  </script>    
@endsection