@extends('be.layout-index')
@section('content')
@php
	$modul="Grafik Penanganan";
@endphp
<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/highcharts-more.js"></script>
<script src="https://code.highcharts.com/modules/exporting.js"></script>
<script src="https://rawgit.com/highcharts/rounded-corners/master/rounded-corners.js"></script>
<script src="https://code.highcharts.com/modules/solid-gauge.js"></script>
<link href="{{asset('media/assets/node_modules/icheck/skins/all.css')}}" rel="stylesheet">
<style>
.highcharts-figure, .highcharts-data-table table {
    min-width: 320px; 
    max-width: 800px;
    margin: 1em auto;
}

.highcharts-data-table table {
	font-family: Verdana, sans-serif;
	border-collapse: collapse;
	border: 1px solid #EBEBEB;
	margin: 10px auto;
	text-align: center;
	width: 100%;
	max-width: 500px;
}
.highcharts-data-table caption {
    padding: 1em 0;
    font-size: 1.2em;
    color: #555;
}
.highcharts-data-table th {
	font-weight: 600;
    padding: 0.5em;
}
.highcharts-data-table td, .highcharts-data-table th, .highcharts-data-table caption {
    padding: 0.5em;
}
.highcharts-data-table thead tr, .highcharts-data-table tr:nth-child(even) {
    background: #f8f8f8;
}
.highcharts-data-table tr:hover {
    background: #f1f7ff;
}
#grafik1, #sliders {
    min-width: 310px; 
    max-width: 800px;
    margin: 0 auto;
}
#grafik1 {
    height: 400px; 
}

.tbl{
	padding:5px;
	font-size:12px;
}
.font_tbl{
	padding-top:5px;
	padding-right:5px;
	padding-bottom:5px;
	font-size:12px;
}
.a{
	border:1px red;
}
.batas{
	border:1px solid #e3e3e3;
	border-radius: 10px;
	margin-left:5px;
	margin-right:5px;
}
.tbl th{
	text-align:center;
}
</style>
<link rel="stylesheet" href="{{asset('media/assets/css/select2.min.css')}}">
<link rel="stylesheet" href="{{asset('media/assets/css/select2-bootstrap.css')}}">

<script>
  	$(document).ready(function(){
       $("#provinsib").change(function (){
           var url = "{{route('add_ajax_kab')}}/"+$(this).val();
           $('#kabupatenb').load(url);
           return false;
       })
       $("#kabupatenb").change(function (){
           $('input[name="hkabupaten"]').val($(this).val())
           return false;
       })
	    $('input[name="wilayah"]').on('ifClicked', function (event) {
	        s=this.value;
			switch(s){
				case '1':
		            $("#sel_provinsi").removeClass("show");
		            $("#sel_provinsib").removeClass("show");
		            $("#sel_kabupatenb").removeClass("show");
					$("#sel_provinsi").addClass("hide");
		            $("#sel_provinsib").addClass("hide");
		            $("#sel_kabupatenb").addClass("hide");
					break;
				case '0':
		            $("#sel_provinsi").removeClass("show");
		            $("#sel_provinsib").removeClass("show");
		            $("#sel_kabupatenb").removeClass("show");
					$("#sel_provinsi").addClass("hide");
		            $("#sel_provinsib").addClass("hide");
		            $("#sel_kabupatenb").addClass("hide");
					break;
				case '2':
		            $("#sel_provinsi").removeClass("hide");
		            $("#sel_provinsi").addClass("show");
		            $("#sel_provinsib").removeClass("show");
		            $("#sel_kabupatenb").removeClass("show");
		            $("#sel_provinsib").addClass("hide");
		            $("#sel_kabupatenb").addClass("hide");
					break;
				case '3':
					$("#sel_provinsi").addClass("hide");
		            $("#sel_provinsi").removeClass("show");
		            $("#sel_provinsib").removeClass("hide");
		            $("#sel_kabupatenb").removeClass("hide");
		            $("#sel_provinsib").addClass("show");
		            $("#sel_kabupatenb").addClass("show");
					break;
			}
	    });
	 });
</script>
<link href="{{asset('media/dist/css/pages/form-icheck.css')}}" rel="stylesheet">
<form name=frm id=frm method=post>
@csrf
<div class=container>
@if(session('be_uwilayah')==0)
    <div class="row">
        <div class="col-11 d-flex justify-content-left">
			<ul class="icheck-list">
			   <li>
                   <input type="radio" class="check wil_bawaslu" id="wil_bawaslu" name="wilayah" data-radio="iradio_square-red" value=0 {!!($wilayah==0?'checked':'')!!}>
                   <label for="square-radio-1" class="wil_bawaslu">RI</label>
               </li>
			   <li>
                   <input type="radio" class="check wil_bawaslu" id="wil_bawaslu" name="wilayah" data-radio="iradio_square-red" value=1 {!!($wilayah==1?'checked':'')!!}>
                   <label for="square-radio-1" class="wil_bawaslu">Bawaslu RI</label>
               </li>
               <li>
                   <input type="radio" class="check wil_provinsi" id="wil_provinsi" name="wilayah" data-radio="iradio_square-red" value=2 {!!($wilayah==2?'checked':'')!!}>
                   <label for="square-radio-2">Propinsi</label><br>
				   <span class="sellevel {!!($wilayah==2?'show':'hide')!!}" id=sel_provinsi>
					   <select style="width:200px" class='form-control select2' id=provinsi name=prov>
							<option value=''>- Pilih -</option>
							@php 
								foreach($provinsi as $item){
									echo '<option value="'.$item->kode.'"';
									if($prov==$item->kode){ echo ' selected ';}
									echo '>'.$item->nama.'</option>';
								}
							@endphp
					   </select>
				   </span>
               </li>
               <li>
                   <input type="radio" class="check wil_kabkota" id="wil_kabkota" name="wilayah" data-radio="iradio_square-red" value=3 {!!($wilayah==3?'checked':'')!!}>
                   <label for="square-radio-2">Kota/Kabupaten</label><br>
				   <span class="sellevel {!!($wilayah==3?'show':'hide')!!}" id=sel_provinsib>
					   <select style="width:200px" class='form-control select2' id=provinsib name=provb>
							<option value=''>- Pilih -</option>
							@php 
								foreach($provinsi as $prov){
									echo '<option value="'.$prov->kode.'"';
									if($provb==$prov->kode){ echo ' selected ';}
									echo '>'.$prov->nama.'</option>';
								}
							@endphp
					   </select>
				   </span><br><br>
				   <span class="sellevel2 {!!($wilayah==3?'show':'hide')!!}" id=sel_kabupatenb>
						<select style="width:200px" name="kabb" class="form-control select2" id="kabupatenb">
							<option value=''>- Pilih -</option>
							@php 
								if(!empty($data_kabb)){
									foreach($data_kabb as $item){
										echo '<option value="'.$item->kode.'"';
										if($kabb==$item->kode){ echo ' selected ';}
										echo '>'.$item->nama.'</option>';
									}
								}
							@endphp
						</select>
				   </span>
               </li>
			</ul>
        </div>
    </div>
@elseif(substr(session('be_uwilayah'),3,2)=='00')
<div class="form-group row">
	<div class="col-sm-3">
	<select class='form-control select2' id=kaba name=kaba>
		<option value=''>- Pilih -</option>
		@php 
			if(!empty($data_kaba)){
				foreach($data_kaba as $item){
					echo '<option value="'.$item->kode.'"';
					if($kaba==$item->kode){ echo ' selected ';}
					echo '>'.$item->nama.'</option>';
				}
			}
		@endphp
   </select>
	</div>
</div>
@endif
<div class="form-group row">
	<div class="col-sm-3">
	<select class='form-control select2' id=id_jenislaporan name=id_jenislaporan>
		<option value='1' {!!($id_jenislaporan==1||$id_jenislaporan==''||empty($id_jenislaporan)?'selected':'')!!}>Pemilihan</option>
		<option value='2' {!!($id_jenislaporan==2?'selected':'')!!}>Pemilu</option>
   </select>
	</div>
</div>
<div style="height:15px"></div>
<div class="row">
	<div class="col-xs-12 col-md-12 col-sm-12">
		<div class="form-group row">
			<div class="col-sm-2 col-md-1">
				<a href="javascript:goto()" class="form-control btn btn-success btn-sm" style="padding:10px"><i class='fa fa-search'></i> Cari</a>
			</div>
		</div>
	</div>
</div>
<div class="row">
	<div class="col-sm" ><div id=grafik0 style="width:300px;height:300px"></div></div>
	<div class="col-sm" ><div id=grafik2 style="width:300px;height:300px"></div></div>
	<div class="col-sm" ><div id=grafik_pelanggaran style="width:300px;height:300px"></div></div>
	<div class="col-sm" ><div id=grafik3 style="width:300px;height:300px"></div></div>
	<div class="col-sm" ><div id=grafik4 style="width:300px;height:300px"></div></div>
	<div class="col-sm" ><div id=grafik5 style="width:300px;height:300px"></div></div>
	<div class="col-sm" ><div id=grafik6 style="width:300px;height:300px"></div></div>
	<div class="col-sm" ><div id=grafik7 style="width:300px;height:300px"></div></div>
	<div class="col-sm" ><div style="width:300px;height:1px"></div></div>
</div>
</div>
@php
$data_pelanggaran_nm="";$data_pelanggaran_pelanggaran="";$data_pelanggaran_bukanpelanggaran="";
if (!empty($data_pelanggaran)) {
   foreach ($data_pelanggaran as $row1) {
        $data_pelanggaran_nm.="'".$row1->periode."',";
        $data_pelanggaran_pelanggaran.=$row1->jml_pelanggaran.",";
        $data_pelanggaran_bukanpelanggaran.=$row1->jml_bukan_pelanggaran.",";
    }
}
$data_pelanggaran_pelanggaran=delkoma($data_pelanggaran_pelanggaran);
$data_pelanggaran_bukanpelanggaran=delkoma($data_pelanggaran_bukanpelanggaran);

$data1_nm="";$data1_laporan="";$data1_temuan="";
if (!empty($data1)) {
   foreach ($data1 as $row1) {
        $data1_nm.="'".$row1->periode."',";
        $data1_laporan.=$row1->jmllaporan.",";
        $data1_temuan.=$row1->jmltemuan.",";
    }
}
$data1_laporan=delkoma($data1_laporan);
$data1_temuan=delkoma($data1_temuan);

$data2_nm="";$data2_register="";$data2_tidakregister="";$data2_proses="";
if (!empty($data2)) {
   foreach ($data2 as $row2) {
        $data2_nm.="'".$row2->periode."',";
        $data2_register.=$row2->jmlregister.",";
        $data2_tidakregister.=$row2->jmltidakregister.",";
        $data2_proses.=$row2->jmlproses.",";
    }
}
$data2_register=delkoma($data2_register);
$data2_tidakregister=delkoma($data2_tidakregister);
$data2_proses=delkoma($data2_proses);

$data3_a["pct"]=0;
$data3_a["nama"]="";
$data3_b["pct"]=0;
$data3_b["nama"]="";
$data3_c["pct"]=0;
$data3_c["nama"]="";
$data3_d["pct"]=0;
$data3_d["nama"]="";
$data3_e["pct"]=0;
$data3_e["nama"]="";
if (!empty($data3)) {
    foreach ($data3 as $row) {
        if($row->id==1){
            $data3_a["pct"]=$row->pct;
            $data3_a["nama"]=$row->nama;
        }
        if($row->id==2){
            $data3_b["pct"]=$row->pct;
            $data3_b["nama"]=$row->nama;
        }
        if($row->id==3){
            $data3_c["pct"]=$row->pct;
            $data3_c["nama"]=$row->nama;
        }
        if($row->id==4){
            $data3_d["pct"]=$row->pct;
            $data3_d["nama"]=$row->nama;
        }
        if($row->id==5){
            $data3_e["pct"]=$row->pct;
            $data3_e["nama"]=$row->nama;
        }
    }
}

$data4_a["pct"]=0;
$data4_a["nama"]="";
$data4_b["pct"]=0;
$data4_b["nama"]="";
if (!empty($data4)) {
    foreach ($data4 as $row) {
        if($row->id==6){
            $data4_a["pct"]=$row->pct;
            $data4_a["nama"]=$row->nama;
        }
        if($row->id==7){
            $data4_b["pct"]=$row->pct;
            $data4_b["nama"]=$row->nama;
        }
    }
}

$data5_a["pct"]=0;
$data5_a["nama"]="";
$data5_b["pct"]=0;
$data5_b["nama"]="";
$data5_c["pct"]=0;
$data5_c["nama"]="";
if (!empty($data5)) {
    foreach ($data5 as $row) {
        if($row->id==8){
            $data5_a["pct"]=$row->pct;
            $data5_a["nama"]=$row->nama;
        }
        if($row->id==9){
            $data5_b["pct"]=$row->pct;
            $data5_b["nama"]=$row->nama;
        }
        if($row->id==10){
            $data5_c["pct"]=$row->pct;
            $data5_c["nama"]=$row->nama;
        }
    }
}

$data6_a["pct"]=0;
$data6_a["nama"]="";
$data6_b["pct"]=0;
$data6_b["nama"]="";
$data6_c["pct"]=0;
$data6_c["nama"]="";
if (!empty($data6)) {
    foreach ($data6 as $row) {
        if($row->id==11){
            $data6_a["pct"]=$row->pct;
            $data6_a["nama"]=$row->nama;
        }
        if($row->id==12){
            $data6_b["pct"]=$row->pct;
            $data6_b["nama"]=$row->nama;
        }
        if($row->id==13){
            $data6_c["pct"]=$row->pct;
            $data6_c["nama"]=$row->nama;
        }
    }
}

$data7_a["pct"]=0;
$data7_a["nama"]="";
$data7_b["pct"]=0;
$data7_b["nama"]="";
if (!empty($data7)) {
    foreach ($data7 as $row) {
        if($row->id==14){
            $data7_a["pct"]=$row->pct;
            $data7_a["nama"]=$row->nama;
        }
        if($row->id==15){
            $data7_b["pct"]=$row->pct;
            $data7_b["nama"]=$row->nama;
        }
    }
}
@endphp
</form>

<script>
Highcharts.chart('grafik_pelanggaran', {
    title: {
        text:"Jumlah Pelangaran/Bukan Pelanggaran {{($id_jenislaporan==2?'Pemilu':'Pemilihan')}}",
        style: {
            color: '#000',
            font: 'bold 14px "Trebuchet MS", Verdana, sans-serif'
        }
    },
    xAxis: {
        categories: ['']
    },
    plotOptions: {
        series: {
            borderRadiusTopLeft: '15%',
            borderRadiusTopRight: '15%'
        }
    },
    series: [{
           name: 'Pelanggaran',
           data: [{{$data_pelanggaran_pelanggaran}}],
              type: 'column',
           color: '#ff7900'

       }, {
           name: 'Bukan Pelanggaran',
           data: [{{$data_pelanggaran_bukanpelanggaran}}],
              type: 'column',
           color: '#e2b665'

       }
    ]
});
Highcharts.chart('grafik0', {
    title: {
        text:"Laporan & Temuan {{($id_jenislaporan==2?'Pemilu':'Pemilihan');}}",
        style: {
            color: '#000',
            font: 'bold 14px "Trebuchet MS", Verdana, sans-serif'
        }
    },
    xAxis: {
        categories: ['']
    },
    plotOptions: {
        series: {
            borderRadiusTopLeft: '15%',
            borderRadiusTopRight: '15%'
        }
    },
    series: [{
           name: 'Laporan',
           data: [{{$data1_laporan}}],
              type: 'column',
           color: '#ff7900'

       }, {
           name: 'Temuan',
           data: [{{$data1_temuan}}],
              type: 'column',
           color: '#e2b665'

       }
    ]
});
Highcharts.chart('grafik2', {
    title: {
        text:"Register, Unregister & Proses {{($id_jenislaporan==2?'Pemilu':'Pemilihan');}}",
        style: {
            color: '#000',
            font: 'bold 14px "Trebuchet MS", Verdana, sans-serif'
        }
    },

    xAxis: {
        categories: ['']
    },
    plotOptions: {
        series: {
            borderRadiusTopLeft: '15%',
            borderRadiusTopRight: '15%'
        }
    },
    series: [{
           name: 'Register',
           data: [{{$data2_register}}],
              type: 'column',
           color: '#ff7900'

       }, {
           name: 'Unregister',
           data: [{{$data2_tidakregister}}],
              type: 'column',
           color: '#e2b665'

       }, {
           name: 'Proses',
           data: [{{$data2_proses}}],
              type: 'column',
           color: '#eed3b5'

       }
    ]
});

Highcharts.chart('grafik3', {
   chart: {
     type: 'solidgauge',
     marginTop: 50
   },
   title: {
     text: "{{ $data3_judul->nama }}<br>(Total Penerusan {{$data3_judul->jml}} Rekomendasi)",
     style: {
        color: '#000',
        font: 'bold 14px "Trebuchet MS", Verdana, sans-serif'
     }
   },
   tooltip: {
     borderWidth: 0,
     backgroundColor: 'none',
     shadow: false,
     style: {
       fontSize: '16px'
     },
     pointFormat: '<span style="font-size:0.8em;">{series.name}</span>&nbsp;<span style="font-size:0.8em; color: {point.color}; font-weight: bold">{point.y}%</span>',
     positioner: function(labelWidth, labelHeight) {
       return {
         x: 150 - labelWidth / 2,
         y: 203
       };
     }
   },
   pane: {
     startAngle: 0,
     endAngle: 360,
     background: [{
       outerRadius: '116%',
       innerRadius: '100%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     },{
       outerRadius: '100%',
       innerRadius: '82%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }, {
       outerRadius: '82%',
       innerRadius: '66%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }, {
       outerRadius: '66%',
       innerRadius: '50%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }, {
       outerRadius: '50%',
       innerRadius: '34%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }]
   },
   yAxis: {
     min: 0,
     max: 100,
     lineWidth: 0,
     tickPositions: []
   },
   plotOptions: {
     solidgauge: {
       borderWidth: '10px',
       dataLabels: {
         enabled: false
       },
       linecap: 'round',
       stickyTracking: false
     }
   },
   legend: {
     labelFormatter: function() {
       return '<span style="text-weight:bold;color:' + this.userOptions.color + '">&nbsp;' + this.name + '</span>';
     },
     symbolWidth: 0
   },
   series: [{
     name: '{{$data3_a["nama"]}}',
     marker: {enabled:false},
     borderColor: '#e2b665',
     color: '#e2b665',
     data: [{
       color: '#e2b665',
       radius: '107%',
       innerRadius: '107%',
       y: {{$data3_a["pct"]}}
     }],
     showInLegend: true
   },{
     name: '{{$data3_b["nama"]}}',
     marker: {enabled:false},
     borderColor: '#ff7900',
     color: '#ff7900',
     data: [{
       color: '#ff7900',
       radius: '91%',
       innerRadius: '91%',
       y: {{$data3_b["pct"]}}
     }],
     showInLegend: true
   }, {
     name: '{{$data3_c["nama"]}}',
     marker: {enabled:false},
     borderColor: '#d60f1b',
     color: '#d60f1b',
     data: [{
       color: '#d60f1b',
       radius: '75%',
       innerRadius: '75%',
       y: {{$data3_c["pct"]}}
     }],
     showInLegend: true
   }, {
     name: '{{$data3_d["nama"]}}',
     marker: {enabled:false},
     borderColor: '#ba9c5c',
     color:'#ba9c5c',
     data: [{
       color: '#ba9c5c',
       radius: '59%',
       innerRadius: '59%',
       y: {{$data3_d["pct"]}}
     }],
     showInLegend: true
   }, {
     name: '{{$data3_e["nama"]}}',
     marker: {enabled:false},
     borderColor: '#ffc000',
     color:'#ffc000',
     data: [{
       color: '#ffc000',
       radius: '43%',
       innerRadius: '43%',
       y: {{$data3_e["pct"]}}
     }],
     showInLegend: true
   }]
 });

 Highcharts.chart('grafik4', {
   chart: {
     type: 'solidgauge',
     marginTop: 50
   },
   title: {
     text: '{{$data4_judul->nama}}<br>(Total Penerusan {{$data4_judul->jml}} Rekomendasi)',
     style: {
        color: '#000',
        font: 'bold 14px "Trebuchet MS", Verdana, sans-serif'
     }
   },
   tooltip: {
     borderWidth: 0,
     backgroundColor: 'none',
     shadow: false,
     style: {
       fontSize: '16px'
     },
     pointFormat: '<span style="font-size:0.8em;">{series.name}</span>&nbsp;<span style="font-size:0.8em; color: {point.color}; font-weight: bold">{point.y}%</span>',
     positioner: function(labelWidth, labelHeight) {
       return {
         x: 150 - labelWidth / 2,
         y: 225
       };
     }
   },
   pane: {
     startAngle: 0,
     endAngle: 360,
     background: [{
       outerRadius: '100%',
       innerRadius: '82%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }, {
       outerRadius: '82%',
       innerRadius: '66%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }]
   },
   yAxis: {
     min: 0,
     max: 100,
     lineWidth: 0,
     tickPositions: []
   },
   plotOptions: {
     solidgauge: {
       borderWidth: '10px',
       dataLabels: {
         enabled: false
       },
       linecap: 'round',
       stickyTracking: false
     }
   },
   legend: {
     labelFormatter: function() {
       return '<span style="text-weight:bold;color:' + this.userOptions.color + '">&nbsp;' + this.name + '</span>';
     },
     symbolWidth: 0
   },
   series: [{
     name: '{{$data4_a["nama"]}}',
     marker: {enabled:false},
     borderColor: '#ff7900',
     color: '#ff7900',
     data: [{
       color: '#ff7900',
       radius: '91%',
       innerRadius: '91%',
       y: {{$data4_a["pct"]}}
     }],
     showInLegend: true
   }, {
     name: '{{$data4_b["nama"]}}',
     marker: {enabled:false},
     borderColor: '#d60f1b',
     color: '#d60f1b',
     data: [{
       color: '#d60f1b',
       radius: '75%',
       innerRadius: '75%',
       y: {{$data4_b["pct"]}}
     }],
     showInLegend: true
   }]
 });

Highcharts.chart('grafik5', {
   chart: {
     type: 'solidgauge',
     marginTop: 50
   },
   title: {
     text: '{{$data5_judul->nama}}<br>(Total Penerusan {{$data5_judul->jml}} Rekomendasi)',
     style: {
        color: '#000',
        font: 'bold 14px "Trebuchet MS", Verdana, sans-serif'
     }
   },
   tooltip: {
     borderWidth: 0,
     backgroundColor: 'none',
     shadow: false,
     style: {
       fontSize: '16px'
     },
     pointFormat: '<span style="font-size:0.8em;">{series.name}</span>&nbsp;<span style="font-size:0.8em; color: {point.color}; font-weight: bold">{point.y}%</span>',
     positioner: function(labelWidth, labelHeight) {
       return {
         x: 150 - labelWidth / 2,
         y: 200
       };
     }
   },
   pane: {
     startAngle: 0,
     endAngle: 360,
     background: [{
       outerRadius: '100%',
       innerRadius: '82%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }, {
       outerRadius: '82%',
       innerRadius: '66%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }, {
       outerRadius: '66%',
       innerRadius: '50%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }]
   },
   yAxis: {
     min: 0,
     max: 100,
     lineWidth: 0,
     tickPositions: []
   },
   plotOptions: {
     solidgauge: {
       borderWidth: '10px',
       dataLabels: {
         enabled: false
       },
       linecap: 'round',
       stickyTracking: false
     }
   },
   legend: {
     labelFormatter: function() {
       return '<span style="text-weight:bold;color:' + this.userOptions.color + '">&nbsp;' + this.name + '</span>';
     },
     symbolWidth: 0
   },
   series: [{
     name: '{{$data5_a["nama"]}}',
     marker: {enabled:false},
     borderColor: '#ff7900',
     color: '#ff7900',
     data: [{
       color: '#ff7900',
       radius: '91%',
       innerRadius: '91%',
       y: {{$data5_a["pct"]}}
     }],
     showInLegend: true
   }, {
     name: '{{$data5_b["nama"]}}',
     marker: {enabled:false},
     borderColor: '#ba9c5c',
     color: '#ba9c5c',
     data: [{
       color: '#ba9c5c',
       radius: '75%',
       innerRadius: '75%',
       y: {{$data5_b["pct"]}}
     }],
     showInLegend: true
   }, {
     name: '{{$data5_c["nama"]}}',
     marker: {enabled:false},
     borderColor: '#d60f1b',
     color:'#d60f1b',
     data: [{
       color: '#d60f1b',
       radius: '59%',
       innerRadius: '59%',
       y: {{$data5_c["pct"]}}
     }],
     showInLegend: true
   }]
 });

Highcharts.chart('grafik6', {
   chart: {
     type: 'solidgauge',
     marginTop: 50
   },
   title: {
     text: '{{$data6_judul->nama}}<br>(Total Penerusan {{$data6_judul->jml}} Rekomendasi)',
     style: {
        color: '#000',
        font: 'bold 14px "Trebuchet MS", Verdana, sans-serif'
     }
   },
   tooltip: {
     borderWidth: 0,
     backgroundColor: 'none',
     shadow: false,
     style: {
       fontSize: '16px'
     },
     pointFormat: '<span style="font-size:0.8em;">{series.name}</span>&nbsp;<span style="font-size:0.8em; color: {point.color}; font-weight: bold">{point.y}%</span>',
     positioner: function(labelWidth, labelHeight) {
       return {
         x: 150 - labelWidth / 2,
         y: 225
       };
     }
   },
   pane: {
     startAngle: 0,
     endAngle: 360,
     background: [{
       outerRadius: '100%',
       innerRadius: '82%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }, {
       outerRadius: '82%',
       innerRadius: '66%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }, {
       outerRadius: '66%',
       innerRadius: '50%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }]
   },
   yAxis: {
     min: 0,
     max: 100,
     lineWidth: 0,
     tickPositions: []
   },
   plotOptions: {
     solidgauge: {
       borderWidth: '10px',
       dataLabels: {
         enabled: false
       },
       linecap: 'round',
       stickyTracking: false
     }
   },
   legend: {
     labelFormatter: function() {
       return '<span style="text-weight:bold;color:' + this.userOptions.color + '">&nbsp;' + this.name + '</span>';
     },
     symbolWidth: 0
   },
   series: [{
     name: '{{$data6_a["nama"]}}',
     marker: {enabled:false},
     borderColor: '#ff7900',
     color: '#ff7900',
     data: [{
       color: '#ff7900',
       radius: '91%',
       innerRadius: '91%',
       y: {{$data6_a["pct"]}}
     }],
     showInLegend: true
   }, {
     name: '{{$data6_b["nama"]}}',
     marker: {enabled:false},
     borderColor: '#ba9c5c',
     color: '#ba9c5c',
     data: [{
       color: '#ba9c5c',
       radius: '75%',
       innerRadius: '75%',
       y: {{$data6_b["pct"]}}
     }],
     showInLegend: true
   }, {
     name: '{{$data6_c["nama"]}}',
     marker: {enabled:false},
     borderColor: '#d60f1b',
     color:'#d60f1b',
     data: [{
       color: '#d60f1b',
       radius: '59%',
       innerRadius: '59%',
       y: {{$data6_c["pct"]}}
     }],
     showInLegend: true
   }]
 });
 
 Highcharts.chart('grafik7', {
   chart: {
     type: 'solidgauge',
     marginTop: 50
   },
   title: {
     text: '{{ isset($data7_judul->nama) ? $data7_judul->nama : "No title available"; }}<br>(Total Penerusan {{ isset($data7_judul->jml) ? $data7_judul->jml : 0; }} Rekomendasi)',
     style: {
        color: '#000',
        font: 'bold 14px "Trebuchet MS", Verdana, sans-serif'
     }
   },
   tooltip: {
     borderWidth: 0,
     backgroundColor: 'none',
     shadow: false,
     style: {
       fontSize: '16px'
     },
     pointFormat: '<span style="font-size:0.8em;">{series.name}</span>&nbsp;<span style="font-size:0.8em; color: {point.color}; font-weight: bold">{point.y}%</span>',
     positioner: function(labelWidth, labelHeight) {
       return {
         x: 150 - labelWidth / 2,
         y: 225
       };
     }
   },
   pane: {
     startAngle: 0,
     endAngle: 360,
     background: [{
       outerRadius: '100%',
       innerRadius: '82%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }, {
       outerRadius: '82%',
       innerRadius: '66%',
       //backgroundColor: Highcharts.Color('#e4e4e4').get(),
       borderWidth: 0
     }]
   },
   yAxis: {
     min: 0,
     max: 100,
     lineWidth: 0,
     tickPositions: []
   },
   plotOptions: {
     solidgauge: {
       borderWidth: '10px',
       dataLabels: {
         enabled: false
       },
       linecap: 'round',
       stickyTracking: false
     }
   },
   legend: {
     labelFormatter: function() {
       return '<span style="text-weight:bold;color:' + this.userOptions.color + '">&nbsp;' + this.name + '</span>';
     },
     symbolWidth: 0
   },
   series: [{
     name: '{{$data7_b["nama"]}}',
     marker: {enabled:false},
     borderColor: '#ff7900',
     color: '#ff7900',
     data: [{
       color: '#ff7900',
       radius: '91%',
       innerRadius: '91%',
       y: {{$data7_b["pct"]}}
     }],
     showInLegend: true
   }, {
     name: '{{$data7_a["nama"]}}',
     marker: {enabled:false},
     borderColor: '#d60f1b',
     color: '#d60f1b',
     data: [{
       color: '#d60f1b',
       radius: '75%',
       innerRadius: '75%',
       y: {{$data7_a["pct"]}}
     }],
     showInLegend: true
   }]
 });
</script>

<input type=hidden name=hkabupaten id=hkabupaten>
</form>
<script>
function goto(){
@if(session('be_uwilayah')=='0')
	kd=$("input[name=wilayah]:checked").val();
	var w='';
	var sts=false;
	if(typeof(kd)=="undefined"){
		alert('Level data harus dipilih terlebih dahulu ')
	}
	else{
		if(kd==0||kd==1){
			sts=true;
		}
		else if(kd==2){
			w=$('#provinsi').val();
			if(w==""){
				alert('Wilayah Propinsi harus dipilih terlebih dahulu');
			}
			else{
				sts=true;
			}
		}
		else if(kd==3){
			w=$('#hkabupaten').val();
			if(w==""||w==null){
				$("#sel_provinsi").addClass("hide");
	            $("#sel_provinsi").removeClass("show");
	            $("#sel_provinsib").removeClass("hide");
	            $("#sel_kabupatenb").removeClass("hide");
	            $("#sel_provinsib").addClass("show");
	            $("#sel_kabupatenb").addClass("show");
				alert('Wilayah kabupaten harus dipilih terlebih dahulu');
			}
			else{
				sts=true;
			}
		}
	}
	if(sts){
		$('#frm').submit();
	}
	else{
		return false;
	}
@else
	$('#frm').submit();
@endif
}
</script>
<script src="{{asset('media/assets/node_modules/icheck/icheck.min.js')}}"></script>
<script src="{{asset('media/assets/node_modules/icheck/icheck.init.js')}}"></script>
<script src="{{asset('media/assets/js/select2.full.js')}}"></script>
<script>
$(".select2").select2();
</script>
@endsection
