@extends('be.layout-index')
@section('content')
@php
	$modul="Notifikasi Admin";
	$modula="m_notifikasia";
@endphp
<script src="{{asset('media/js/datatables/js/jquery.dataTables.min1.js')}}"></script>
<script src="{{asset('media/js/datatables/js/dataTables.responsive.min1.js')}}"></script>
<link href="{{asset('media/js/datatables/js/responsive.dataTables.min1.css')}}" rel="stylesheet">
<style>
@media (max-width: 767px) {
    .table-responsive{
        overflow-x: auto;
        overflow-y: auto;
    }
}
@media (min-width: 767px) {
    .table-responsive{
        overflow: inherit !important; /* Sometimes needs !important */
    }
}
</style>
<div style="padding:10px">
    <div class="row">
        <div class="col-12">
			<div class="table-responsive">
            <table width="100%" class="table table-hover table-striped" id="mytable">
                <thead>
                    <tr>
                        <th class="control sorting_asc" rowspan="1" colspan="1" style="width: 13px; display: none; background-image: none;" aria-label="" valign=top></th>
						<th width="1" class="d-none">id</th>
                        <th width=25% >Tanggal</th>
						<th width=75% >Pesan</th>
                    </tr>
                </thead>
				<tbody id="show_data"></tbody>
            </table>
			</div>
        </div>
    </div>        
</div>
<script type="text/javascript">
    $(document).ready(function () {
        $.fn.dataTableExt.oApi.fnPagingInfo = function (oSettings)
        {
            return {
                "iStart": oSettings._iDisplayStart,
                "iEnd": oSettings.fnDisplayEnd(),
                "iLength": oSettings._iDisplayLength,
                "iTotal": oSettings.fnRecordsTotal(),
                "iFilteredTotal": oSettings.fnRecordsDisplay(),
                "iPage": Math.ceil(oSettings._iDisplayStart / oSettings._iDisplayLength),
                "iTotalPages": Math.ceil(oSettings.fnRecordsDisplay() / oSettings._iDisplayLength)
            };
        };

        var t = $('#mytable').DataTable({
            "processing": true,
            "serverSide": true,
            "ajax": "{!!route('m_notifikasia.list_result')!!}",
			"responsive": {
			    details: {
			        type: "column",
			        target: "tr"
			    }
		    },
			"columnDefs": [
	            {
				    className: "control",
				    orderable: false,
				    targets:0,
					width:"5%",
	            },
	            {
	                "targets": [1],
	                "visible": false,
	                "searchable": false,
	            }
			],
	        "order": [[ 1, "desc" ]],
			"language": {
	            "search": "_INPUT_",
	            "searchPlaceholder": " Search"   
	        },
            "columns": [
				{"data": null,"class":"control d-lg-d-none"},
				{"data": "id","class":"d-none"},
                {"data": "tanggal"},
                {"data": "pesan"},
            ],
            "order": [[1, 'asc']],
            "aLengthMenu": [[10, 25, 50], [10, 25, 50]],
            "iDisplayLength": 10,
            "rowCallback": function (row, data, iDisplayIndex) {
                var info = this.fnPagingInfo();
                var page = info.iPage;
                var length = info.iLength;
                var index = page * length + (iDisplayIndex + 1);
                $('td:eq(0)', row).html(index);
            }
        });
    });
	g_initdatatable=1;
</script>  
@endsection