<?php
namespace App\Models;

use App\Models\M_tindaklanjut_kategori;
use Illuminate\Database\Eloquent\Model;
use DB;

class M_tindaklanjut extends Model
{
	public $timestamps = false;
	const UPDATED_AT  = null;
    protected $primaryKey= 'id';
    protected $table = 't_tindaklanjut';
    protected $fillable = [
	'id_laporan',
	'id_status',
	'create_by',
	'create_date',
	'edit_by',
	'edit_date'
	];
	
	static function daftar($params = array()){
		$str="select a.*, b.stsposisi,b.locus, b.no, b.id_jenislaporan, c.nama pelapornm,
        d.rekomendasi_no rekomendasi_no,
        d.rekomendasi_file rekomendasi_file,
        (
        case
            when b.locus='0' then 'Bawaslu RI'
            when substr(b.locus,4,2)='00' then concat('Prop. ',d1.nama)
            when substr(b.locus,4,2)<>'00' then concat('Prop. ',d1.nama,'<br>Kab/Kot. ',d2.nama)
        end
        ) wilayahlocus,
        (case when a.id_status=1 then 'Tindak Lanjut' when a.id_status=0 then 'Tidak Tindak Lanjut' else '' end) statusnm 
		from t_tindaklanjut a
		inner join t_laporan b on b.id=a.id_laporan
		inner join t_user c on c.id_user=b.id_pelapor
		left join t_kajianakhir d on d.id_laporan=a.id_laporan
		left join m_provinsi d1 on substr(d1.kode,1,2)=substr(b.locus,1,2)
		left join m_kabkota d2 on d2.kode=b.locus
		where 1<2 
		";
		if (isset($params['id'])) {
			$str.=" and a.id=".$params['id'];
        }
		if (isset($params['id_periode'])){
			$str.=" and b.id_periode=".$params['id_periode'];
		}
		if (isset($params['id_jenislaporan'])){
			$str.=" and b.id_jenislaporan=".$params['id_jenislaporan'];
		}
		if (isset($params['id_pelapor'])){
			$str.=" and b.id_pelapor=".$params['id_pelapor'];
		}
		if (isset($params['locus'])) {
			$str.=" and b.locus='".$params['locus']."'";
        }
		$res=DB::select($str);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_index($params = array()){
		$str="select a.*, b.stsposisi,b.locus, b.no, b.id_jenislaporan, c.nama pelapornm,
        d.rekomendasi_no rekomendasi_no,
        d.rekomendasi_file rekomendasi_file,
        (
        case
            when b.locus='0' then 'Bawaslu RI'
            when substr(b.locus,4,2)='00' then concat('Prop. ',d1.nama)
            when substr(b.locus,4,2)<>'00' then concat('Prop. ',d1.nama,'<br>Kab/Kot. ',d2.nama)
        end
        ) wilayahlocus,
        (case when a.id_status=1 then 'Tindak Lanjut' when a.id_status=0 then 'Tidak Tindak Lanjut' else '' end) statusnm
		from t_tindaklanjut a
		inner join t_laporan b on b.id=a.id_laporan
		inner join t_user c on c.id_user=b.id_pelapor
		left join t_kajianakhir d on d.id_laporan=a.id_laporan
		left join m_provinsi d1 on substr(d1.kode,1,2)=substr(b.locus,1,2)
		left join m_kabkota d2 on d2.kode=b.locus
		where 1<2 
		";
		if (isset($params['id'])) {
			$str.=" and a.id=".$params['id'];
        }
		if (isset($params['id_periode'])){
			$str.=" and b.id_periode=".$params['id_periode'];
		}
		if (isset($params['id_jenislaporan'])){
			$str.=" and b.id_jenislaporan=".$params['id_jenislaporan'];
		}
		if (isset($params['id_pelapor'])){
			$str.=" and b.id_pelapor=".$params['id_pelapor'];
		}
		if (isset($params['locus'])){
			$locus=$params['locus'];
			if($locus=='0'){
				//do nothing
			}
			elseif(substr($locus,3,2)=='00'){
				$str.=" and substr(b.locus,1,2)='".substr($locus,0,2)."'";
			}
			else{
				$str.=" and b.locus='".$locus."'";
			}
		}
		$res=DB::select($str);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
    static function daftar_depan($params = array()){
		$res=DB::table("t_tindaklanjut as a")
			 ->join('t_laporan as b','b.id','=','a.id_laporan')
			 ->join("t_user as c",'c.id_user','=','b.id_pelapor')
			 ->leftJoin("t_kajianakhir as d",'d.id_laporan','=','a.id_laporan')
			 ->leftJoin("vw_tindaklanjut_kategori as f",'f.id_tindaklanjut','=','a.id')
			 ->selectRaw("a.*, b.stsposisi,b.locus, b.no, b.id_jenislaporan, c.nama pelapornm,
                        d.rekomendasi_no rekomendasi_no,
                        d.rekomendasi_file rekomendasi_file,
                        kategori,
                        (case when a.id_status=1 then 'Tindak Lanjut' when a.id_status=0 then 'Tidak Tindak Lanjut' else '' end) statusnm ");
		if (isset($params['id'])) {
			$res=$res->where('a.id',$params['id']);
		}
		if (isset($params['locus'])){
			$res=$res->where('b.locus', $params['locus']);
		}
		if (isset($params['id_jenislaporan'])){
			if($params['id_jenislaporan']==1){
				$res=$res->where('b.id_jenislaporan', $params['id_jenislaporan']);
			}
			elseif($params['id_jenislaporan']==2||$params['id_jenislaporan']==3){
				$res=$res->whereRaw(' (b.id_jenislaporan=2 or b.id_jenislaporan=3) ');
			}
		}
		if (isset($params['id_pelapor'])){
			$res=$res->where('b.id_pelapor', $params['id_pelapor']);
		}
		if (isset($params['cari'])){
			$res=$res->whereRaw("(lower(b.no) like '%".$params['cari']."%' or lower(kategori) like '%".$params['cari']."%' or lower(d.rekomendasi_no) like '%".$params['cari']."%') ");
		}
		$res=$res->orderBy("a.id", "desc");
		if (isset($params['start'])){
			$res=$res->limit($params['per_page'],$params['start']);
		}
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
    }
	static function getlaporan($params = array()) {
		$res=DB::table("t_tindaklanjut as a")
			 ->join('t_laporan as b','b.id','=','a.id_laporan')
			 ->selectRaw("b.stsposisi,b.no,b.locus, b.id_jenislaporan, b.no_registrasi");
		if (isset($params['id'])) {
			$res=$res->where('a.id',$params['id']);
		}
		if (isset($params['id_jenislaporan'])){
			$res=$res->where('b.id_jenislaporan', $params['id_jenislaporan']);
		}
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
    static function get_kategori($params = array()) {
		$res=DB::table("t_tindaklanjut_kategori as a")
			 ->leftJoin('m_kajianakhir_kategori as b','b.id','=','a.id_kategori')
			 ->leftJoin('m_tindaklanjut_status as c','c.id','=','a.id_status')
			 ->selectRaw("a.*, b.nama id_kategorinm, c.nama id_statusnm");
		if (isset($params['id_tindaklanjut'])) {
            $res=$res->where('a.id_tindaklanjut', $params['id_tindaklanjut']);
        }
        if (isset($params['id_kategori'])){
            $res=$res->where('a.id_kategori', $params['id_kategori']);
        }
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
    }
    static function get_tahapan_tindaklanjut($params = array()) {
		$res=DB::table("t_tindaklanjut_kategori_tahapan as a")
			 ->leftJoin('m_tindaklanjut_status as b','b.id','=','a.id_status')
			 ->selectRaw("a.*, b.nama id_tahapannm");
		if (isset($params['id_tindaklanjut'])) {
            $res=$res->where('a.id_tindaklanjut', $params['id_tindaklanjut']);
        }
        if (isset($params['id_tindaklanjut_kategori'])){
           $res=$res->where('a.id_tindaklanjut_kategori', $params['id_tindaklanjut_kategori']);
        }
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
    }
    static function gettahapan($params = array()) {
		$res=DB::table("t_kajianakhir_kategori as a")
			 ->join("t_kajianakhir as b","a.id_kajianakhir","=","b.id")
        	 ->leftJoin("m_kajianakhir_kategori as c","c.id","=","a.id_kat1")
			 ->selectRaw("a.id_kat1 id_kat, c.nama id_katnm")
			 ->where('b.id_laporan', $params['id_laporan']);
		$res=$res->get();
        return $res;
    }
    static function add($data = array()) {
		$affect_row=0;
		if(isset($data['id'])){
			if($data['id']==''){
				$data['id']=null;
			}
		}
		if(isset($data['id'])){
			$id=$data['id'];
			$res=M_tindaklanjut::where('id','=',$data['id'])->first();
			if (isset($data['id_laporan'])) {
	            $res->id_laporan=getinpa($data['id_laporan']);
	        }
	        if (isset($data['id_status'])) {
	            $res->id_status=getinpa($data['id_status']);
	        }
	        if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
	        if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
	        if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
	        if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$affect_row=1;
		}
		else{
			$res=new M_tindaklanjut;
			if (isset($data['id_laporan'])) {
	            $res->id_laporan=getinpa($data['id_laporan']);
	        }
	        if (isset($data['id_status'])) {
	            $res->id_status=getinpa($data['id_status']);
	        }
	        if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
	        if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
	        if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
	        if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$id=$res->id;
			if($id>0){
				$affect_row=1;
			}
		}
		return ($affect_row == 0) ? false : $id;
    }
    static function add_kategori($data = array()) {
		$affect_row=0;
		if(isset($data['id'])){
			if($data['id']==''){
				$data['id']=null;
			}
		}
		if(isset($data['id'])){
			$id=$data['id'];
			$res=M_tindaklanjut_kategori::where('id','=',$data['id'])->first();
			if (isset($data['id_tindaklanjut'])) {
	            $res->id_tindaklanjut=getinpa($data['id_tindaklanjut']);
	        }
	        if (isset($data['id_kategori'])) {
	            $res->id_kategori=getinpa($data['id_kategori']);
	        }
	        if (isset($data['id_status'])) {
	            $res->id_status=getinpa($data['id_status']);
	        }
			$res->save();
			$affect_row=1;
		}
		else{
			$res=new M_tindaklanjut_kategori;
			if (isset($data['id_tindaklanjut'])) {
	            $res->id_tindaklanjut=getinpa($data['id_tindaklanjut']);
	        }
	        if (isset($data['id_kategori'])) {
	            $res->id_kategori=getinpa($data['id_kategori']);
	        }
	        if (isset($data['id_status'])) {
	            $res->id_status=getinpa($data['id_status']);
	        }
			$res->save();
			$id=$res->id;
			if($id>0){
				$affect_row=1;
			}
		}
		return ($affect_row == 0) ? false : $id;
    }
    static function del_kategori($id) {
		DB::table('t_tindaklanjut_kategori')->where('id_tindaklanjut', $id)->delete();
		DB::table('t_tindaklanjut_kategori_tahapan')->where('id_tindaklanjut', $id)->delete();
    }
    static function add_tahapan($params = array(),$data=null){
		self::del_tahapan($params['id_tindaklanjut_kategori']);
		$res=DB::table('t_tindaklanjut_kategori_tahapan')->insert($data);
		return $res;
    }
    static function del_tahapan($id) {
		DB::table('t_tindaklanjut_kategori_tahapan')->where('id_tindaklanjut', $id)->delete();
    }
    static function del($id) {
		DB::table('t_tindaklanjut')->where('id', $id)->delete();
		DB::table('t_tindaklanjut_kategori')->where('id_tindaklanjut', $id)->delete();
		DB::table('t_tindaklanjut_kategori_tahapan')->where('id_tindaklanjut', $id)->delete();
    }
}
