<?php
namespace App\Models;

use DB;
use Illuminate\Database\Eloquent\Model;

class M_laporan extends Model
{
    public $timestamps = false;
	const UPDATED_AT  = null;
    protected $primaryKey= 'id';
	protected $table = 't_laporan';
    protected $fillable = [
	'id_periode',
	'id_pelapor',
	'id_tahapan',
	'no',
	'no_offline',
	'tgl_offline',
	'no_registrasi',
	'id_jenislaporan',
	'id_jenispemilihan',
	'wilprovinsi',
	'wilkabkota',
	'ringkasan',
	'jenistempatkejadian',
	'locus',
	'kecamatan',
	'keterangan',
	'kejadianprovinsi',
	'kejadiankabkota',
	'kejadianalamat',
	'kejadiannegara',
	'waktukejadian',
	'waktukejadian_time',
	'waktudiketahui',
	'waktudiketahui_time',
	'uraian',
	'penerimalap',
	'stsvalid',
	'stsvalid_by',
	'stsvalid_date',
	'stsvalidbukti',
	'stsvalidbukti_by',
	'stsvalidbukti_date',
	'stsvalidperbaikan',
	'stsvalidperbaikan_by',
	'stsvalidperbaikan_date',
	'stsdibuat',
	'ststsm',
	'ststrack',
	'stslap',
	'stslap_by',
	'stslap_date',
	'stsposisi',
	'jmlupdate',
	'create_by',
	'create_date',
	'edit_by',
	'edit_date',
	'tgl_registrasi',
	'wilkecamatan',
	'kejadiankecamatan',
	'no_registrasi2'
	];
	
	static function str_query(){
		$sql="select  a.id_jenislaporan,
				concat(g.nama,
				coalesce((case 
				when id_jenispemilihan=1 or id_jenispemilihan=5 or id_jenispemilihan=6 or id_jenispemilihan=8 then concat('<br>Propinsi : ',b.nama)
				when id_jenispemilihan=2 or id_jenispemilihan=7 then concat('<br>Propinsi : ',b.nama,'<br>Kabupaten/Kota : ',c.nama)
				when id_jenispemilihan=3 then concat('<br>Propinsi : ',b.nama,'<br>Walikota : ',c.nama)
				end ),'')) jeniswilpemilihan,
				(case when stsvalid=1 then 'Laporan sudah divalidasi' else '' end) stsvalidnama,
				(case
				when a.jenistempatkejadian='Dalam Negeri' then
				  concat(kejadianalamat,', ',(case when coalesce(e.nama,'')<>'' then concat(coalesce(e.nama,''),', ') else '' end),d.nama)
				when a.jenistempatkejadian='Luar Negeri' then
				  a.kejadianalamat
				end) tempatkejadian, ii.terlapor,
				a.*,b.nama wilprovinsinm, c.nama wilkabkotanm, d.nama kejadianprovinsinm, 
				e.nama kejadiankabkotanm, f.nama jenislaporannm,g.nama jenispemilihannm,h.nama pelapornm,h.wilayah,h.id_katpelapor,
				i.nama stsvalidnm,l.nama stsvalidbuktinm,m.nama stsvalidperbaikannm,
				(
				case 
					when locus='0' then 'Jakarta'
					when substr(locus,4,2)='00' then j.nama
					when substr(locus,4,2)<>'00' then concat(k.nama,(case when coalesce(kecamatan,'')<>'' then concat(' Kecamatan ',kecamatan) end))
				end
				) locusnm,
				(
				case 
					when locus='0' then 'Bawaslu RI'
					when substr(locus,4,2)='00' then concat('Bawaslu Provinsi ',j.nama)
					when substr(locus,4,2)<>'00' then concat('Bawaslu ',k.nama,(case when coalesce(kecamatan,'')<>'' then concat(' Kecamatan ',kecamatan) end))
				end
				) locusnma,
				(
				case 
					when a.locus='0' then 'Bawaslu RI'
					when substr(a.locus,4,2)='00' then concat('Prop. ',d1.nama)
					when substr(a.locus,4,2)<>'00' then concat('Prop. ',d1.nama,'<br>Kab/Kot. ',d2.nama,(case when coalesce(kecamatan,'')<>'' then concat('<br>Kecamatan: ',kecamatan) end))
				end
				) wilayahlocus,
				(case ststsm when 1 then 'Pelaporan TSM' else 'Bukan TSM' end) ststsmnm,n.nama tahapannm,
				(case when a.stslap_by=-1 then 'system' else o.nama end) stslap_bynm
				from t_laporan a
				left join m_provinsi b on b.kode=a.wilprovinsi
				left join m_kabkota c on c.kode=a.wilkabkota
				left join m_provinsi d on d.kode=a.kejadianprovinsi
				left join m_kabkota e on e.kode=a.kejadiankabkota
				left join m_jenislaporan f on f.id=a.id_jenislaporan
				left join m_jenispemilihan g on g.id=a.id_jenispemilihan
				left join t_user h on h.id_user=a.id_pelapor
				left join m_user i on i.id_user=a.stsvalid_by
				left join m_provinsi j on j.kode=a.locus
				left join m_kabkota k on k.kode=a.locus
				left join m_user l on l.id_user=a.stsvalidbukti_by
				left join m_user m on m.id_user=a.stsvalidperbaikan_by
				left join m_tahapan n on n.id=a.id_tahapan
				left join m_user o on o.id_user=a.stslap_by
				left join m_provinsi d1 on substr(d1.kode,1,2)=substr(a.locus,1,2)
				left join m_kabkota d2 on d2.kode=a.locus
				left join 
				(SELECT id_laporan,
				   GROUP_CONCAT(nama SEPARATOR ', ') terlapor
				FROM t_terlapor
				GROUP BY id_laporan) ii on ii.id_laporan=a.id
				where 1<2 ";
		return $sql;
	}
	function str_querylist(){
		$sql="select a.*,
				concat(g.nama,
				coalesce((case 
				when id_jenispemilihan=1 or id_jenispemilihan=5 or id_jenispemilihan=6 or id_jenispemilihan=8 then concat('<br>Propinsi : ',b.nama)
				when id_jenispemilihan=2 or id_jenispemilihan=7 then concat('<br>Propinsi : ',b.nama,'<br>Kabupaten/Kota : ',c.nama)
				when id_jenispemilihan=3 then concat('<br>Propinsi : ',b.nama,'<br>Walikota : ',c.nama)
				end ),'')) jeniswilpemilihan,
				(case
				when a.jenistempatkejadian='Dalam Negeri' then
				  concat(kejadianalamat,', ',(case when coalesce(e.nama,'')<>'' then concat(coalesce(e.nama,''),', ') else '' end),d.nama)
				when a.jenistempatkejadian='Luar Negeri' then
				  a.kejadianalamat
				end) tempatkejadian,ii.terlapor
				from t_laporan a
				left join m_provinsi b on b.kode=a.wilprovinsi
				left join m_kabkota c on c.kode=a.wilkabkota
				left join m_provinsi d on d.kode=a.kejadianprovinsi
				left join m_kabkota e on e.kode=a.kejadiankabkota
				left join m_jenispemilihan g on g.id=a.id_jenispemilihan
				left join 
				(SELECT id_laporan,
				   GROUP_CONCAT(nama SEPARATOR ', ') terlapor
				FROM t_terlapor
				GROUP BY id_laporan) ii on ii.id_laporan=a.id
				where 1<2 ";
		return $sql;
	}
	static function daftar_index($params = array()){
		$sql=self::str_query();
		if (isset($params['id'])){
			$sql.=' and a.id='.$params['id'];
		}
		if (isset($params['id_pelapor'])){
			$sql.=' and id_pelapor='.$params['id_pelapor'];
		}
		if (isset($params['id_periode'])){
			$sql.=" and id_periode=".$params['id_periode'];
		}
		if (isset($params['locus'])) {
			$locus=$params['locus'];
			if($locus=='0'){
				//do nothing
			}
			elseif(substr($locus,3,2)=='00'){
            	$sql.=" and substr(locus,1,2)='".substr($locus,0,2)."'";
			}
			else{
				$sql.=" and locus='".$locus."'";
			}
        }
		if (isset($params['id_jenislaporan'])){
			$sql.=" and a.id_jenislaporan='".$params['id_jenislaporan']."'";
		}
		$sql.=' and coalesce(a.stslap,0)<>2';
		$res=DB::select($sql);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_indexall($params = array()){
		$sql=self::str_query();
		if (isset($params['id'])){
			$sql.=' and a.id='.$params['id'];
		}
		if (isset($params['id_pelapor'])){
			$sql.=' and id_pelapor='.$params['id_pelapor'];
		}
		if (isset($params['id_periode'])){
			$sql.=" and id_periode=".$params['id_periode'];
		}
		if (isset($params['locus'])) {
			$locus=$params['locus'];
			if($locus=='0'){
				//do nothing
			}
			elseif(substr($locus,3,2)=='00'){
            	$sql.=" and substr(locus,1,2)='".substr($locus,0,2)."'";
			}
			else{
				$sql.=" and locus='".$locus."'";
			}
        }
		if (isset($params['id_jenislaporan'])){
			$sql.=" and a.id_jenislaporan='".$params['id_jenislaporan']."'";
		}
		$res=DB::select($sql);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_fm($params = array()) {
		$sql=self::str_query();
		if (isset($params['id'])){
			$sql.=' and a.id='.$params['id'];
		}
		if (isset($params['id_pelapor'])){
			$sql.=' and id_pelapor='.$params['id_pelapor'];
		}
		if (isset($params['id_periode'])){
			$sql.=" and id_periode=".$params['id_periode'];
		}
		if (isset($params['locus'])) {
			$locus=$params['locus'];
			if($locus=='0'){
				//do nothing
			}
			elseif(substr($locus,3,2)=='00'){
            	$sql.=" and substr(locus,1,2)='".substr($locus,0,2)."'";
			}
			else{
				$sql.=" and locus='".$locus."'";
			}
        }
		if (isset($params['id_jenislaporan'])){
			$sql.=" and a.id_jenislaporan='".$params['id_jenislaporan']."'";
		}
		$res=DB::select($sql);
		if (isset($params['id'])) {
            $res=$res[0];
        }
        return $res;
	}
	static function daftar_perjenislaporan($params = array()) {
		$sql=self::str_query();
		if (isset($params['id'])){
			$sql.=' and a.id='.$params['id'];
		}
		if (isset($params['id_pelapor'])){
			$sql.=' and a.id_pelapor='.$params['id_pelapor'];
		}
		if (isset($params['id_periode'])){
			$sql.=" and a.id_periode=".$params['id_periode'];
		}
		if (isset($params['locus'])){
			$sql.=" and a.locus='".$params['locus']."'";
		}
		if (isset($params['id_jenislaporan'])){
			$sql.=" and a.id_jenislaporan='".$params['id_jenislaporan']."'";
		}
		//$sql.=' and coalesce(a.stslap,0)<>2';
		if (isset($params['start'])){
			$sql.=" limit ".$params['start'].", ".$params['per_page'];
		}
		//echo $sql;
		//die();
		$res=DB::select($sql);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_unreg($params = array()){
		$sql="select * from vw_laporan a where 1<2 ";
		if (isset($params['id'])){
			$sql.=' and a.id='.$params['id'];
		}
		if (isset($params['id_periode'])){
			$sql.=" and a.id_periode=".$params['id_periode'];
		}
		if (isset($params['locus'])) {
			$locus=$params['locus'];
			if($locus=='0'){
				//do nothing
			}
			elseif(substr($locus,3,2)=='00'){
            	$sql.=" and substr(a.locus,1,2)='".substr($locus,0,2)."'";
			}
			else{
				$sql.=" and a.locus='".$locus."'";
			}
        }
		if (isset($params['id_jenislaporan'])){
			$sql.=" and a.id_jenislaporan='".$params['id_jenislaporan']."'";
		}
		$sql.=' and coalesce(a.stslap,0)=2';
		$res=DB::select($sql);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function updno($data = array()) {
		$affect_row =0;
		if(isset($data['id'])){
			if($data['id']!=''){
				$res=M_laporan::where('id','=',$data['id'])->first();
				$res->no=getinpa($data['no']);
				if(isset($data['edit_by'])){
					$res->edit_by=getinpa($data['edit_by']);
				}
				if(isset($data['edit_date'])){
					$res->edit_date=getinpa($data['edit_date']);
				}
				$res->save();
				$affect_row=1;
			}
		}
   		return ($affect_row == 0) ? FALSE : TRUE;
    }
	static function updreg($data = array()) {
		$affect_row =0;
		if(isset($data['id'])){
			if($data['id']!=''){
				$res=M_laporan::where('id','=',$data['id'])->first();
				$res->no_registrasi=getinpa($data['reg']);
				$res->no_registrasi2=getinpa($data['reg2']);
				if(isset($data['edit_by'])){
					$res->edit_by=getinpa($data['edit_by']);
				}
				if(isset($data['edit_date'])){
					$res->edit_date=getinpa($data['edit_date']);
				}
				$res->save();
				$affect_row=1;
			}
		}
   		return ($affect_row == 0) ? FALSE : TRUE;
    }
	static function daftarputusan($params = array()) {
		$sql="select * from (select a.*,
			(select aa.tanggal from t_sidang_proses aa where aa.id_step=10 and 
			aa.id_sidang=c.id limit 1 ) tanggal, c.id id_sidang,
			b.nama pelapornm
			from t_laporan a 
			inner join t_user b on b.id_user=a.id_pelapor 
			inner join t_sidang c on c.id_laporan=a.id
			where c.id in (
			select id_sidang from t_sidang_proses cc where cc.id_step=10 and 
			cc.id_sidang=c.id) ) aa where 1< 2
			";
		if (isset($params['id'])){
			$sql.=' and id='.$params['id'];
		}
		if (isset($params['id_pelapor'])){
			$sql.=' and id_pelapor='.$params['id_pelapor'];
		}
		if (isset($params['id_periode'])){
			$sql.=" and id_periode=".$params['id_periode'];
		}
		if (isset($params['locus'])){
			$sql.=" and locus='".$params['locus']."'";
		}
		if (isset($params['id_jenislaporan'])){
			if($params['id_jenislaporan']==1){
				$sql.=" and id_jenislaporan=1";
			}
			elseif($params['id_jenislaporan']==2||$params['id_jenislaporan']==3){
				$sql.=" and (id_jenislaporan=2 or id_jenislaporan=3)";
			}
		}
		if (isset($params['cari'])){
			$sql.=" and (lower(no) like '%".strtolower($params['cari'])."%' or lower(ringkasan) like '%".strtolower($params['cari'])."%' or lower(pelapornm) like '%".strtolower($params['cari'])."%' or lower(sf_formatTanggal(tanggal)) like '%".strtolower($params['cari'])."%' )";
		}
		$sql.=" order by id desc";
		if (isset($params['start'])){
			$sql.=" limit ".$params['start'].", ".$params['per_page'];
		}
		//echo $sql;
		$res=DB::select($sql);
		if (isset($params['id'])) {
            $res=$res[0];
        }
		return $res;
	}
	static function daftarputusanlama($params = array()) {
		$sql="select * from tmp_laporan where 1<2 ";
		if (isset($params['cari'])){
			$sql.=" and (lower(no) like '%".strtolower($params['cari'])."%' or lower(no_keputusan) like '%".strtolower($params['cari'])."%')";
		}
		$sql.=" order by no asc";
		if (isset($params['start'])){
			$sql.=" limit ".$params['start'].", ".$params['per_page'];
		}
		$res=DB::select($sql);
        return $res;
	}
	static function daftara($params = array()) {
		$res=DB::table("vw_laporan");
		if (isset($params['id'])) {
			$res=$res->where('id', "=", $params['id']);
        }
		if (isset($params['id_periode'])){
			$res=$res->where('id_periode', "=", $params['id_periode']);
		}
		if (isset($params['locus'])){
			$res=$res->where('locus', "=", $params['locus']);
		}
		if (isset($params['id_jenislaporan'])){
			$res=$res->where('id_jenislaporan', "=", $params['id_jenislaporan']);
		}
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function addpelaporlain($params = array(),$data=null){
		self::delpelaporlain($params['id_laporan']);
		$res=DB::table('t_pelaporlain')->insert($data);
		return $res;
	}
	static function delpelaporlain($id,$urut=null) {
		$res=DB::table('t_pelaporlain')->where('id_laporan','=',$id);
		if(isset($urut)){
			$res=$res->where('urut','=',$urut);
		}
		$res=$res->delete();
		return $res;
    }
	
	static function addterlapor($params = array(),$data=null){
		self::delterlapor($params['id_laporan']);
		$res=DB::table('t_terlapor')->insert($data);
		return $res;
	}
	static function delterlapor($id,$urut=null) {
		$res=DB::table('t_terlapor')->where('id_laporan','=',$id);
		if(isset($urut)){
			$res=$res->where('urut','=',$urut);
		}
		$res=$res->delete();
		return $res;
    }
	static function addsaksi($params = array(),$data=null){
		self::delsaksi($params['id_laporan']);
		$res=DB::table('t_saksi')->insert($data);
		return $res;
	}
	static function delsaksi($id,$urut=null) {
		$res=DB::table('t_saksi')->where('id_laporan','=',$id);
		if(isset($urut)){
			$res=$res->where('urut','=',$urut);
		}
		$res=$res->delete();
		return $res;
    }
	static function addbukti($params = array(),$data=null){
		self::delbukti($params['id_laporan']);
		$res=DB::table('t_bukti')->insert($data);
		return $res;
	}
	static function addpetitum($params = array(),$data=null){
		self::delpetitum($params['id_laporan']);
		$res=DB::table('t_petitum')->insert($data);
		return $res;
	}
	static function delbukti($id,$urut=null) {
		$res=DB::table('t_bukti')->where('id_laporan','=',$id);
		if(isset($urut)){
			$res=$res->where('urut','=',$urut);
		}
		$res=$res->delete();
		return $res;
    }
	static function delpetitum($id) {
		$res=DB::table('t_petitum')->where('id_laporan','=',$id);
		if(isset($urut)){
			$res=$res->where('urut','=',$urut);
		}
		$res=$res->delete();
		return $res;
    }
	static function add($data = array()) {
		$affect_row=0;
		if(isset($data['id'])){
			if($data['id']==''){
				$data['id']=null;
			}
		}
		if(isset($data['id'])){
			$id=$data['id'];
			$res=M_laporan::where('id','=',$data['id'])->first();
			if (isset($data['stslap'])) {
			   $res->stslap=getinpa($data['stslap']);
			}
			if (isset($data['stslap_by'])) {
			   $res->stslap_by=getinpa($data['stslap_by']);
			}
			if (isset($data['stslap_date'])) {
			   $res->stslap_date=getinpa($data['stslap_date']);
			}
			if (isset($data['no'])) {
			   $res->no=getinpa($data['no']);
			}
			if (isset($data['no_offline'])) {
			   $res->no_offline=getinpa($data['no_offline']);
			}
			if (isset($data['no_registrasi'])) {
			   $res->no_registrasi=getinpa($data['no_registrasi']);
			}
			if (isset($data['no_registrasi2'])) {
			   $res->no_registrasi2=getinpa($data['no_registrasi2']);
			}
			if (isset($data['id_pelapor'])) {
			   $res->id_pelapor=getinpa($data['id_pelapor']);
			}
			if (isset($data['id_tahapan'])) {
			   $res->id_tahapan=getinpa($data['id_tahapan']);
			}
			if (isset($data['id_jenislaporan'])) {
			   $res->id_jenislaporan=getinpa($data['id_jenislaporan']);
			}
			if (isset($data['id_periode'])) {
			   $res->id_periode=getinpa($data['id_periode']);
			}
			if (isset($data['id_jenispemilihan'])) {
			   $res->id_jenispemilihan=getinpa($data['id_jenispemilihan']);
			}
			if (isset($data['wilprovinsi'])) {
			   $res->wilprovinsi=getinpa($data['wilprovinsi']);
			}
			if (isset($data['wilkabkota'])) {
			   $res->wilkabkota=getinpa($data['wilkabkota']);
			}
			if (isset($data['wilkecamatan'])) {
			   $res->wilkecamatan=getinpa($data['wilkecamatan']);
			}
			if (isset($data['ringkasan'])) {
			   $res->ringkasan=getinpa($data['ringkasan']);
			}
			if (isset($data['jenistempatkejadian'])) {
			   $res->jenistempatkejadian=getinpa($data['jenistempatkejadian']);
			}
			if (isset($data['locus'])) {
			   $res->locus=getinpa($data['locus']);
			}
			if (isset($data['kecamatan'])) {
			   $res->kecamatan=getinpa($data['kecamatan']);
			}
			if (isset($data['keterangan'])) {
	            $res->keterangan=getinpa($data['keterangan']);
	        }
			if (isset($data['kejadianprovinsi'])) {
			   $res->kejadianprovinsi=getinpa($data['kejadianprovinsi']);
			}
			if (isset($data['kejadiankabkota'])) {
			   $res->kejadiankabkota=getinpa($data['kejadiankabkota']);
			}
			if (isset($data['kejadiankecamatan'])) {
			   $res->kejadiankecamatan=getinpa($data['kejadiankecamatan']);
			}
			if (isset($data['kejadianalamat'])) {
			   $res->kejadianalamat=getinpa($data['kejadianalamat']);
			}
			if (isset($data['kejadiannegara'])) {
			   $res->kejadiannegara=getinpa($data['kejadiannegara']);
			}
			if (isset($data['waktukejadian'])) {
			   $res->waktukejadian=InggrisTglDB(getinpa($data['waktukejadian']));
			}
			if (isset($data['waktukejadian_time'])) {
			   $res->waktukejadian_time=$data['waktukejadian_time'];
			}
			if (isset($data['waktudiketahui'])) {
			   $res->waktudiketahui=InggrisTglDB(getinpa($data['waktudiketahui']));
			}
			if (isset($data['waktudiketahui_time'])) {
			   $res->waktudiketahui_time=$data['waktudiketahui_time'];
			}
			if (isset($data['tgl_offline'])) {
			   $res->tgl_offline=InggrisTglTime(getinpa($data['tgl_offline']));
			}
			if (isset($data['uraian'])) {
			   $res->uraian=getinpa($data['uraian']);
			}
			if (isset($data['penerimalap'])) {
			   $res->penerimalap=getinpa($data['penerimalap']);
			}
			if (isset($data['ststsm'])) {
			   $res->ststsm=getinpa($data['ststsm']);
			}
			if (isset($data['create_by'])) {
			   $res->create_by=getinpa($data['create_by']);
			}
			if (isset($data['create_date'])) {
			   $res->create_date=getinpa($data['create_date']);
			}
			if (isset($data['tgl_registrasi'])) {
			   $res->tgl_registrasi=getinpa($data['tgl_registrasi']);
			}
			if (isset($data['edit_by'])) {
			   $res->edit_by=getinpa($data['edit_by']);
			}
			if (isset($data['edit_date'])) {
			   $res->edit_date=getinpa($data['edit_date']);
			}
			if (isset($data['edit_by_null'])) {
			   $res->edit_by=null;
			}
			if (isset($data['edit_date_null'])) {
			   $res->edit_date=null;
			}
			if (isset($data['stsvalid'])) {
			   $res->stsvalid=getinpa($data['stsvalid']);
			}
			if (isset($data['stsvalid_by'])) {
			   $res->stsvalid_by=getinpa($data['stsvalid_by']);
			}
			if (isset($data['stsvalid_date'])) {
			   $res->stsvalid_date=getinpa($data['stsvalid_date']);
			}
			if (isset($data['stsvalidbukti'])) {
			   $res->stsvalidbukti=getinpa($data['stsvalidbukti']);
			}
			if (isset($data['stsvalidbukti_by'])) {
			   $res->stsvalidbukti_by=getinpa($data['stsvalidbukti_by']);
			}
			if (isset($data['stsvalidbukti_date'])) {
			   $res->stsvalidbukti_date=getinpa($data['stsvalidbukti_date']);
			}
			if (isset($data['stsvalidperbaikan'])) {
			   $res->stsvalidperbaikan=getinpa($data['stsvalidperbaikan']);
			}
			if (isset($data['stsvalidperbaikan_by'])) {
			   $res->stsvalidperbaikan_by=getinpa($data['stsvalidperbaikan_by']);
			}
			if (isset($data['stsvalidperbaikan_date'])) {
			   $res->stsvalidperbaikan_date=getinpa($data['stsvalidperbaikan_date']);
			}
			if (isset($data['stsdibuat'])) {
			   $res->stsdibuat=getinpa($data['stsdibuat']);
			}
			if (isset($data['stsposisi'])) {
			   $res->stsposisi=getinpa($data['stsposisi']);
			}
			if (isset($data['stsvalid_null'])) {
			   $res->stsvalid_null=null;
			}
			if (isset($data['stsvalid_by_null'])) {
			   $res->stsvalid_by_null=null;
			}
			if (isset($data['stsvalid_date_null'])) {
			   $res->stsvalid_date_null=null;
			}
			$res->jmlupdate=0;
			$res->save();
			$affect_row=1;
		}
		else{
			$res=new M_laporan;
			if (isset($data['stslap'])) {
			   $res->stslap=getinpa($data['stslap']);
			}
			if (isset($data['stslap_by'])) {
			   $res->stslap_by=getinpa($data['stslap_by']);
			}
			if (isset($data['stslap_date'])) {
			   $res->stslap_date=getinpa($data['stslap_date']);
			}
			if (isset($data['no'])) {
			   $res->no=getinpa($data['no']);
			}
			if (isset($data['no_offline'])) {
			   $res->no_offline=getinpa($data['no_offline']);
			}
			if (isset($data['no_registrasi'])) {
			   $res->no_registrasi=getinpa($data['no_registrasi']);
			}
			if (isset($data['no_registrasi2'])) {
			   $res->no_registrasi2=getinpa($data['no_registrasi2']);
			}
			if (isset($data['id_pelapor'])) {
			   $res->id_pelapor=getinpa($data['id_pelapor']);
			}
			if (isset($data['id_tahapan'])) {
			   $res->id_tahapan=getinpa($data['id_tahapan']);
			}
			if (isset($data['id_jenislaporan'])) {
			   $res->id_jenislaporan=getinpa($data['id_jenislaporan']);
			}
			if (isset($data['id_periode'])) {
			   $res->id_periode=getinpa($data['id_periode']);
			}
			if (isset($data['id_jenispemilihan'])) {
			   $res->id_jenispemilihan=getinpa($data['id_jenispemilihan']);
			}
			if (isset($data['wilprovinsi'])) {
			   $res->wilprovinsi=getinpa($data['wilprovinsi']);
			}
			if (isset($data['wilkabkota'])) {
			   $res->wilkabkota=getinpa($data['wilkabkota']);
			}
			if (isset($data['wilkecamatan'])) {
			   $res->wilkecamatan=getinpa($data['wilkecamatan']);
			}
			if (isset($data['ringkasan'])) {
			   $res->ringkasan=getinpa($data['ringkasan']);
			}
			if (isset($data['jenistempatkejadian'])) {
			   $res->jenistempatkejadian=getinpa($data['jenistempatkejadian']);
			}
			if (isset($data['locus'])) {
			   $res->locus=getinpa($data['locus']);
			}
			if (isset($data['kecamatan'])) {
			   $res->kecamatan=getinpa($data['kecamatan']);
			}
			if (isset($data['keterangan'])) {
	            $res->keterangan=getinpa($data['keterangan']);
	        }
			if (isset($data['kejadianprovinsi'])) {
			   $res->kejadianprovinsi=getinpa($data['kejadianprovinsi']);
			}
			if (isset($data['kejadiankabkota'])) {
			   $res->kejadiankabkota=getinpa($data['kejadiankabkota']);
			}
			if (isset($data['kejadiankecamatan'])) {
			   $res->kejadiankecamatan=getinpa($data['kejadiankecamatan']);
			}
			if (isset($data['kejadianalamat'])) {
			   $res->kejadianalamat=getinpa($data['kejadianalamat']);
			}
			if (isset($data['kejadiannegara'])) {
			   $res->kejadiannegara=getinpa($data['kejadiannegara']);
			}
			if (isset($data['waktukejadian'])) {
			   $res->waktukejadian=InggrisTglDB(getinpa($data['waktukejadian']));
			}
			if (isset($data['waktukejadian_time'])) {
			   $res->waktukejadian_time=$data['waktukejadian_time'];
			}
			if (isset($data['waktudiketahui'])) {
			   $res->waktudiketahui=InggrisTglDB(getinpa($data['waktudiketahui']));
			}
			if (isset($data['waktudiketahui_time'])) {
			   $res->waktudiketahui_time=$data['waktudiketahui_time'];
			}
			if (isset($data['tgl_offline'])) {
			   $res->tgl_offline=InggrisTglTime(getinpa($data['tgl_offline']));
			}
			if (isset($data['uraian'])) {
			   $res->uraian=getinpa($data['uraian']);
			}
			if (isset($data['penerimalap'])) {
			   $res->penerimalap=getinpa($data['penerimalap']);
			}
			if (isset($data['ststsm'])) {
			   $res->ststsm=getinpa($data['ststsm']);
			}
			if (isset($data['create_by'])) {
			   $res->create_by=getinpa($data['create_by']);
			}
			if (isset($data['create_date'])) {
			   $res->create_date=getinpa($data['create_date']);
			}
			if (isset($data['tgl_registrasi'])) {
			   $res->tgl_registrasi=getinpa($data['tgl_registrasi']);
			}
			if (isset($data['edit_by'])) {
			   $res->edit_by=getinpa($data['edit_by']);
			}
			if (isset($data['edit_date'])) {
			   $res->edit_date=getinpa($data['edit_date']);
			}
			if (isset($data['edit_by_null'])) {
			   $res->edit_by=null;
			}
			if (isset($data['edit_date_null'])) {
			   $res->edit_date=null;
			}
			if (isset($data['stsvalid'])) {
			   $res->stsvalid=getinpa($data['stsvalid']);
			}
			if (isset($data['stsvalid_by'])) {
			   $res->stsvalid_by=getinpa($data['stsvalid_by']);
			}
			if (isset($data['stsvalid_date'])) {
			   $res->stsvalid_date=getinpa($data['stsvalid_date']);
			}
			if (isset($data['stsvalidbukti'])) {
			   $res->stsvalidbukti=getinpa($data['stsvalidbukti']);
			}
			if (isset($data['stsvalidbukti_by'])) {
			   $res->stsvalidbukti_by=getinpa($data['stsvalidbukti_by']);
			}
			if (isset($data['stsvalidbukti_date'])) {
			   $res->stsvalidbukti_date=getinpa($data['stsvalidbukti_date']);
			}
			if (isset($data['stsvalidperbaikan'])) {
			   $res->stsvalidperbaikan=getinpa($data['stsvalidperbaikan']);
			}
			if (isset($data['stsvalidperbaikan_by'])) {
			   $res->stsvalidperbaikan_by=getinpa($data['stsvalidperbaikan_by']);
			}
			if (isset($data['stsvalidperbaikan_date'])) {
			   $res->stsvalidperbaikan_date=getinpa($data['stsvalidperbaikan_date']);
			}
			if (isset($data['stsdibuat'])) {
			   $res->stsdibuat=getinpa($data['stsdibuat']);
			}
			if (isset($data['stsposisi'])) {
			   $res->stsposisi=getinpa($data['stsposisi']);
			}
			if (isset($data['stsvalid_null'])) {
			   $res->stsvalid_null=null;
			}
			if (isset($data['stsvalid_by_null'])) {
			   $res->stsvalid_by_null=null;
			}
			if (isset($data['stsvalid_date_null'])) {
			   $res->stsvalid_date_null=null;
			}
			$res->jmlupdate=1;
			$res->save();
			$id=$res->id;
			if($id>0){
				$affect_row=1;
			}
		}
		return ($affect_row == 0) ? false : $id;
	}
	static function setunreg($data = array()){
		$tglexp=date('Y-m-d H:i:s', strtotime($data['create_date']. ' + 2 days'));
		$s="SET GLOBAL event_scheduler = 1;";
		DB::select($s);
		$s="CREATE EVENT evt_laporan_".$data['id']." 
		ON SCHEDULE AT '".$tglexp."' 
		Do update t_laporan set stslap=2 where id=".$data['id'].";";
		DB::select($s);
	}
	static function del($id) {
		$status = M_laporan::where('id',$id)->delete();
		self::delpetitum($id);
		self::delbukti($id);
		self::delterlapor($id);
		self::delsaksi($id);
		self::delpelaporlain($id);
        return $status;
    }
	static function resetlaporan($id) {
		if(isset($id)){
			$res=M_laporan::where('id','=',$id)->first();
			$res->stsvalid=null;
			$res->stsvalid_by=null;
			$res->stsvalid_date=null;
			$res->stsposisi='Input Pelaporan';
			$res->save();
		}
    }
	static function setposisi($data = array()) {
		if(isset($data['id'])){
			if($data['id']!=''){
				$res=M_laporan::where('id','=',$data['id'])->first();
				$res->stsposisi=getinpa($data['stsposisi']);
				$res->save();
			}
		}
    }
	static function settglregistrasi($data = array()) {
		if(isset($data['id'])){
			if($data['id']!=''){
				$res=M_laporan::where('id','=',$data['id'])->first();
				$res->tgl_registrasi=getinpa($data['tgl_registrasi']);
				$res->save();
		        
			}
		}
    }
	static function daftar_pelaporlain($params = array()) {
		$sql="select a.*,
			concat(coalesce(a.alamat,''),
			(case when coalesce(c.nama,'')!='' then concat(', ',coalesce(c.nama,'')) end),
			(case when coalesce(b.nama,'')!='' then concat(', ',coalesce(b.nama,'')) end)) alamat
			from t_pelaporlain a
			left join m_provinsi b on b.kode=a.provinsi
			left join m_kabkota c on c.kode=a.kabkota
			where 1<2 ";
		if (isset($params['id_laporan'])){
			$sql.=' and id_laporan='.$params['id_laporan'];
		}
		if (isset($params['urut'])){
			$sql.=' and urut='.$params['urut'];
		}
		$sql.=' order by urut';
		$res=DB::select($sql);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_terlapor($params = array()) {
		$sql="select a.*,
			concat(coalesce(a.alamat,''),
			(case when coalesce(c.nama,'')!='' then concat(', ',coalesce(c.nama,'')) end),
			(case when coalesce(b.nama,'')!='' then concat(', ',coalesce(b.nama,'')) end)) alamat
			from t_terlapor a
			left join m_provinsi b on b.kode=a.provinsi
			left join m_kabkota c on c.kode=a.kabkota
			where 1<2 ";
		if (isset($params['id_laporan'])){
			$sql.=' and id_laporan='.$params['id_laporan'];
		}
		if (isset($params['urut'])){
			$sql.=' and urut='.$params['urut'];
		}
		$sql.=' order by urut';
		$res=DB::select($sql);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_saksi($params = array()) {
		$sql="select a.*,
			concat(coalesce(a.alamat,''),
			(case when coalesce(c.nama,'')!='' then concat(', ',coalesce(c.nama,'')) end),
			(case when coalesce(b.nama,'')!='' then concat(', ',coalesce(b.nama,'')) end)) alamat
			from t_saksi a
			left join m_provinsi b on b.kode=a.provinsi
			left join m_kabkota c on c.kode=a.kabkota";
		if (isset($params['id_laporan'])){
			$sql.=' where id_laporan='.$params['id_laporan'];
		}
		$sql.=' order by urut';
		$res=DB::select($sql);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_bukti($params = array()) {
		$sql="select a.* from t_bukti a";
		if (isset($params['id_laporan'])){
			$sql.=' where id_laporan='.$params['id_laporan'];
		}
		$sql.=' order by urut';
		$res=DB::select($sql);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftartanpanoreg($params = array()) {
		$res=DB::table("vw_laporan as a");
		if (isset($params['id'])) {
			$res=$res->where('id', $params['id']);
        }
		if (isset($params['id_periode'])){
            $res=$res->where('a.id_periode', $params['id_periode']);
		}
		if (isset($params['locus'])){
            $res=$res->where('a.locus', $params['locus']);
		}
		if (isset($params['id_jenislaporan'])){
            $res=$res->where('a.id_jenislaporan', $params['id_jenislaporan']);
		}
		$res=$res->whereRaw('coalesce(a.stslap,0)=0');
		if (isset($params['table'])){
			if($params['table']=='t_kajianawal'){
				$params['table']="t_kajianawal where coalesce(stshide,0)=0";
			}
			$res=$res->whereRaw('a.id not in (select id_laporan from '.$params['table'].' )');
		}
		$res=$res->where('a.stsvalid', 1);
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftardengannoreg($params = array()) {
		$sql = "SELECT a.* FROM vw_laporan a WHERE "; 
		if (isset($params['id'])) {
            $sql.= " a.id = '". $params['id']."' ";
        }
		if (isset($params['id_periode'])){
            $sql.= "  a.id_periode = '". $params['id_periode']."' ";
		}
		if (isset($params['id_pelapor'])) {
            $sql.= " AND a.id_pelapor = '". $params['id_pelapor']."' ";
        }
		if (isset($params['locus'])){
            $sql.= " AND a.locus = '". $params['locus']."' ";
		}
		if (isset($params['id_jenislaporan'])){
            $sql.= " AND a.id_jenislaporan = '". $params['id_jenislaporan']."' ";
		}
		if (isset($params['table'])){
			$sql.= " AND (a.id not in (select id_laporan from ".$params['table']." )) ";
		}
		$sql.= " AND (a.no_registrasi is not null OR a.no_registrasi2 is not null) ";
		if (isset($params['table'])) {
			if($params['table']=='t_sidang'){
				$sql.= " AND (a.id in (select aa.id_laporan from t_kajianawal aa, t_kajianawal_pelanggaran bb where aa.id=bb.id_kajianawal and bb.id_pelanggaran=3)) ";
			}
		}
		if (isset($params['start'])){
			$sql.=" limit ".$params['start'].", ".$params['per_page'];
		}
		$res=DB::select($sql);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftartidakdengannoreg($params = array()) {
		$res=DB::table("vw_laporan as a");
		if (isset($params['id'])) {
            $res=$res->where('id', $params['id']);
        }
		if (isset($params['id_periode'])){
            $res=$res->where('a.id_periode', $params['id_periode']);
		}
		if (isset($params['id_pelapor'])) {
            $res=$res->where('a.id_pelapor', $params['id_pelapor']);
        }
		if (isset($params['locus'])){
            $res=$res->where('a.locus', $params['locus']);
		}
		if (isset($params['id_jenislaporan'])){
            $res=$res->where('a.id_jenislaporan', $params['id_jenislaporan']);
		}
		if (isset($params['table'])){
			$res=$res->whereRaw('a.id not in (select id_laporan from '.$params['table'].' )');
		}
		$res=$res->whereRaw('a.id in (select id_laporan from t_kajianawal)');
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
}
