<?php
namespace App\Models;

use App\Models\M_laporan;
use App\Models\M_kajianawal_dokumen;
use App\Models\M_kajianawal_dokumen_perbaikan;
use App\Models\M_kajianawal_pelanggaran;
use App\Models\M_kajianawal_pelanggaran_trend;
use Illuminate\Database\Eloquent\Model;
use DB;

class M_kajianawal extends Model
{
	public $timestamps = false;
	const UPDATED_AT  = null;
    protected $primaryKey= 'id';
    protected $table = 't_kajianawal';
    protected $fillable = [
	'id_laporan',
	'note',
	'dokumen',
	'id_kat1',
	'id_kat2',
	'id_kat3',
	'id_trendpelanggaran',
	'dok_reg',
	'dok_unreg',
	'dok_lengkapidokumen',
	'dok_dicabut',
	'dok_unreg_sdh_ditangani',
	'sel_pelimpahan',
	'locus_pelimpahan',
	'stsfinal',
	'stshide',
	'kecamatan',
	'noregmanual',
	'katawal',
	'admbano',
	'admbafile',
	'create_by',
	'create_date',
	'edit_by',
	'edit_date'
	];
	
	static function daftar($params = array()){
		$str="select a.*, b.stsposisi, b.locus, b.no, b.id_jenislaporan, b.tgl_registrasi, b.no_registrasi, b.no_registrasi2, c.nama pelapornm, d.nama kat1nm, e.nama kat2nm, f.nama kat3nm, g.nama trendpelanggarannm, b.id_pelapor,
		(case when coalesce(a.locus_pelimpahan,'')<>'' then
		  (case when a.locus_pelimpahan='0' then 'Bawaslu RI' else
		    concat('',(select nama from m_provinsi where substr(a.locus_pelimpahan,1,2)=substr(kode,1,2)),
		    coalesce((case when substr(a.locus_pelimpahan,4,2)<>'00' then concat('<br>',
		    concat(coalesce((select nama from m_kabkota where kode=a.locus_pelimpahan),''),
			(case when coalesce(a.kecamatan,'')<>'' then concat('<br>Kecamatan ',a.kecamatan) else '' end),
			(case when coalesce(a.noregmanual,'')<>'' then concat('<br>No Register Pelaporan ',a.noregmanual) else '' end)
			))end),''))
		  end)
		end) locus_pelimpahannm,
		(
		case 
			when b.locus='0' then 'Bawaslu RI'
			when substr(b.locus,4,2)='00' then concat('Prop. ',d1.nama)
			when substr(b.locus,4,2)<>'00' then concat('Prop. ',d1.nama,'<br>Kab/Kot. ',d2.nama)
		end
		) wilayahlocus 
		from t_kajianawal a
		inner join t_laporan b on b.id=a.id_laporan
		inner join t_user c on c.id_user=b.id_pelapor
		left join m_kajianawal_kategori d on d.id=a.id_kat1
		left join m_kajianawal_kategori e on e.id=a.id_kat2
		left join m_kajianawal_kategori f on f.id=a.id_kat3
		left join m_trendpelanggaran g on g.id=a.id_trendpelanggaran
		left join m_provinsi d1 on substr(d1.kode,1,2)=substr(b.locus,1,2) 
		left join m_kabkota d2 on d2.kode=b.locus
		where 1<2 
		";
		if(isset($params['id'])){
			$str.=" and a.id=".$params['id'];
		}
		if (isset($params['id_pelapor'])) {
			$str.=" and b.id_pelapor=".$params['id_pelapor'];
        }
		if (isset($params['id_periode'])){
			$str.=" and b.id_periode=".$params['id_periode'];
		}
		if (isset($params['locus'])){
			$str.=" and b.locus=".$params['locus'];
		}
		if (isset($params['id_jenislaporan'])){
			$str.=" and b.id_jenislaporan=".$params['id_jenislaporan'];
		}
		if (isset($params['frontend'])){
			$str.=" and coalesce(a.stsfinal,0)=1";
		}
		if (isset($params['cari'])){
			$str.=" and (lower(b.no) like '%".$params['cari']."%' or lower(a.note) like '%".$params['cari']."%' or lower(d.nama) like '%".$params['cari']."%' or lower(e.nama) like '%".$params['cari']."%') ";
		}
		$str.=" order by id desc";
		if (isset($params['start'])){
			$str.=" limit ".$params['per_page'].','.$params['start'];
		}
		$res=DB::select($str);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_index($params = array()){
		$str="select a.*, b.stsposisi, b.locus, b.no, b.id_jenislaporan, b.no_registrasi2, b.no_registrasi, c.nama pelapornm, d.nama kat1nm, e.nama kat2nm, f.nama kat3nm,g.nama trendpelanggarannm, b.id_pelapor,
		(case when coalesce(a.locus_pelimpahan,'')<>'' then
		  (case when a.locus_pelimpahan='0' then 'Bawaslu RI' else
		    concat('',(select nama from m_provinsi where substr(a.locus_pelimpahan,1,2)=substr(kode,1,2)),
		    coalesce((case when substr(a.locus_pelimpahan,4,2)<>'00' then concat('<br>',
		    concat(coalesce((select nama from m_kabkota where kode=a.locus_pelimpahan),''),
			(case when coalesce(a.kecamatan,'')<>'' then concat('<br>Kecamatan ',a.kecamatan) else '' end),
			(case when coalesce(a.noregmanual,'')<>'' then concat('<br>No Register Pelaporan ',a.noregmanual) else '' end)
			))end),''))
		  end)
		end) locus_pelimpahannm,
		(
		case 
			when b.locus='0' then 'Bawaslu RI'
			when substr(b.locus,4,2)='00' then concat('Prop. ',d1.nama)
			when substr(b.locus,4,2)<>'00' then concat('Prop. ',d1.nama,'<br>Kab/Kot. ',d2.nama)
		end
		) wilayahlocus
		from t_kajianawal a
		inner join t_laporan b on b.id=a.id_laporan
		inner join t_user c on c.id_user=b.id_pelapor
		left join m_kajianawal_kategori d on d.id=a.id_kat1
		left join m_kajianawal_kategori e on e.id=a.id_kat2 
		left join m_kajianawal_kategori f on f.id=a.id_kat3
		left join m_trendpelanggaran g on g.id=a.id_trendpelanggaran
		left join m_provinsi d1 on substr(d1.kode,1,2)=substr(b.locus,1,2)
		left join m_kabkota d2 on d2.kode=b.locus
		where 1<2 
		";
		if (isset($params['id'])) {
			$str.=" and a.id=".$params['id'];
        }
		if (isset($params['id_periode'])){
			$str.=" and b.id_periode=".$params['id_periode'];
		}
		if (isset($params['locus'])){
			$locus=$params['locus'];
			if($locus=='0'){
				//do nothing
			}
			elseif(substr($locus,3,2)=='00'){
				$str.=" and substr(b.locus,1,2)='".substr($locus,0,2)."'";
			}
			else{
				$str.=" and b.locus='".$locus."'";
			}
		}
		if (isset($params['id_jenislaporan'])){
			$str.=" and b.id_jenislaporan=".$params['id_jenislaporan'];
		}
		$str.=" and coalesce(a.stshide,0)=0";
		$res=DB::select($str);
		if(count($res)>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function getlaporan($params = array()) {
		$res=DB::table("t_kajianawal as a")->join('t_laporan as b','a.id_laporan','=','b.id')
			 ->selectRaw("b.stsposisi, b.no, b.no_registrasi, b.locus, b.id_jenislaporan, a.stsfinal, b.id_pelapor");
		if (isset($params['id'])) {
			$res=$res->where('a.id',$params['id']);
		}
		if (isset($params['id_jenislaporan'])){
			$res=$res->where('b.id_jenislaporan',$params['id_jenislaporan']);
		}
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_dokumen($params = array()) {
		$res=DB::table("t_kajianawal_dokumen as a")->leftJoin('m_user as b','b.id_user','=','a.create_by')
			->selectRaw("a.*, b.nama");
		if (isset($params['id'])) {
			$res=$res->where('a.id',$params['id']);
		}
		if (isset($params['id_kajianawal'])){
			$res=$res->where('a.id_kajianawal',$params['id_kajianawal']);
		}
		$res=$res->get();
		if($res->count()>0){
			if(isset($params['id'])){
				$res=$res[0];
			}
		}
		return $res;
	}
	static function daftar_dokumen_perbaikan($params = array()) {
		$res=DB::table("t_kajianawal_dokumen_perbaikan as a")->leftJoin('m_user as b','b.id_user','=','a.create_by')
			->selectRaw("a.*, b.nama");
		if (isset($params['id'])) {
			$res=$res->where('a.id',$params['id']);
		}
		if (isset($params['id_kajianawal'])){
			$res=$res->where('a.id_kajianawal',$params['id_kajianawal']);
		}
	}
	static function add($data = array()) {
		$affect_row=0;
		if(isset($data['id'])){
			if($data['id']==''){
				$data['id']=null;
			}
		}
		if(isset($data['id'])){
			$id=$data['id'];
			$res=M_kajianawal::where('id','=',$data['id'])->first();
			if (isset($data['id_laporan'])) {
            	$res->id_laporan=getinpa($data['id_laporan']);
	        }
			if (isset($data['note'])) {
	            $res->note=getinpa($data['note']);
	        }
			if (isset($data['dokumen'])) {
	            $res->dokumen=getinpa($data['dokumen']);
	        }
			if (isset($data['admbano'])) {
	            $res->admbano=getinpa($data['admbano']);
	        }
			if (isset($data['admbafile'])) {
	            $res->admbafile=getinpa($data['admbafile']);
	        }
			if (isset($data['id_kat1'])) {
	            $res->id_kat1=getinpa($data['id_kat1']);
	        }
			if (isset($data['id_kat1_null'])) {
	            $res->id_kat1=null;
	        }
			if (isset($data['id_kat2'])) {
	            $res->id_kat2=getinpa($data['id_kat2']);
	        }
			if (isset($data['id_kat2_null'])) {
	            $res->id_kat2=null;
	        }
			if (isset($data['id_kat3'])) {
	            $res->id_kat3=getinpa($data['id_kat3']);
	        }
			if (isset($data['id_kat3_null'])) {
	            $res->id_kat3=null;
	        }
			if (isset($data['id_trendpelanggaran'])) {
	            $res->id_trendpelanggaran=getinpa($data['id_trendpelanggaran']);
	        }
			if (isset($data['dok_reg'])) {
	            $res->dok_reg=getinpa($data['dok_reg']);
	        }
			if (isset($data['dok_unreg'])) {
	            $res->dok_unreg=getinpa($data['dok_unreg']);
	        }
			if (isset($data['dok_lengkapidokumen'])) {
	            $res->dok_lengkapidokumen=getinpa($data['dok_lengkapidokumen']);
	        }
			if (isset($data['dok_dicabut'])) {
	            $res->dok_dicabut=getinpa($data['dok_dicabut']);
	        }
			if (isset($data['sel_pelimpahan'])) {
	            $res->sel_pelimpahan=getinpa($data['sel_pelimpahan']);
	        }
			if (isset($data['sel_pelimpahan_null'])) {
	            $res->sel_pelimpahan=null;
	        }
			if (isset($data['locus_pelimpahan'])) {
	            $res->locus_pelimpahan=getinpa($data['locus_pelimpahan']);
	        }
			if (isset($data['locus_pelimpahan_null'])) {
	            $res->locus_pelimpahan=null;
	        }
			if (isset($data['stsfinal'])) {
	            $res->stsfinal=getinpa($data['stsfinal']);
	        }
			if (isset($data['stsfinal_nol'])) {
	            $res->stsfinal=0;
	        }
			if (isset($data['stshide'])) {
	            $res->stshide=getinpa($data['stshide']);
	        }
			if (isset($data['kecamatan'])) {
	            $res->kecamatan=getinpa($data['kecamatan']);
	        }
			if (isset($data['kecamatan_null'])) {
	            $res->kecamatan=null;
	        }
			if (isset($data['noregmanual'])) {
	            $res->noregmanual=getinpa($data['noregmanual']);
	        }
			if (isset($data['noregmanual_null'])) {
	            $res->noregmanual=null;
	        }
			if (isset($data['katawal'])) {
	            $res->katawal=getinpa($data['katawal']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=getinpa($data['create_by']);
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=getinpa($data['create_date']);
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=getinpa($data['edit_by']);
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=getinpa($data['edit_date']);
	        }
			if (isset($data['edit_by_null'])) {
	            $res->edit_by=null;
	        }
			if (isset($data['edit_date_null'])) {
	            $res->edit_date=null;
	        }
			$res->save();
			$affect_row=1;
		}
		else{
			$res=new M_kajianawal;
			if (isset($data['id_laporan'])) {
            	$res->id_laporan=getinpa($data['id_laporan']);
	        }
			if (isset($data['note'])) {
	            $res->note=getinpa($data['note']);
	        }
			if (isset($data['dokumen'])) {
	            $res->dokumen=getinpa($data['dokumen']);
	        }
			if (isset($data['admbano'])) {
	            $res->admbano=getinpa($data['admbano']);
	        }
			if (isset($data['admbafile'])) {
	            $res->admbafile=getinpa($data['admbafile']);
	        }
			if (isset($data['id_kat1'])) {
	            $res->id_kat1=getinpa($data['id_kat1']);
	        }
			if (isset($data['id_kat1_null'])) {
	            $res->id_kat1=null;
	        }
			if (isset($data['id_kat2'])) {
	            $res->id_kat2=getinpa($data['id_kat2']);
	        }
			if (isset($data['id_kat2_null'])) {
	            $res->id_kat2=null;
	        }
			if (isset($data['id_kat3'])) {
	            $res->id_kat3=getinpa($data['id_kat3']);
	        }
			if (isset($data['id_kat3_null'])) {
	            $res->id_kat3=null;
	        }
			if (isset($data['id_trendpelanggaran'])) {
	            $res->id_trendpelanggaran=getinpa($data['id_trendpelanggaran']);
	        }
			if (isset($data['dok_reg'])) {
	            $res->dok_reg=getinpa($data['dok_reg']);
	        }
			if (isset($data['dok_unreg'])) {
	            $res->dok_unreg=getinpa($data['dok_unreg']);
	        }
			if (isset($data['dok_lengkapidokumen'])) {
	            $res->dok_lengkapidokumen=getinpa($data['dok_lengkapidokumen']);
	        }
			if (isset($data['dok_dicabut'])) {
	            $res->dok_dicabut=getinpa($data['dok_dicabut']);
	        }
			if (isset($data['sel_pelimpahan'])) {
	            $res->sel_pelimpahan=getinpa($data['sel_pelimpahan']);
	        }
			if (isset($data['sel_pelimpahan_null'])) {
	            $res->sel_pelimpahan=null;
	        }
			if (isset($data['locus_pelimpahan'])) {
	            $res->locus_pelimpahan=getinpa($data['locus_pelimpahan']);
	        }
			if (isset($data['locus_pelimpahan_null'])) {
	            $res->locus_pelimpahan=null;
	        }
			if (isset($data['stsfinal'])) {
	            $res->stsfinal=getinpa($data['stsfinal']);
	        }
			if (isset($data['stsfinal_nol'])) {
	            $res->stsfinal=0;
	        }
			if (isset($data['stshide'])) {
	            $res->stshide=getinpa($data['stshide']);
	        }
			if (isset($data['kecamatan'])) {
	            $res->kecamatan=getinpa($data['kecamatan']);
	        }
			if (isset($data['kecamatan_null'])) {
	            $res->kecamatan=null;
	        }
			if (isset($data['noregmanual'])) {
	            $res->noregmanual=getinpa($data['noregmanual']);
	        }
			if (isset($data['noregmanual_null'])) {
	            $res->noregmanual=null;
	        }
			if (isset($data['katawal'])) {
	            $res->katawal=getinpa($data['katawal']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=getinpa($data['create_by']);
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=getinpa($data['create_date']);
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=getinpa($data['edit_by']);
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=getinpa($data['edit_date']);
	        }
			if (isset($data['edit_by_null'])) {
	            $res->edit_by=null;
	        }
			if (isset($data['edit_date_null'])) {
	            $res->edit_date=null;
	        }
			$res->save();
			$id=$res->id;
			if($id>0){
				$affect_row=1;
			}
		}
		return ($affect_row == 0) ? false : $id;
	}
	static function add_dokumen($data = array()) {
		$affect_row=0;
		if(isset($data['id'])){
			if($data['id']==''){
				$data['id']=null;
			}
		}
		if(isset($data['id'])){
			$id=$data['id'];
			$res=M_kajianawal_dokumen::where('id','=',$data['id'])->first();
			if (isset($data['id_kajianawal'])) {
           		$res->id_kajianawal=getinpa($data['id_kajianawal']);
	        }
			if (isset($data['note'])) {
	            $res->note=getinpa($data['note']);
	        }
			if (isset($data['dokumen'])) {
	            $res->dokumen=getinpa($data['dokumen']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$affect_row=1;
		}
		else{
			$res=new M_kajianawal_dokumen;
			if (isset($data['id_kajianawal'])) {
           		$res->id_kajianawal=getinpa($data['id_kajianawal']);
	        }
			if (isset($data['note'])) {
	            $res->note=getinpa($data['note']);
	        }
			if (isset($data['dokumen'])) {
	            $res->dokumen=getinpa($data['dokumen']);
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$id=$res->id;
			if($id>0){
				$affect_row=1;
			}
		}
		return ($affect_row == 0) ? false : $id;
	}
	static function add_dokumen_perbaikan($data = array()) {
		$affect_row=0;
		if(isset($data['id'])){
			if($data['id']==''){
				$data['id']=null;
			}
		}
		if(isset($data['id'])){
			$id=$data['id'];
			$res=M_kajianawal_dokumen_perbaikan::where('id','=',$data['id'])->first();
			if (isset($data['id_kajianawal'])) {
	            $res->id_kajianawal=getinpa($data['id_kajianawal']);
	        }
			if (isset($data['note'])) {
	            $res->note=getinpa($data['note']);
	        }
			if (isset($data['dokumen'])) {
	            $res->dokumen=getinpa($data['dokumen']);
	        }
			if (isset($data['tgl'])) {
	            $res->tgl=InggrisTglDB(getinpa($data['tgl']));
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$affect_row=1;
		}
		else{
			$res=new M_kajianawal_dokumen_perbaikan;
			if (isset($data['id_kajianawal'])) {
	            $res->id_kajianawal=getinpa($data['id_kajianawal']);
	        }
			if (isset($data['note'])) {
	            $res->note=getinpa($data['note']);
	        }
			if (isset($data['dokumen'])) {
	            $res->dokumen=getinpa($data['dokumen']);
	        }
			if (isset($data['tgl'])) {
	            $res->tgl=InggrisTglDB(getinpa($data['tgl']));
	        }
			if (isset($data['create_by'])) {
	            $res->create_by=$data['create_by'];
	        }
			if (isset($data['create_date'])) {
	            $res->create_date=$data['create_date'];
	        }
			if (isset($data['edit_by'])) {
	            $res->edit_by=$data['edit_by'];
	        }
			if (isset($data['edit_date'])) {
	            $res->edit_date=$data['edit_date'];
	        }
			$res->save();
			$id=$res->id;
			if($id>0){
				$affect_row=1;
			}
		}
		return ($affect_row == 0) ? false : $id;
	}
	static function upd($data = array()) {
		$res=DB::table('t_kajianawal')->where('id',$data['id'])->first();
		$res->note=getinpa($data['note']);
		$res->dokumen=getinpa($data['dokumen']);
		$res->edit_date=getinpa($data['edit_date']);
		$res->save();
		return $data['id'];
	}
	static function del($id) {
		DB::table('t_kajianawal_pelanggaran_trend')->where('id_kajianawal', $id)->delete();
		DB::table('t_kajianawal_pelanggaran')->where('id_kajianawal', $id)->delete();
		DB::table('t_kajianawal_dokumen_perbaikan')->where('id_kajianawal', $id)->delete();
		DB::table('t_kajianawal_dokumen')->where('id_kajianawal', $id)->delete();
		DB::table('t_kajianawal')->where('id', $id)->delete();
	}
	static function del_dokumen($id) {
		DB::table('t_kajianawal_dokumen')->where('id', $id)->delete();
	}
	static function del_dokumen_perbaikan($id) {
		DB::table('t_kajianawal_dokumen_perbaikan')->where('id', $id)->delete();
	}
	static function duplicateRecord ($table, $primary_key_field, $primary_key_val){
		/*
		$query = DB::table($table)->where($primary_key_field, $primary_key_val)->get();
		$res=new DB::table($table);
		foreach ($query as $row){
	       foreach($row as $key=>$val){
	          if($key != $primary_key_field){
				$res->$key=$val;
	          }
	       }
	    }
		$res->save();
		$id=$res->id;
		*/
		if($table=='t_laporan'){
			$exs = M_laporan::find($primary_key_val);
		}
		elseif($table=='t_kajianawal'){
			$exs = M_kajianawal::find($primary_key_val);
		}
		$dup = $exs->replicate();
		$dup->save();
		$id=$dup->id;
		return $id;
	}
	static function duplicateSubLaporan($params = array()){
		$sql="insert into t_bukti(urut,id_laporan,deskripsi,file) select urut,'".$params['id_tujuan']."',deskripsi,file from t_bukti where id_laporan='".$params['id_sumber']."'";
		DB::select($sql);
		
		$sql="insert into t_petitum(urut,id_laporan,deskripsi) select urut,'".$params['id_tujuan']."',deskripsi from t_petitum where id_laporan='".$params['id_sumber']."'";
		DB::select($sql);
		
		$sql="insert into t_saksi(urut,id_laporan,nama,alamat,provinsi,kabkota,hp) select urut,'".$params['id_tujuan']."',nama,alamat,provinsi,kabkota,hp from t_saksi where id_laporan='".$params['id_sumber']."'";
		DB::select($sql);
		
		$sql="insert into t_terlapor(urut,id_laporan,nama,alamat,provinsi,kabkota,pekerjaan,hp) select urut,'".$params['id_tujuan']."',nama,alamat,provinsi,kabkota,pekerjaan,hp from t_terlapor where id_laporan='".$params['id_sumber']."'";
		DB::select($sql);
	}
	static function duplicateSubKajianAwal($params = array()){
		$sql="insert into t_kajianawal_dokumen(id_kajianawal,note,dokumen,create_by,create_date) select '".$params['id_tujuan']."',note,dokumen,'".$params['create_by']."','".$params['create_date']."' from t_kajianawal_dokumen where id_kajianawal='".$params['id_sumber']."'";
        DB::select($sql);
		$sql="insert into t_kajianawal_dokumen_perbaikan(id_kajianawal,note,dokumen,create_by,create_date) select '".$params['id_tujuan']."',note,dokumen,'".$params['create_by']."','".$params['create_date']."' from t_kajianawal_dokumen_perbaikan where id_kajianawal='".$params['id_sumber']."'";
        DB::select($sql);
		$sql="insert into t_kajianawal_pelanggaran(id_kajianawal,id_pelanggaran,id_trend,create_by,create_date) select '".$params['id_tujuan']."',id_pelanggaran,id_trend,'".$params['create_by']."','".$params['create_date']."' from t_kajianawal_pelanggaran where id_kajianawal='".$params['id_sumber']."'";
        DB::select($sql);
		$sql="insert into t_kajianawal_pelanggaran_trend(id_kajianawal,id_pelanggaran,urut,id_trend,create_by,create_date) select '".$params['id_tujuan']."',id_pelanggaran,urut,id_trend,'".$params['create_by']."','".$params['create_date']."' from t_kajianawal_pelanggaran_trend where id_kajianawal='".$params['id_sumber']."'";
        DB::select($sql);
	}
}
