<?php
namespace App\Http\Controllers;

use DB;
use DateTime;
use App\Models\M_notifikasia;
use App\Models\M_modulinfo;
use App\Models\M_undangan;
use Illuminate\Http\Request;

class N_UndanganController extends Controller
{
	public function __construct()
    {
		if(session('uname')==''){
			session(['hallanjut' =>'undangan.index']);
			return redirect("auth")->send();
		}
    }
	function index(){
		$title = 'Daftar Undangan';
     	$main = 'home.undangan_list';
		$arrLink=array(
				array("Menu",route('home').'/'.(session('ujenislaporanid')==1?'pemilihan':'pemilu').'/'.session('ulocuskode')),
				);
		$params['id_periode']=DB::table('m_periode')->select('id')->where('aktif',1)->first()->id;
		$params['id_jenislaporan'] = session('ujenislaporanid');
		$params['id_pelapor']=session('uid');
		$list = M_undangan::daftar_depan($params);
		$lebar=12;
		$paramsmodulinfo['id_jenislaporan'] =session('ujenislaporanid');
		$paramsmodulinfo['modul'] ='e-panggilan';
		$modulinfo = M_modulinfo::daftar($paramsmodulinfo)[0]['deskripsi'];
		return view($main,compact('arrLink','title','list','lebar','modulinfo'));
	}
	function setbaca(){
		$params['id'] = $_GET('u');
		$params['stsbaca']=1;
		$params['tanggal_baca'] =  date("Y-m-d H:i:s");
		$this->M_undangan_model->add($params);
		
		$no='';$locus='';
		$datalaporan=$this->db->select('b.no, b.locus')->where('a.id',$params['id'])->from('t_undangan a')->join('t_laporan b','a.id_laporan=b.id','inner')->get()->row();
		if($datalaporan){
			$no=$datalaporan->no;
			$locus=$datalaporan->locus;
		}
		
		$petugas_hp='';$petugas_id='';$petugas_stswa=0;
		$datapetugas=$this->db->select('id_user,hp,stswa')->where('wilayah',$locus)->from('m_user')->get()->result();
		if($datapetugas){
			foreach($datapetugas as $item){
				$petugas_hp=$item->hp;
				$petugas_id=$item->id_user;
				$petugas_stswa=$item->stswa;
			
				if($petugas_hp!=""&&$petugas_stswa==1){
					$hp=$petugas_hp;
					$hp=(substr($hp,0,1)=='0'?'62'.substr($hp,1,strlen($hp)):$hp);
					$WhatsappService=new WhatsappService;
					$WhatsappService->sendMessageToWhatsapp($hp, 'Undangan dari laporan '.$no.' sudah dibuka oleh pelapor');
				}
				if($petugas_id!=""){
					$paramsnotif['pesan']='Undangan dari laporan '.$no.' sudah dibuka oleh pelapor';
					$paramsnotif['tanggal_buat'] =  date("Y-m-d H:i:s");
					$paramsnotif['id_user']=$petugas_id;
					$this->M_notifikasia_model->add($paramsnotif);
				}
			}
		}
		$dokumen=$this->db->select('dokumen')->where('id',$params['id'])->from('t_undangan')->get()->row()->dokumen;
		if(!$dokumen){
			echo -1;
		}
	}
}