<?php

namespace App\Http\Controllers;

use DB;
use App\Models\M_wilayah;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_WilayahController extends Controller
{
	public function __construct()
    {
    }
	function index(){
		$title = 'Data Wilayah';
     	$main = 'be.m_wilayah_list';
     	$list = M_wilayah::daftar();
		$arrLink=array(
				array("Wilayah",route('m_wilayah.index'))
				);
		return view($main,compact('arrLink','title','list'));
	}
	function list_result(Request $request):JsonResponse
	{
		if($request->ajax()){
			$collection =DB::table('w_bps')->selectRaw("id,iddesa,nmdesa,nmkec,nmkab,nmprov");
			return DataTables::of($collection)
			->addColumn('id', function ($arrData){
				return $arrData->id;
			})
			->addColumn('iddesa', function ($arrData){
				return $arrData->iddesa;
			})
			->addColumn('id', function ($arrData){
				return $arrData->nmdesa;
			})
			->addColumn('id', function ($arrData){
				return $arrData->nmkec;
			})
			->addColumn('id', function ($arrData){
				return $arrData->nmkab;
			})
			->addColumn('id', function ($arrData){
				return $arrData->nmprov;
			})
			->make(true);
		}
    }
}
