<?php

namespace App\Http\Controllers;

use DB;
use DateTime;
use App\Models\General;
use App\Models\M_notifikasi;
use App\Models\M_laporan;
use App\Models\M_undangan;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_UndanganController extends Controller
{
	public function __construct()
    {
    }
	public function index($id_jenislaporan=null)
    {
        if(!cekjenislapor3(dc($id_jenislaporan))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $id_jenislaporan=dc($id_jenislaporan);
		$arrLink=array(
			array("Undangan",route('m_undangan.index').'/'.$ec_id_jenislaporan)
		);
		$title='Daftar Undangan';
		$tambah = 'href="'.route('m_undangan.add').'/'.$ec_id_jenislaporan.'"';
		return view('be.m_undangan_list',compact('arrLink','title','tambah','ec_id_jenislaporan'));
    }
	function list_result($id_jenislaporan=null,Request $request):JsonResponse
	{
		//if($request->ajax()){
			$id_jenislaporan=dc($id_jenislaporan);
			$params['locus'] = session('be_uwilayah');
			$params['id_jenislaporan'] = $id_jenislaporan;
			$params['id_periode']=DB::table('m_periode')->select('id')->where('aktif','=',1)->first()->id;
			$collection = M_undangan::daftar_index($params);
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->addColumn('notes', function ($arrData){
				$s=substr($arrData->note,0,50).'...';
				if($arrData->dokumen!=""){
					$s.='<br><a href="'.route("download.be_ud_dk").'/'.rawurlencode($arrData->dokumen).'" class="btn btn-primary btn-xs"><i class=" ti-download"></i> Download</a>';
				}
				return $s;
			})
			->addColumn('aksi', function ($arrData){
				$s='<br>
					<div align="center dropdown">
                        <button class="btn btn-primary dropdown-toggle btn-sm" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          Aksi
                        </button>
                      <ul class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                          <li><a class="dropdown-item btn-sm" href="'.route('m_undangan.view').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa fa-file-archive-o"></i> Tampil</a></li>';
						  if (session('be_urole')!=4){
						  	if ($arrData->locus==session('be_uwilayah')||session('be_urole')==3){
							  $s.='<li><a class="dropdown-item btn-sm" href="'.route('m_undangan.add').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa ti-write"></i> Ubah</a>
							       <li><a class="dropdown-item btn-sm item_delete" data-id="'.ec($arrData->id).'" data-nm="'.$arrData->no.'"><i class="fa fa-trash-o"></i> Hapus</a></li>';
                          	}
						  }
                      $s.='</ul>
                    </div>
				';
				return $s;
			})
			->make(true);
		//}
    }
	
	function add($id_jenislaporan=null,$id = NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekintnull(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id=dc($id);
		$data=null;
		if(isset($id)){
			$paramsdt['id'] = $id;
			$data = M_undangan::daftar($paramsdt);
			if($data){
				$locus=$data->locus;
				$stsposisi=$data->stsposisi;
				$id_jenislaporan=$data->id_jenislaporan;
				if(General::cekaksesedit($locus)){
					//do nothing
				}
				else{
					return redirect()->route('denied');
				}
			}
		}
		$title = 'Tambah Undangan';
     	$main= 'm_undangan_add';
     	$arrLink=array(
				array("Undangan",route('m_undangan.index').'/'.$ec_id_jenislaporan)
				);
		$tambah = 'href="'.route('m_undangan.add').'/'.$ec_id_jenislaporan.'"';
     	$params['id_jenislaporan'] = $id_jenislaporan;
		if($id_jenislaporan==3){
     		$params['stsposisi'] = 'Putusan Pendahuluan';
		}
		else{
     		$params['stsposisi'] = 'Pelaporan diregister';
		}
		$params['locus'] =session('be_uwilayah');
		$params['id_periode']=DB::table('m_periode')->selectRaw('id,nama')->where('aktif',1)->first()->id;
		$listlaporan = M_laporan::daftardengannoreg($params);
		return view('be.m_undangan_add',compact('arrLink','title','id_jenislaporan','tambah','data','listlaporan'));
	}
	function view($id_jenislaporan=null,$id = NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id=dc($id);
		$data=null;
		
		if(isset($id)){
			$paramsdt['id'] = $id;
			$data = M_undangan::daftar($paramsdt);
			if($data){
				$id_jenislaporan=$data->id_jenislaporan;
				if(!General::cekaksesview($data->locus)){
					return redirect()->route('denied');
				}
			}
		}
		$title = 'Undangan';
     	$main= 'm_undangan_view';
     	$arrLink=array(
				array("Undangan",route('m_undangan.index').'/'.$ec_id_jenislaporan)
				);
		$tambah = 'href="'.route('m_undangan.add').'/'.$ec_id_jenislaporan.'"';
		return view('be.m_undangan_view',compact('arrLink','title','id_jenislaporan','tambah','data'));
	}
	function save(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$id_jenislaporan = getinp($request->id_jenislaporan);
		$params['id_laporan'] = getinp($request->id_laporan);
		
		if(!cekjenislapor3($id_jenislaporan)||!cekint($params['id_laporan'])||!cekintnull($id)){
			return redirect()->route('denied');
		}
		
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		if($dt['operation']=='Ubah'){
			$datalapa=DB::table("t_undangan as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					  ->selectRaw('b.no,b.locus,b.stsposisi')
					  ->where('a.id',$id)->first();
			if(!empty($datalapa)){
				$no=$datalapa->no;
				$ceklocus=$datalapa->locus;
				$cekstsposisi=$datalapa->stsposisi;
				if(!General::cekaksesedit($ceklocus)){
					return redirect()->route('denied');
				}
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			$datalapa=DB::table("t_laporan")
					  ->selectRaw('no,locus,stsposisi')
					  ->where('id',$params['id_laporan'])->first();
			if(!empty($datalapa)){
				$no=$datalapa->no;
				$ceklocus=$datalapa->locus;
				$cekstsposisi=$datalapa->stsposisi;
				if(!General::cekaksesedit($ceklocus)){
					return redirect()->route('denied');
				}
			}
			else{
				redirect('denied');
			}
		}
		$paramslaporan['id']=$params['id_laporan'];
		$paramslaporan['stsposisi']='Undangan';
		M_laporan::setposisi($paramslaporan);
		$params['note'] = getinp($request->note);
		if($dt['operation']=='Tambah'){
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
		}
		elseif($dt['operation']=='Ubah'){
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
		}
		$data=M_undangan::add($params);
		if($data){
			$id=$data;
			$no='';$id_pelapor='';
			$datalap=DB::table("t_laporan as a")->join('t_user as b','a.id_pelapor','=','b.id_user')
					 ->selectRaw('a.no,a.id_pelapor,b.hp,b.nama,b.email,a.stsposisi,a.locus')->where('a.id',$params['id_laporan'])->first();
			if(!empty($datalap)){
				$no=$datalap->no;
				$id_pelapor=$datalap->id_pelapor;
				$hp=$datalap->hp;
				$nama=$datalap->nama;
				$email=$datalap->email;
				
				if($id_pelapor!=""){
					$paramsnotif['pesan']='Undangan sudah diberikan kepada '.$nama.' terkait pelaporan no '.$no.'. silakan membuka undangan pada modul E-Panggilan.';
					$paramsnotif['tanggal_buat'] =  date("Y-m-d H:i:s");
					$paramsnotif['id_user']=$id_pelapor;
					M_notifikasi::add($paramsnotif);
				}
				if($hp!=""){
					$hp=(substr($hp,0,1)=='0'?'62'.substr($hp,1,strlen($hp)):$hp);
					//$WhatsappService=new WhatsappService;
					//$WhatsappService->sendMessageToWhatsapp($hp, 'Undangan sudah diberikan kepada '.$nama.' terkait pelaporan no '.$no.'. silakan membuka undangan pada modul E-Panggilan.');
				}
				if($email!=''){
					$paramsemail['toemail']=$email;
					$paramsemail['subyek']='Undangan pelaporan no '.$no;
					$paramsemail['pesan']='Diberitahukan kepada Pelapor bahwa undangan sudah diberikan terkait pelaporan no '.$no.'.<br>Silakan membuka undangan pada modul E-Panggilan..<br><br>Terimakasih';
					kirim_email($paramsemail);
				}
			}
		}
		$no=DB::table("t_laporan")->select('no')->where('id',$params['id_laporan'])->first()->no;
		if (!empty($request->file('dokumen'))){
			$file=$request->file('dokumen');
			$file_name=$file->getClientOriginalName();
			$file_ext=$file->extension();
			$date=new DateTime();
			$namafile=aksi_upload($file,'undangan',$no.'-'.$date->format('Y-m-d-H-i-s'),$file_ext);
			$paramsupd['dokumen'] = $namafile;
			$paramsupd['id']=$id;
			M_undangan::add($paramsupd);
		}
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Undangan',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: Undangan dengan pelaporan no '.$no.' sudah di '.strtolower($dt['operation']),
               'ip' => $request->ip()
           )
        );
		echo route('m_undangan.index').'/'.ec($id_jenislaporan);
	}
	function del($id_jenislaporan=null,$id = NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id=dc($id);
		
		$datalap=DB::table("t_undangan as a")->join('t_laporan as b','a.id_laporan','=','b.id')
				 ->selectRaw('b.id,b.id_jenislaporan,b.no,b.locus,b.stsposisi')->where('a.id',$id)->first();
		if(!empty($datalap)){
			$idlap=$datalap->id;
			$id_jenislaporan=$datalap->id_jenislaporan;
			$no=$datalap->no;
			$ceklocus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			if(General::cekaksesedit($ceklocus)){
				//do nothing
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Undangan',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Undangan dengan pelaporan no '.$no.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
		$data=M_undangan::del($id);
		
		$params['id']=$idlap;
		$params['edit_by'] =  session('be_uid');
		$params['edit_date'] =  date("Y-m-d H:i:s");
		if($id_jenislaporan==3){
			$params['stsposisi']='Putusan Pendahuluan';
		}
		else{
			$params['stsposisi']='Kajian Awal';
		}
		M_laporan::add($params);
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Undangan',
               'aksi' => 'Ubah',
               'note' => 'ID:'.$idlap.', Title: Pelaporan no '.$no.' diubah status posisinya menjadi '.$params['stsposisi'],
               'ip' => $request->ip()
           )
        );
		return redirect()->route('m_undangan.index',['id_jenislaporan'=>ec($id_jenislaporan)]);
	}
}
