<?php

namespace App\Http\Controllers;

use DB;
use App\Models\M_trendpelanggaran;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_TrendPelanggaranController extends Controller
{
	public function __construct()
    {
    }
	public function index()
    {
		$arrLink=array(
			array("Trend Pelanggaran",route('m_tahapan.index'))
		);
		$title='Daftar Trend Pelanggaran';
		$tambah = 'href="'.route('m_trendpelanggaran.add').'"';
		return view('be.m_trendpelanggaran_list',compact('arrLink','title','tambah'));
    }
	function add($id = NULL)
    {
		if(!cekintnull(dc($id))){
			return redirect()->route('denied.index');
		}
		$id=dc($id);
		$operation = is_null($id) ? 'Tambah' : 'Ubah';
		$title = $operation.' Trend Pelanggaran';
		$arrLink=array(
				array("Trend Pelanggaran",route('m_user.index'))
				);
		$params['id'] =$id;
		$m_jenislaporan=DB::table('m_jenislaporan')->get();
		$kategori=DB::table('m_kajianawala_kategori')->get();
		$data=null;
		if(isset($id)){
			$data=m_trendpelanggaran::daftar($params);
		}
		return view('be.m_trendpelanggaran_add',compact('arrLink','operation','title','data','m_jenislaporan','kategori'));
	}
	function view($id = NULL){
		if(!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$id=dc($id);
		$operation = 'View';
		$title = $operation.' Trend Pelanggaran';
		$arrLink=array(
				array("Trend Pelanggaran",route('m_trendpelanggaran.index'))
				);
		$params['id'] =$id;
		$data=null;
		if(isset($id)){
			$data=m_trendpelanggaran::daftar($params);
		}
		return view('be.m_trendpelanggaran_view',compact('arrLink','operation','title','data'));
	}
	public function save(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$params['nama'] = getinp($request->nama);
		$params['id_kat'] = getinp($request->id_kategori);
		$params['id_jenislaporan'] = getinp($request->id_jenislaporan);
		
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		if($dt['operation']=='Tambah'){
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
		}
		elseif($dt['operation']=='Ubah'){
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
		}
		
		if($params['nama']!=""&&!is_null($params['nama'])){
			$data=M_trendpelanggaran::add($params);
	        M_log::add(
	           array(
	               'stsfrom' => 2,
	               'modul' => 'User',
	               'aksi' => $dt['operation'],
	               'note' => 'ID:'.$id.', Title: User '.$params['nama'].' sudah di '.strtolower($dt['operation']),
	               'ip' => $request->ip()
	           )
	        );
			$request->session()->flash('success', $dt['operation'] . ' Data Berhasil');
		}
		return redirect()->route('m_trendpelanggaran.index')->with('success', $dt['operation'] . ' Data Berhasil');
	}
	function del($id = NULL,Request $request)
	{
		if(!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$id=dc($id);
		$str="select 1 from t_kajianawal_pelanggaran_trend where id_trend=".$id." limit 1";
		$data=DB::select($str);
		if($data){
			return redirect()->route('m_trendpelanggaran.index')->with('failed', 'Hapus Data Tidak Berhasil');
		}
		else{
			$str="select nama from m_trendpelanggaran where id=".$id." limit 1";
			$nama=DB::select($str)[0]->nama;
			M_log::add(
	           array(
	               'stsfrom' => 2,
	               'modul' => 'User',
	               'aksi' => 'Hapus',
	               'note' => 'ID:'.$id.', Title: tahapan '.$nama.' sudah dihapus',
	               'ip' => $request->ip()
	           )
	        );
			m_trendpelanggaran::del($id);
			return redirect()->route('m_trendpelanggaran.index')->with('success', 'Hapus Data Berhasil');
		}
	}
	function list_result(Request $request):JsonResponse
	{
		//if($request->ajax()){
			$collection = M_trendpelanggaran::daftar();
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->make(true);
		//}
    }
}
