<?php

namespace App\Http\Controllers;

use DB;
use DateTime;
use App\Models\General;
use App\Models\M_laporan;
use App\Models\M_tindaklanjut;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_TindakLanjutController extends Controller
{
	public function __construct()
    {
    }
	public function index($id_jenislaporan=null)
    {
        if(!cekjenislapor3(dc($id_jenislaporan))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $id_jenislaporan=dc($id_jenislaporan);
		$arrLink=array(
			array("Tindak Lanjut",route('m_tindaklanjut.index').'/'.$ec_id_jenislaporan)
		);
		$title='Daftar Tindak Lanjut';
		$tambah = 'href="'.route('m_tindaklanjut.add').'/'.$ec_id_jenislaporan.'"';
		return view('be.m_tindaklanjut_list',compact('arrLink','title','tambah','ec_id_jenislaporan'));
    }
	function list_result($id_jenislaporan=null,Request $request):JsonResponse
	{
		//if($request->ajax()){
			$id_jenislaporan=dc($id_jenislaporan);
			$params['locus'] = session('be_uwilayah');
			$params['id_jenislaporan'] = $id_jenislaporan;
			$params['id_periode']=DB::table('m_periode')->select('id')->where('aktif','=',1)->get()[0]->id;
			$collection = M_tindaklanjut::daftar_index($params);
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->addColumn('rekomendasis', function ($arrData){
				$s=$arrData->rekomendasi_no.'<br>';
				if($arrData->rekomendasi_file!=''){
					$s.='<a href="'.route("download.be_ka_dk").'/'.rawurlencode($arrData->rekomendasi_file).'" class="btn btn-primary btn-xs"><i class=" ti-download"></i> Download</a>';
				}
				return $s;
			})
			->addColumn('aksi', function ($arrData){
				$s='<br>
					<div align="center dropdown">
                        <button class="btn btn-primary dropdown-toggle btn-sm" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          Aksi
                        </button>
                      <ul class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                          <li><a class="dropdown-item btn-sm" href="'.route('m_tindaklanjut.view').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa fa-file-archive-o"></i> Tampil</a></li>
						  ';
						  if (session('be_urole')!=4){
						  	if ($arrData->locus==session('be_uwilayah')||session('be_urole')==3){
							  $s.='<li><a class="dropdown-item btn-sm" href="'.route('m_tindaklanjut.add').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa ti-write"></i> Ubah</a>
							       <li><a class="dropdown-item btn-sm item_delete" data-id="'.ec($arrData->id).'" data-nm="'.$arrData->no.'"><i class="fa fa-trash-o"></i> Hapus</a></li>';
                          	}
						  }
                      $s.='</ul>
                    </div>
				';
				return $s;
			})
			->make(true);
		//}
    }
	function view($id_jenislaporan=null,$id = NULL){
        if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
        $data=null;$m_tahapaned=null;
		
        if(isset($id)){
            $paramsdt['id'] = $id;
            $data = M_tindaklanjut::daftar($paramsdt);
            if($data){
                $id_jenislaporan=$data->id_jenislaporan;
                if(!General::cekaksesview($data->locus)){
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
            $paramstahapan['id_laporan'] = $data->id_laporan;
            $paramstahapan['id_jenislaporan'] = $id_jenislaporan;
            $m_tahapaned=M_tindaklanjut::gettahapan($paramstahapan);
        }
        else{
            return redirect()->route('denied');
        }
        $title = 'Tampilan Tindak Lanjut';
        $main = 'be.m_tindaklanjut_view';
        $arrLink=array(
                array("Tindak Lanjut",route('m_tindaklanjut.index').'/'.$ec_id_jenislaporan)
                );
        $tambah = 'href="'.route('m_tindaklanjut.add').'/'.$ec_id_jenislaporan.'"';
        $params['id_jenislaporan'] = $id_jenislaporan;
        
        $m_tahapan=DB::table('m_kajianakhir_kategori')->where('level',1)->get();
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','data','m_tahapaned','m_tahapan'));
    }
    function add($id_jenislaporan=null,$id = NULL){
        if(!cekjenislapor3(dc($id_jenislaporan))||!cekintnull(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
        $data=null;$m_tahapaned=null;
		
        if(isset($id)){
            $paramsdt['id'] = $id;
            $data = M_tindaklanjut::daftar($paramsdt);
            if($data){
                $locus=$data->locus;
                $stsposisi=$data->stsposisi;
                $id_jenislaporan=$data->id_jenislaporan;
                
                if(General::cekaksesedit($locus)){
                    //do nothing
                }
                else{
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
            $paramstahapan['id_laporan'] = $data->id_laporan;
            $paramstahapan['id_jenislaporan'] = $id_jenislaporan;
            $m_tahapaned=M_tindaklanjut::gettahapan($paramstahapan);
        }
        $title = 'Tambah Tindak Lanjut';
        $main = 'be.m_tindaklanjut_add';
        $arrLink=array(
                array("Tindak Lanjut",route('m_tindaklanjut.index').'/'.$ec_id_jenislaporan)
                );
        $tambah = 'href="'.route('m_tindaklanjut.add').'/'.$ec_id_jenislaporan.'"';
        $params['id_jenislaporan'] = $id_jenislaporan;
        $params['table'] = 't_tindaklanjut';
        $params['stsposisi'] = 'Status Laporan';
        $params['locus'] =session('be_uwilayah');
        $params['id_periode']=DB::table('m_periode')->selectRaw('id,nama')->where('aktif',1)->first()->id;
        
		$listlaporan = M_laporan::daftardengannoreg($params);
        $m_tahapan=DB::table('m_kajianakhir_kategori')->where('level',1)->get();
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','data','listlaporan','m_tahapaned','m_tahapan'));
    }
    function add_tahapan($id_jenislaporan=null,$id_laporan=null){
        if(!cekjenislapor3($id_jenislaporan)||!cekint($id_laporan)){
            return redirect()->route('denied');
        }
		
        $s='';$sj='';
        $params['id_laporan'] =$id_laporan;
        $params['id_jenislaporan'] =$id_jenislaporan;
        $m_tahapan=M_tindaklanjut::gettahapan($params);
        if(!empty($m_tahapan)){
            $idx_tahapan=0;
            $s.='
            <link rel="stylesheet" href="'.asset('media/assets/css/select2.min.css').'">
            <link rel="stylesheet" href="'.asset('media/assets/css/select2-bootstrap.css').'">
            <script src="'.asset('media/assets/js/jquery-1.12.4.min.js').'"></script>
            <script src="'.asset('media/assets/js/select2.full.js').'"></script>
            <table  class="table borderless" width=100%>';
            foreach ($m_tahapan as $item) {
                $s.='
                <tr>
                    <td width=3%>'.++$idx_tahapan.'</td>
                    <td width=97%>'.$item->id_katnm.'</td>
                </tr>
                <tr>
                    <td></td>
                    <td>
                        <table width=70% class="">
                            <tbody id=tbody'.$item->id_kat.'>
                            </tbody>
                        </table>
                        <button class="btn btn-xs btn-primary"
                          id="addBtn'.$item->id_kat.'" type="button" onclick="addrow'.$item->id_kat.'()">
                            Tambah Status
                        </button>
                    </td>
                </tr>
                ';
            }
            $s.='</table>
            <script>$(".select2").select2();</script>
            ';
        }
        echo $s.$sj;
    }
    function save(Request $request){
        
        $id = getinp($request->id);
        $params['id'] = $id;
        $id_jenislaporan = getinp($request->id_jenislaporan);
        $params['id_jenislaporan'] =$id_jenislaporan;
        $params['id_laporan'] = getinp($request->id_laporan);
        $params['id_status'] = getinp($request->id_status);
        if(!cekjenislapor3($id_jenislaporan)||!cekint($params['id_laporan'])||!cekintnull($id)){
            return redirect()->route('denied');
        }
        $dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
        $datalap=null;
		
        if($dt['operation']=='Ubah'){
			$datalap=DB::table("t_tindaklanjut as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					 ->selectRaw('b.no,b.locus,b.stsposisi')
					 ->where('a.id',$id)->first();
            if(!empty($datalap)){
                $no=$datalap->no;
                $stsposisi=$datalap->stsposisi;
                $ceklocus=$datalap->locus;
                
                if(General::cekaksesedit($ceklocus)){
                    //do nothing
                }
                else{
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
        }
        else{
			$datalap=DB::table("t_laporan")
					 ->selectRaw('no,locus,stsposisi')
					 ->where('id',$params['id_laporan'])->first();
            if(!empty($datalap)){
                $no=$datalap->no;
                $ceklocus=$datalap->locus;
                $cekstsposisi=$datalap->stsposisi;
                
                if(!General::cekaksesedit($ceklocus)){
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
        }
        $paramslaporan['id']=$params['id_laporan'];
        $paramslaporan['stsposisi']='Tindak Lanjut';
        M_laporan::setposisi($paramslaporan);
        
        if($dt['operation']=='Tambah'){
            $params['create_by'] =  session('be_uid');
            $params['create_date'] =  date("Y-m-d H:i:s");
        }
        elseif($dt['operation']=='Ubah'){
            $params['edit_by'] =  session('be_uid');
            $params['edit_date'] =  date("Y-m-d H:i:s");
        }
        $data=M_tindaklanjut::add($params);
        if($data){
            $id=$data;
        }
		$no=DB::table("t_laporan")->select('no')->where('id',$params['id_laporan'])->first()->no;
        $date=new DateTime();
        $m_tahapan=M_tindaklanjut::gettahapan($params);
        if($m_tahapan){
            M_tindaklanjut::del_kategori($id);
            foreach($m_tahapan as $item){
                $paramskat['id_status']=$request->input("id_status".$item->id_kat);
                $paramskat['id_tindaklanjut']=$id;
                $paramskat['id_kategori']=$item->id_kat;
                $data=M_tindaklanjut::add_kategori($paramskat);
                if($data){
                    $id_kat=$data;
                }
                $id_tahapan=$request->input("id_tahapan".$item->id_kat);
                $note=$request->input("note".$item->id_kat);
                $tahapan_idx=$request->input("tahapan_idx".$item->id_kat);
                
                $index = 0;
                $urut=1;
                $data = array();
                if(isset($id_tahapan)){
                    foreach($id_tahapan as $item1){
                        if($item1!=''){
                            $tahapannm=DB::table("m_tindaklanjut_status")->select('nama')->where('id',$item1)->first()->nama;
                            $tahapannm=str_replace(" ","_",$tahapannm);
							
							$file=null;$file_name=null;
							if(!empty($request->file('dokumen'.$item->id_kat.$tahapan_idx[$index]))){
								$file=$request->file('dokumen'.$item->id_kat.$tahapan_idx[$index]);
								$file_name=$file->getClientOriginalName().'.'.$file->extension();
							}
							
                            array_push($data, array(
                            'urut'=>$urut,
                            'id_tindaklanjut'=>$id,
                            'id_tindaklanjut_kategori'=>$id_kat,
                            'id_status'=>$item1,
                            'note'=>$note[$index],
                            'dokumen'=>(!empty($file_name)?aksi_upload($file,'tindaklanjut',$no.'-'.$date->format('Y-m-d-H-i-s').'-'.$item->id_katnm.'-'.$tahapannm.'-'.$urut):$request->input('dokumenfile'.$item->id_kat.$tahapan_idx[$index])),
                            ));
                            $urut++;
                        }
                        $index++;
                    }
                    $params2['id_tindaklanjut_kategori'] = $id_kat;
                    if(!empty($data)){
                        $data2=M_tindaklanjut::add_tahapan($params2,$data);
                    }
                }
            }
        }
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Tindak Lanjut',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: Tindak Lanjut dengan pelaporan no '.$no.' sudah di '.strtolower($dt['operation']),
               'ip' => $request->ip()
           )
        );
        return redirect()->route('m_tindaklanjut.index',[ec($id_jenislaporan)]);
    }
    function del($id_jenislaporan=null,$id = NULL,Request $request){
        if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
        
        $datalap=DB::table("t_tindaklanjut as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					 ->where('a.id',$id)
					 ->selectRaw('b.id,b.id_jenislaporan,b.no,b.locus,b.stsposisi')->first();
		if(!empty($datalap)){
            $idlap=$datalap->id;
            $id_jenislaporan=$datalap->id_jenislaporan;
            $no=$datalap->no;
            $ceklocus=$datalap->locus;
            $stsposisi=$datalap->stsposisi;
            
            if(General::cekaksesedit($ceklocus)){
                //do nothing
            }
            else{
                return redirect()->route('denied');
            }
        }
        else{
            return redirect()->route('denied');
        }
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Tindak Lanjut',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Tindak Lanjut dengan pelaporan no '.$no.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
        $data=M_tindaklanjut::del($id);
        
        $params['id']=$idlap;
        $params['edit_by'] =  session('be_uid');
        $params['edit_date'] =  date("Y-m-d H:i:s");
        $params['stsposisi']='Status Laporan';
        M_laporan::add($params);
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Tindak Lanjut',
               'aksi' => 'Ubah',
               'note' => 'ID:'.$idlap.', Title: Pelaporan no '.$no.' diubah status posisinya menjadi '.$params['stsposisi'],
               'ip' => $request->ip()
           )
        );
        return redirect()->route('m_tindaklanjut.index',[$ec_id_jenislaporan]);
    }
}
