<?php

namespace App\Http\Controllers;

use DB;
use App\Models\M_tahapan;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_TahapanController extends Controller
{
	public function __construct()
    {
    }
	public function index()
    {
		$arrLink=array(
			array("Tahapan",route('m_tahapan.index'))
		);
		$title='Daftar Tahapan';
		$tambah = 'href="'.route('m_tahapan.add').'"';
		return view('be.m_tahapan_list',compact('arrLink','title','tambah'));
    }
	function add($id = NULL)
    {
		if(!cekintnull(dc($id))){
			return redirect()->route('denied.index');
		}
		$id=dc($id);
		$operation = is_null($id) ? 'Tambah' : 'Ubah';
		$title = $operation.' Tahapan';
		$arrLink=array(
				array("tahapan",route('m_user.index'))
				);
		$params['id'] =$id;
		$m_jenislaporan=DB::table('m_jenislaporan')->get();
		$data=null;
		if(isset($id)){
			$data=M_tahapan::daftar($params);
		}
		return view('be.m_tahapan_add',compact('arrLink','operation','title','data','m_jenislaporan'));
	}
	function view($id = NULL){
		if(!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$id=dc($id);
		$operation = 'View';
		$title = $operation.' Tahapan';
		$arrLink=array(
				array("Tahapan",route('m_tahapan.index'))
				);
		$params['id'] =$id;
		$data=null;
		if(isset($id)){
			$data=M_tahapan::daftar($params);
		}
		return view('be.m_tahapan_view',compact('arrLink','operation','title','data'));
	}
	public function save(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$params['nama'] = getinp($request->nama);
		$params['id_jenislaporan'] = getinp($request->id_jenislaporan);
		
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		if($dt['operation']=='Tambah'){
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
		}
		elseif($dt['operation']=='Ubah'){
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
		}
		
		if($params['nama']!=""&&!is_null($params['nama'])){
			$data=M_tahapan::add($params);
	        M_log::add(
	           array(
	               'stsfrom' => 2,
	               'modul' => 'User',
	               'aksi' => $dt['operation'],
	               'note' => 'ID:'.$id.', Title: User '.$params['nama'].' sudah di '.strtolower($dt['operation']),
	               'ip' => $request->ip()
	           )
	        );
			$request->session()->flash('success', $dt['operation'] . ' Data Berhasil');
		}
		return redirect()->route('m_tahapan.index')->with('success', $dt['operation'] . ' Data Berhasil');
	}
	function del($id = NULL,Request $request)
	{
		if(!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$id=dc($id);
		$str="select 1 from t_laporan where id_tahapan=".$id." limit 1";
		$data=DB::select($str);
		if($data){
			return redirect()->route('m_tahapan.index')->with('failed', 'Hapus Data Tidak Berhasil');
		}
		else{
			$str="select nama from m_tahapan where id=".$id." limit 1";
			$nama=DB::select($str)[0]->nama;
			M_log::add(
	           array(
	               'stsfrom' => 2,
	               'modul' => 'User',
	               'aksi' => 'Hapus',
	               'note' => 'ID:'.$id.', Title: tahapan '.$nama.' sudah dihapus',
	               'ip' => $request->ip()
	           )
	        );
			M_tahapan::del($id);
			return redirect()->route('m_tahapan.index')->with('success', 'Hapus Data Berhasil');
		}
	}
	function list_result(Request $request):JsonResponse
	{
		if($request->ajax()){
			$str="select a.id as id,a.nama as nama_tahapan,b.id as id_jenislaporan, b.nama as nama_jenis 
				 from m_tahapan a
				 inner join m_jenislaporan b on a.id_jenislaporan=b.id";
			$collection = DB::select($str);
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->make(true);
		}
    }
}
