<?php

namespace App\Http\Controllers;

use DB;
use App\Models\M_rekapa;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_RekapPemilihanController extends Controller
{
	public function __construct()
    {
    }
	function daftar(Request $request) {
		set_time_limit(1200);
	    $row_count = 0;
		$queryz = DB::select("SELECT no FROM t_laporan GROUP BY no;");
		$row_count = count($queryz);
    	
        $wilayah = $request->wilayah;
        if (is_array($request->provinsi)) {
	        $strprovinsi = "";
	        foreach($request->provinsi as $str) {
	            $strprovinsi .= "'".$str."',";
	        }
        } else {
            
            $strprovinsi = "'".$request->provinsi."'";
        }
        if (is_array($request->kabkota)) {
	        $strkabkota = "";
	        foreach($request->kabkota as $str) {
	            $strkabkota .= "'".$str."',";
	        }
        } else {
            
            $strkabkota = "'".$request->kabkota."'";
        }
        if (is_array($request->kejadiannegara)) {
	        $strkejadiannegara = "";
	        foreach($request->kejadiannegara as $str) {
	            $strkejadiannegara .= "'".$str."',";
	        }
        } else {
            
            $strkejadiannegara = "'".$request->kejadiannegara."'";
        }
        $mintglinput = $request->mintglinput;
        $maxtglinput = $request->maxtglinput;
        $daerahpemilihan = $request->daerahpemilihan;
        $laporantemuan = $request->laporantemuan;
        $statuslaporan = $request->statuslaporan;
        $tahapan = $request->tahapan;
        $nolaporan = $request->nolaporan;
        $registrasilaporan = $request->registrasilaporan;
        
        $tgllaporan = $request->tgllaporan;
        $pelapor = $request->pelapor;
        $terlapor = $request->terlapor;
        $saksi = $request->saksi;
        $kajian = $request->kajian;
        if (is_array($request->jenispelanggaran)) {
	        $strjenispelanggaran = "";
	        foreach($request->jenispelanggaran as $str) {
	            $strjenispelanggaran .= " pelanggaran LIKE '%".$str."%' OR";
	        }
        } else {
            
            $strjenispelanggaran = " pelanggaran LIKE '%".$request->jenispelanggaran."%'";
        }
        $trendkajianawal = $request->trendkajianawal;
        $trendkajianakhir = $request->trendkajianakhir;

        $draw = $request->draw;
        $row = $request->start;
		$row=($row==''?0:$row);
        $rowperpage = $request->length; // Rows display per page
		$rowperpage =($rowperpage==''?30:$rowperpage);
        $columnIndex = $request->input('order.0.column'); // Column index
        $columnName = $request->input('columns.'.$columnIndex.'data'); // Column name
        $columnSortOrder = $request->input('order.0.dir'); // asc or desc
        $searchValue = $request->input('search.value'); // Search value
		
        ## Search 
        $searchQuery = " ";
        $sqland = true;
        
		$sql="SELECT `vw_laporan_pemilihan2`.* FROM `vw_laporan_pemilihan2` WHERE ";
		if (($mintglinput != '') || ($maxtglinput != '') || ($wilayah > 0) || ($daerahpemilihan != '') || ($laporantemuan != '') || ($statuslaporan != '') || ($tahapan != '') || ($nolaporan != '') || ($registrasilaporan != '') 
		 || ($tgllaporan != '') || ($pelapor != '') || ($terlapor != '') || ($saksi != '') || ($kajian != '') || (is_array($request->jenispelanggaran)) || ($trendkajianawal != '') || ($trendkajianakhir != '')) 
		{
		    //$sql .= 'WHERE ';
		}
		if (($mintglinput != '') && ($maxtglinput != '')) {
		    $str_mintglinput = explode('/', $mintglinput);
		    $str_maxtglinput = explode('/', $maxtglinput);
		    $sql .= " (create_date BETWEEN '".$str_mintglinput[2].'-'.$str_mintglinput[1].'-'.$str_mintglinput[0]."' AND '".$str_maxtglinput[2].'-'.$str_maxtglinput[1].'-'.$str_maxtglinput[0]."') ";
		} else {
		    $sqland = false;
		}
		if($wilayah=='1') {
    		if ($sqland) {
    		    $sql .= ' AND ';
    		}
			$sql.=" provinsi IS NULL ";
			$sqland = true;
		} elseif($wilayah=='2') {
    		if ($sqland) {
    		    $sql .= ' AND ';
    		}
		    if (is_array($request->provinsi)) {
		        if (count($request->provinsi) > 1) {
    	            $sql.=" provinsi IN (".rtrim($strprovinsi, ',').") ";
		        } else {
		            if (rtrim($strprovinsi, ',') != "''") {
		                $sql.=" provinsi = ".rtrim($strprovinsi, ',')." ";
		            } else {
		                $sql.=" provinsi IS NOT NULL ";
		            }
		        }
		    } else {
		        if (rtrim($strprovinsi, ',') != "''") {
		            $sql.=" provinsi = ".$strprovinsi." ";
		        } else {
		            $sql.=" provinsi IS NOT NULL ";
		        }
		    }
		    $sqland = true;
		} elseif($wilayah=='3') {
    		if ($sqland) {
    		    $sql .= ' AND ';
    		}
		    if (is_array($request->provinsi)) {
		        if (count($request->provinsi) > 1) {
    	            $sql.=" ( provinsi IN (".rtrim($strprovinsi, ',').") ";
		        } else {
		            if (rtrim($strprovinsi, ',') != "''") {
		                $sql.=" ( provinsi = ".rtrim($strprovinsi, ',')." ";
		            }
		        }
		    } else {
		        if ($request->provinsi != '') {
		            $sql.=" ( provinsi = ".$strprovinsi." ";
		        }
		    }
		    if (is_array($request->kabkota)) {
		        if (count($request->kabkota) > 1) {
    	            $sql.=" AND kabkota IN (".rtrim($strkabkota, ',').") ) ";
		        } else {
		            if (rtrim($strkabkota, ',') != "''") {
		                $sql.=" AND kabkota = ".rtrim($strkabkota, ',')." ) ";
		            }
		        }
		    } else {
		        if ($request->kabkota != '') {
		            $sql.=" AND kabkota = ".$strkabkota." ) ";
		        } else {
		            $sql.=" ) ";
		        }
		    }
		    $sqland = true;
		} elseif ($wilayah== '4') {
    		if ($sqland) {
    		    $sql .= ' AND ';
    		}
		    if (is_array($request->kejadiannegara)) {
		        if (count($request->kejadiannegara) > 1) {
    	            $sql.="  kejadiannegara IN (".rtrim($strkejadiannegara, ',').") ";
		        } else {
		            if (rtrim($strkejadiannegara, ',') != "''") {
		                $sql.=" kejadiannegara = ".rtrim($strkejadiannegara, ',')." ";
		            }
		        }
		    } else {
		        if ($request->kejadiannegara != '') {
		            $sql.=" kejadiannegara = ".$strkejadiannegara." ";
		        } else {
		            $sql.=" kejadiannegara <> 'Indonesia' ";
		        }
		    }
			
			$sqland = true;
		
		} else {
		    $sql.=" kejadiannegara = 'Indonesia' OR kejadiannegara IS NULL ";
		    $sqland = true;
		}
        
        if ($daerahpemilihan != '')	{
    		if ($sqland) {
    		    $sql .= ' AND ';
    		}
            $sql.=" daerah_pemilihan = '".addslashes($daerahpemilihan)."' ";
            $sqland = true;
        }	
        if ($laporantemuan != '')	{
    		if ($sqland) {
    		    $sql .= ' AND ';
    		}
            $sql.=" lptm = '".$laporantemuan."' ";    
            $sqland = true;
        }	
        if ($tahapan != '')	{
    		if ($sqland) {
    		    $sql .= ' AND ';
    		}
            $sql.=" tahapan = '".$tahapan."' ";    
            $sqland = true;
        }	
        if ($statuslaporan != '')	{
    		if ($sqland) {
    		    $sql .= ' AND ';
    		}
            $sql.=" statuslaporan = '".$statuslaporan."' ";  
            $sqland = true;
        }	
        if ($nolaporan != '')	{
    		if ($sqland) {
    		    $sql .= ' AND ';
    		}
            $sql.=" no = '".$nolaporan."' ";  
            $sqland = true;
        }	
        if ($registrasilaporan != '')	{
    		if ($sqland) {
    		    $sql .= ' AND ';
    		}
            $sql.=" no_registrasi = '".$registrasilaporan."' OR no_registrasi2 = '".$registrasilaporan."'  ";  
            $sqland = true;
        }	
        
        if ($tgllaporan != '')	{
    		if ($sqland) {
    		    $sql .= ' AND ';
    		}
    		$str_tgllaporan = explode('/', $tgllaporan);
            $sql.=" DATE(tgl_offline) = '".$str_tgllaporan[2].'-'.$str_tgllaporan[1].'-'.$str_tgllaporan[0]."' ";  
            $sqland = true;
        }	
        if ($pelapor != '')	{
    		if ($sqland) {
    		    $sql .= ' AND ';
    		}
            $sql.=" pelapor_nm LIKE '%".$pelapor."%' "; 
            $sqland = true;
        }	
        if ($terlapor != '')	{
    		if ($sqland) {
    		    $sql .= ' AND ';
    		}
            $sql.=" terlapor_nama LIKE '%".$terlapor."%' ";  
            $sqland = true;
        }	
        if ($saksi != '')	{
    		if ($sqland) {
    		    $sql .= ' AND ';
    		}
            $sql.=" saksi_nama LIKE '%".$saksi."%' ";  
            $sqland = true;
        }	
        if ($kajian != '')	{
    		if ($sqland) {
    		    $sql .= ' AND ';
    		}
            $sql.=" hasilkajian = '".$kajian."' ";  
            $sqland = true;
        }	
        //if ($jenispelanggaran != '') {
		    if (is_array($request->jenispelanggaran)) {
        		if ($sqland) {
        		    $sql .= ' AND ';
        		}
		        if (count($request->jenispelanggaran) > 1){
    	            $sql.=" (".rtrim($strjenispelanggaran, 'OR').") ";
		        } else {
	                $sql.= rtrim($strjenispelanggaran, 'OR');
		        }
		    } else {
		        if ($request->jenispelanggaran != '') {
            		if ($sqland) {
            		    $sql .= ' AND ';
            		}
		            $sql.=" pelanggaran LIKE ".$strjenispelanggaran." ";
		        }
		    }
        //}	
        if ($trendkajianawal != '')	{
    		if ($sqland) {
    		    $sql .= ' AND ';
    		}
            $sql.=" kajian_awal_id = '".$trendkajianawal."' ";  
            $sqland = true;
        }	
        if ($trendkajianakhir != '')	{
    		if ($sqland) {
    		    $sql .= ' AND ';
    		}
            $sql.=" kajian_akhir_id = '".$trendkajianakhir."' ";  
            $sqland = true;
        }	

		//$res_filtered=DB::select($sql." GROUP BY no");
		$res_filtered=DB::select($sql);
		if ($columnName=='kajian_awal') $columnName = 'id_kajianawal';
		if ($columnName=='kajian_akhir') $columnName = 'id_kajianakhir';
		$columnName=($columnName==''?'no':$columnName);
		//$sql.=' GROUP BY no order by '.$columnName." ".$columnSortOrder." limit ".$row.",".$rowperpage;
		$sql.=' order by '.$columnName." ".$columnSortOrder." limit ".$row.",".$rowperpage;
		//echo $sql; exit;
		//$sql.=' order by id desc';
		$res=DB::select($sql);
        //echo json_encode($res->result_array());
        
        $datax = array();
        $i = 0;
        foreach($res as $rowa) {
            $i++;
			$query = DB::table('t_tindaklanjut_kategori_tahapan as a')
					 ->join('m_tindaklanjut_status as b','a.id_status','=','b.id')
					 ->where('a.id_tindaklanjut',$rowa->id_tindaklanjutku)
					 ->select('b.nama')
					 ->orderBy('a.id_tindaklanjut','asc')
					 ->get();
			if ($query->count() > 0){
				$j=1;
				$rowa->id_tindaklanjutku = '<table celpadding=2 cellspacing=2 class=borderless>';
				foreach($query as $row){ 
          		    $rowa->id_tindaklanjutku .= '<tr><td width=1 valign=top>'.$j.'.</td><td width=98%>'.$row->nama.'</td></tr>';
				    $j++;
	 			}
				$rowa->id_tindaklanjutku .= '</table>';
		  	}
			else{
				$rowa->id_tindaklanjutku='';
			}
		  	$rowa->tgl_registrasi = (!is_null($rowa->tgl_registrasi) ? konversi_tanggal("j M Y",$rowa->tgl_registrasi) : '');
		  	$rowa->ringkasan = $rowa->ringkasan;
		  	$rowa->create_date = konversi_tanggal("j M Y",$rowa->create_date);
		  	$rowa->pelapor_tanggallahir = konversi_tanggal("j M Y",$rowa->pelapor_tanggallahir);
		  	$rowa->tgl_offline = konversi_tanggal("j M Y",$rowa->tgl_offline);
		  	$rowa->waktudiketahui = konversi_tanggal("j M Y",$rowa->waktudiketahui);
		  	$rowa->waktukejadian = konversi_tanggal("j M Y",$rowa->waktukejadian);
		  	$rowa->no_registrasi = ($rowa->no_registrasi <> '' ? $rowa->no_registrasi.'<br />'.$rowa->no_registrasi2 : $rowa->no_registrasi2);
		  	$rowa->luar_negeri = ($rowa->kejadiannegara <> 'Indonesia' ? $rowa->kejadiannegara : '');   
		  	$rowa->kecamatan = ($rowa->kabkota <> '' ? $rowa->kecamatan : '');
		  	$rowa->tanggal_pelaksanaan = '';
		  	$rowa->proses_sidang = '';
			$query_proses_sidang =DB::table("t_sidang_proses as a")->select('proses','tanggal')->where('a.id_sidang',$rowa->id_sidang)->orderBy('a.id','asc')->get();
        	if ($query_proses_sidang->count() > 0){
				$j=1;
				$rowa->proses_sidang = '<table celpadding=2 cellspacing=2 class=borderless>';
				foreach($query_proses_sidang as $row2){ 
              		$rowa->proses_sidang .= "<tr><td width=1 valign=top>".$j.'.</td><td width=98%>'.$row2->proses.'</td></tr>';
              		$rowa->tanggal_pelaksanaan .= konversi_tanggal("j M Y", $row2->tanggal).'<br />';
				    $j++;
	 			}
				$rowa->proses_sidang .= '</table>';
		  	}

		  	$rowa->proses_klarifikasi = '';
			$query_proses_klarifikasi = DB::table("t_klarifikasi_proses as a")->select('proses','tanggal')->where('a.id_klarifikasi',$rowa->id_klarifikasi)->orderBy('a.id','asc')->get();
        	if ($query_proses_klarifikasi->count() > 0){
				$j=1;
				$rowa->proses_klarifikasi = '<table celpadding=2 cellspacing=2 class=borderless>';
				foreach($query_proses_klarifikasi as $row2){ 
              		$rowa->proses_klarifikasi .= "<tr><td width=1 valign=top>".$j.'.</td><td width=98% valign="top">'.$row2->proses.'</td></tr>';
              		$rowa->tanggal_pelaksanaan .= konversi_tanggal("j M Y", $row2->tanggal).'<br />';
				    $j++;
	 			}
				$rowa->proses_klarifikasi .= '</table>';
		  	}
		  	$rowa->amar_putusan = '';
			$query2 = DB::table("t_putusan as a")->select('note')
					->join('t_laporan as b','a.id_laporan','=','b.id')
					->where('a.id_laporan',$rowa->id)->orderBy('a.id','asc')->get();
			if ($query2->count() > 0){
				$j=1;
				$rowa->amar_putusan = '<table celpadding=2 cellspacing=2 class=borderless>';
				foreach($query2 as $row2){ 
              		$rowa->amar_putusan .= "<tr><td width=1 valign=top>".$j.'.</td><td width=98% valign=top>'.$row2->note.'</td></tr>';
				    $j++;
	 			}
				$rowa->amar_putusan .= '</table>';
		  	}
		  	
		  	$rowa->display_none = '';
			$query3 = DB::table("t_kajianawal_pelanggaran as a")->select('a.id_pelanggaran','b.nama')
					->join('m_kajianawala_kategori as b','a.id_pelanggaran','=','b.id')
					->where('a.id_kajianawal',$rowa->id_kajianawal)->get();
			if ($query3->count() > 0){
				$j=1;
				foreach($query3 as $row3){ 
					$query4 = DB::table('t_kajianawal_pelanggaran as a')
							->join('t_kajianawal_pelanggaran_trend as b', function($join){
							    $join->on('a.id_pelanggaran', '=', 'b.id_pelanggaran');
							    $join->on('a.id_kajianawal','=', 'b.id_kajianawal');
							})
							->join('m_trendpelanggaran as c','b.id_trend','=','c.id')
							->where('a.id_kajianawal',$rowa->id_kajianawal)
							->where('b.id_pelanggaran',$row3->id_pelanggaran)
							->select('c.nama')
							->get();
	            	if ($query4->count() > 0){
						$k=1;
						foreach($query4 as $rowb){ 
						$rowa->display_none .= $rowb->nama.'<br> ';
						$k++;
			 			}
				  	} 
				$j++;
	 			}
		  	} 
            
            //$rowa->lptm = '';
		  	$rowa->kajian_awal = '';
			$query4x =DB::table("t_kajianawal_pelanggaran as a")->select('a.id_pelanggaran','b.nama')
					->join('m_kajianawala_kategori as b','a.id_pelanggaran','=','b.id')
					->where('a.id_kajianawal',$rowa->id_kajianawal)->get();
        	if ($query4x->count() > 0){
				$j=1;
				$html_tk_hd='';$html_tk_dt='';$html_tk_ft='';
				$rowa->kajian_awal = '<table celpadding=10 cellspacing=10 class=borderless>';
				foreach($query4x as $row){
					$html_tk_dt='';
					$html_tk_hd= "<tr><td width=1 valign=top>".$j.'.</td><td width=98% valign=top>'.$row->nama.'</td></tr>';
					$query5x = DB::table('t_kajianawal_pelanggaran as a')
							->join('t_kajianawal_pelanggaran_trend as b', function($join){
							    $join->on('a.id_pelanggaran', '=', 'b.id_pelanggaran');
							    $join->on('a.id_kajianawal','=', 'b.id_kajianawal');
							})
							->join('m_trendpelanggaran as c','b.id_trend','=','c.id')
							->where('a.id_kajianawal',$rowa->id_kajianawal)
							->where('b.id_pelanggaran',$row->id_pelanggaran)
							->select('c.nama')
							->get();
	            	if ($query5x->count() > 0){
						$k=1;
						$html_tk_dt= '<tr><td></td><td><table celpadding=10 cellspacing=10 class=borderless>';
						foreach($query5x as $rowb){ 
	              			$html_tk_dt.="<tr><td width=1 valign=top>".$k.'.</td><td width=98% valign=top>'.$rowb->nama.'</td></tr>';
						$k++;
			 			}
						$html_tk_ft= '</td></tr></table>';
				  	}
					if($html_tk_dt!=''){
						$rowa->kajian_awal .= $html_tk_hd.$html_tk_dt.$html_tk_ft;
						$j++;
					}
	 			}
	 			//$rowa->lptm .= '</table>';
				$rowa->kajian_awal .= '</table>';
		  	} 
            
            $rowa->display_none2 = '';
			$query6 =DB::table("t_kajianakhir_trend as a")->select('b.nama')
					->join('m_trendpelanggaran as b','a.id_trend','=','b.id')
					->where('a.id_kajianakhir',$rowa->id_kajianakhir)->get();
        	if ($query6->count() > 0){
				$j=1;
				foreach($query6 as $row){ 
					$rowa->display_none2 .= $row->nama.' ';
					$j++;
	 			}
		  	}
            
            $rowa->kajian_akhir = '';
			$query7 = DB::table("t_kajianakhir_trend as a")->select('b.nama')
					->join('m_trendpelanggaran as b','a.id_trend','=','b.id')
					->where('a.id_kajianakhir',$rowa->id_kajianakhir)->get();
        	if ($query7->count() > 0){
				$j=1;
				$rowa->kajian_akhir .= '<table celpadding=10 cellspacing=10 class=borderless>';
				foreach($query7 as $row){ 
					$rowa->kajian_akhir .=  "<tr><td width=1 valign=top>".$j.'.</td><td width=98% valign=top>'.$row->nama.'</td></tr>';
					$j++;
	 			}
				$rowa->kajian_akhir .=  '</table>';
		  	} 
		  	//if ($i!=1) {
            $datax[] = $rowa;
			//} else {
			//	print_r($rowa);
			//}
        }
        $response = array(
            "draw" => $draw,
            "recordsTotal" => (int)$row_count,
            "recordsFiltered" => count($res_filtered),
            "InStock" => 17,
            "sql" => $sql,
            "data" => $datax
        );
        echo json_encode($response);
	}
	function add_ajax_kab($prov){
		$data = "<option value=''>- Pilih Kabupaten -</option>";
		if($prov!=''){
			$prov=trim(rawurldecode($prov));
			$provs=explode(',',$prov);
			foreach($provs as $pro) {
        		$data_prov = DB::table("m_provinsi")->where('nama',$pro)->first()->kode;
    			$query = DB::table("m_kabkota")->whereRaw("substr(kode,1,2)='".substr($data_prov,0,2)."'")->get();
    			if(!empty($query)){
    		    	foreach ($query as $value) {
    		        	$data .= "<option value='".$value->nama."'>".$value->nama."</option>";
    		    	}
    			}
			}
		}
    	echo $data;
	}
	function index(){
		$title = 'Rekap Pemilihan';
     	$main = 'be.m_rekap_pemilihan_list';
		$params['locus']=session('be_uwilayah');
     	$list = M_rekapa::daftar($params);
		$arrLink=array(
				array("Rekap Pemilihan",route('m_rekappemilihan.index'))
				);
		$provinsi = DB::table("m_provinsi")->get();
		$kejadiannegara = DB::table("m_negara")->get();
		if(substr(session('be_uwilayah'),3,2)=='00'){
			$data_kaba =DB::table("m_kabkota")->whereRaw("substr(kode,1,2)='".substr(session('be_uwilayah'),0,2)."'")->get();
		}
		$tahapan = DB::table("m_tahapan")->get();
		$trend = DB::table("m_trendpelanggaran")->get();
		$hasilkajian = DB::table("m_status_kategori")->where('level',1)->get();
		$pelanggaran = DB::table("m_kajianakhir_kategori")->where('level',1)->get();
		
		return view($main,compact('arrLink','title','list','provinsi','kejadiannegara','tahapan','trend','hasilkajian','pelanggaran'));
	}
}
