<?php

namespace App\Http\Controllers;

use DB;
use App\Models\M_periode;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_PeriodeController extends Controller
{
	public function __construct()
    {
    }
	public function index()
    {
		$arrLink=array(
			array("Periode",route('m_periode.index'))
		);
		$title='Daftar Periode Pemilihan/Pemilu';
		$tambah = 'href="'.route('m_periode.add').'"';
		return view('be.m_periode_list',compact('arrLink','title','tambah'));
    }
	function add($id = NULL)
    {
		if(!cekintnull(dc($id))){
			return redirect()->route('denied.index');
		}
		$id=dc($id);
		$operation = is_null($id) ? 'Tambah' : 'Ubah';
		$title = $operation.' Periode Pemilihan/Pemilu';
		$arrLink=array(
				array("Periode",route('m_user.index'))
				);
		$params['id'] =$id;
		$data=null;
		if(isset($id)){
			$data=M_periode::daftar($params);
		}
		return view('be.m_periode_add',compact('arrLink','operation','title','data'));
	}
	function view($id = NULL){
		if(!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$id=dc($id);
		$operation = 'View';
		$title = $operation.' Periode Pemilihan/Pemilu';
		$arrLink=array(
				array("Periode",route('m_periode.index'))
				);
		$params['id'] =$id;
		$data=null;
		if(isset($id)){
			$data=M_periode::daftar($params);
		}
		return view('be.m_periode_view',compact('arrLink','operation','title','data'));
	}
	public function save(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$params['nama'] = getinp($request->nama);
		$params['aktif'] = getinp($request->aktif);
		
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		if($params['nama']!=""&&!is_null($params['nama'])){
			$data=M_periode::add($params);
	        M_log::add(
	           array(
	               'stsfrom' => 2,
	               'modul' => 'User',
	               'aksi' => $dt['operation'],
	               'note' => 'ID:'.$id.', Title: User '.$params['nama'].' sudah di '.strtolower($dt['operation']),
	               'ip' => $request->ip()
	           )
	        );
			$request->session()->flash('success', $dt['operation'] . ' Data Berhasil');
		}
		return redirect()->route('m_periode.index')->with('success', $dt['operation'] . ' Data Berhasil');
	}
	function del($id = NULL,Request $request)
	{
		if(!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$id=dc($id);
		$str="select 1 from t_laporan where id_periode=".$id." limit 1";
		$data=DB::select($str);
		if($data){
			return redirect()->route('m_periode.index')->with('failed', 'Hapus Data Tidak Berhasil');
		}
		else{
			$str="select nama from m_periode where id=".$id." limit 1";
			$nama=DB::select($str)[0]->nama;
			M_log::add(
	           array(
	               'stsfrom' => 2,
	               'modul' => 'User',
	               'aksi' => 'Hapus',
	               'note' => 'ID:'.$id.', Title: Periode '.$nama.' sudah dihapus',
	               'ip' => $request->ip()
	           )
	        );
			M_periode::del($id);
			return redirect()->route('m_periode.index')->with('success', 'Hapus Data Berhasil');
		}
	}
	function list_result(Request $request):JsonResponse
	{
		if($request->ajax()){
			$collection =DB::table('m_periode as a')->selectRaw("id,nama,aktif,
			(case when aktif=1 then 'Aktif' else 'Tidak Aktif' end) nm_aktif, 
			coalesce((select 1 from t_laporan where id_periode=a.id limit 1),'') sts_lock");
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->make(true);
		}
    }
}
