<?php

namespace App\Http\Controllers;

use DB;
use App\Models\General;
use App\Models\M_laporan;
use App\Models\M_pemeriksaan;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_PemeriksaanController extends Controller
{
	public function __construct()
    {
    }
	public function index($id_jenislaporan=null)
    {
        if(!cekjenislapor3(dc($id_jenislaporan))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $id_jenislaporan=dc($id_jenislaporan);
		$arrLink=array(
			array("Pemeriksaan",route('m_pemeriksaan.index').'/'.$ec_id_jenislaporan)
		);
		$title='Daftar Pemeriksaan';
		$tambah = 'href="'.route('m_pemeriksaan.add').'/'.$ec_id_jenislaporan.'"';
		return view('be.m_pemeriksaan_list',compact('arrLink','title','tambah','ec_id_jenislaporan'));
    }
	function list_result($id_jenislaporan=null,Request $request):JsonResponse
	{
		//if($request->ajax()){
			$id_jenislaporan=dc($id_jenislaporan);
			$params['locus'] = session('be_uwilayah');
			$params['id_jenislaporan'] = $id_jenislaporan;
			$params['id_periode']=DB::table('m_periode')->select('id')->where('aktif','=',1)->get()[0]->id;
			$collection = M_pemeriksaan::daftar_index($params);
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->addColumn('urls', function ($arrData){
				$s='';
				if($arrData->url!=''){
					$s='<a href="'.$arrData->url.'" target="_blank">'.$arrData->url.'</a>';
				}
				return $s;
			})
			->addColumn('aksi', function ($arrData){
				$s='<br>
					<div align="center dropdown">
                        <button class="btn btn-primary dropdown-toggle btn-sm" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          Aksi
                        </button>
                      <ul class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                          <li><a class="dropdown-item btn-sm" href="'.route('m_pemeriksaan.view').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa fa-file-archive-o"></i> Tampil</a></li>
						  ';
						  if (session('be_urole')!=4){
						  	if ($arrData->locus==session('be_uwilayah')||session('be_urole')==3){
							  $s.='<li><a class="dropdown-item btn-sm" href="'.route('m_pemeriksaan.add').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa ti-write"></i> Ubah</a>
							       <li><a class="dropdown-item btn-sm item_delete" data-id="'.ec($arrData->id).'" data-nm="'.$arrData->no.'"><i class="fa fa-trash-o"></i> Hapus</a></li>';
                          	}
						  }
                      $s.='</ul>
                    </div>
				';
				return $s;
			})
			->make(true);
		//}
    }
	function add($id_jenislaporan=null,$id = NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekintnull(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id=dc($id);
		$data=null;
		
		if(isset($id)){
			$paramsdt['id'] = $id;
			$data = M_pemeriksaan::daftar($paramsdt);
			if($data){
				$locus=$data->locus;
				$stsposisi=$data->stsposisi;
				$id_jenislaporan=$data->id_jenislaporan;
				
				if(General::cekaksesedit($locus)){
					//do nothing
				}
				else{
					return redirect()->route('denied');
				}
			}
			else{
				return redirect()->route('denied');
			}
		}
		$title = 'Tambah Pemeriksaan';
     	$main = 'be.m_pemeriksaan_add';
     	$arrLink=array(
				array("pemeriksaan",route('m_pemeriksaan.index').'/'.$ec_id_jenislaporan)
				);
		$tambah = 'href="'.route('m_pemeriksaan.add').'/'.$ec_id_jenislaporan.'"';
     	$params['id_jenislaporan'] = $id_jenislaporan;
		
     	$params['table'] = 't_pemeriksaan';
		if($id_jenislaporan==3){
     		$params['stsposisi'] = 'Sidang';
		}
		else{
     		$params['stsposisi'] = 'Klarifikasi';
		}
		$params['locus'] =session('be_uwilayah');
		$params['id_periode']=DB::table('m_periode')->selectRaw('id,nama')->where('aktif',1)->first()->id;
		$listlaporan = M_laporan::daftardengannoreg($params);
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','data','listlaporan'));
	}
	function view($id_jenislaporan=null,$id = NULL){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id=dc($id);
		
		if(isset($id)){
			$paramsdt['id'] = $id;
			$data = M_pemeriksaan::daftar($paramsdt);
			if($data){
				$id_jenislaporan=$data->id_jenislaporan;
				if(!General::cekaksesview($data->locus)){
					return redirect()->route('denied');
				}
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		$title = 'Pemeriksaan';
     	$main = 'be.m_pemeriksaan_view';
     	$arrLink=array(
				array("pemeriksaan",route('m_pemeriksaan.index').'/'.$ec_id_jenislaporan)
				);
		$tambah = 'href="'.route('m_pemeriksaan.add').'/'.$ec_id_jenislaporan.'"';
     	$params['id_jenislaporan'] = $id_jenislaporan;
		$params['id_periode']=DB::table('m_periode')->selectRaw('id,nama')->where('aktif',1)->first()->id;
		
     	$params['table'] = 't_pemeriksaan';
		$listlaporan = M_laporan::daftardengannoreg($params);
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','data','listlaporan'));
	}
	function save(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$id_jenislaporan = getinp($request->id_jenislaporan);
		$params['id_laporan'] = getinp($request->id_laporan);
		
		if(!cekjenislapor3($id_jenislaporan)||!cekint($params['id_laporan'])||!cekintnull($id)){
			return redirect()->route('denied');
		}
		
		$params['note'] = getinp($request->note);
		$params['url'] = getinp($request->url);
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		
		if($dt['operation']=='Ubah'){
			$datalap=DB::table("t_pemeriksaan as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					 ->selectRaw('b.no,b.locus,b.stsposisi')->where('a.id',$id)->first();
			if(!empty($datalap)){
				$no=$datalap->no;
				$stsposisi=$datalap->stsposisi;
				$ceklocus=$datalap->locus;
				
				if(General::cekaksesedit($ceklocus)){
					//do nothing
				}
				else{
					return redirect()->route('denied');
				}
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			$datalap=M_laporan::selectRaw('no,locus,stsposisi')->where('id',$params['id_laporan'])->first();
			if(!empty($datalap)){
				$no=$datalap->no;
				$ceklocus=$datalap->locus;
				$cekstsposisi=$datalap->stsposisi;
				
				if(!General::cekaksesedit($ceklocus)){
					return redirect()->route('denied');
				}
			}
			else{
				return redirect()->route('denied');
			}
		}
		
		$paramslaporan['id']=$params['id_laporan'];
		$paramslaporan['stsposisi']='Pemeriksaan';
		M_laporan::setposisi($paramslaporan);
		
		if($dt['operation']=='Tambah'){
			$params['create_by'] =  session('be_uid');
			$params['create_date'] =  date("Y-m-d H:i:s");
		}
		elseif($dt['operation']=='Ubah'){
			$params['edit_by'] =  session('be_uid');
			$params['edit_date'] =  date("Y-m-d H:i:s");
		}
		$data=M_pemeriksaan::add($params);
		if($data){
			$id=$data;
		}
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Pemeriksaan',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: Pemeriksaan dengan pelaporan no '.$no.' sudah di '.strtolower($dt['operation']),
               'ip' => $request->ip()
           )
        );
		echo route('m_pemeriksaan.index').'/'.ec($id_jenislaporan);
	}
	function del($id_jenislaporan=null,$id = NULL,Request $request){
		if(!cekjenislapor3(dc($id_jenislaporan))||!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$ec_id_jenislaporan=$id_jenislaporan;
		$ec_id=$id;
		$id_jenislaporan=dc($id_jenislaporan);
		$id=dc($id);
		
		$datalap=DB::table("t_pemeriksaan as a")->join('t_laporan as b','a.id_laporan','=','b.id')
				 ->selectRaw('b.id,b.id_jenislaporan,b.no,b.locus,b.stsposisi')->where('a.id',$id)->first();
		if(!empty($datalap)){
			$idlap=$datalap->id;
			$id_jenislaporan=$datalap->id_jenislaporan;
			$no=$datalap->no;
			$ceklocus=$datalap->locus;
			$stsposisi=$datalap->stsposisi;
			
			if(General::cekaksesedit($ceklocus)){
				//do nothing
			}
			else{
				return redirect()->route('denied');
			}
		}
		else{
			return redirect()->route('denied');
		}
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Pemeriksaan',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Pemeriksaan dengan pelaporan no '.$no.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
		$data=M_pemeriksaan::del($id);
		
		$params['id']=$idlap;
		$params['edit_by'] =  session('be_uid');
		$params['edit_date'] =  date("Y-m-d H:i:s");
		if($id_jenislaporan==3){
			$params['stsposisi']='Sidang';
		}
		else{
			$params['stsposisi']='Klarifikasi';
		}
		M_laporan::add($params);
		
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Pemeriksaan',
               'aksi' => 'Ubah',
               'note' => 'ID:'.$idlap.', Title: Pelaporan no '.$no.' diubah status posisinya menjadi '.$params['stsposisi'],
               'ip' => $request->ip()
           )
        );
		return redirect()->route('m_pemeriksaan.index',['id_jenislaporan'=>$ec_id_jenislaporan]);
	}
}
