<?php

namespace App\Http\Controllers;

use DB;
use App\Models\M_notifikasia;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_NotifikasiaController extends Controller
{
	public function __construct()
    {
    }
	public function index()
    {
		$arrLink=array(
			array("Notifikasi",route('m_notifikasia.index'))
		);
		$title='Daftar Notifikasi';
		$tambah = 'href="'.route('m_periode.add').'"';
		return view('be.m_notifikasia_list',compact('arrLink','title','tambah'));
    }
	function list_result(Request $request):JsonResponse
	{
		//if($request->ajax()){
			$collection = M_notifikasia::select('*');
			//$collection = DB::select('select * from t_notifikasia');
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->addColumn('tanggal', function ($arrData){
				return konversi_tanggal('j M Y H:i:s',$arrData->tanggal_buat,'idshort');
			})
			->make(true);
		//}
    }
}
