<?php

namespace App\Http\Controllers;

use DB;
use DateTime;
use App\Models\General;
use App\Models\M_kajianakhir_kategori;
use App\Models\M_trendpelanggaran;
use App\Models\M_laporan;
use App\Models\M_kajianakhir;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_KajianAkhirController extends Controller
{
	public function __construct()
    {
    }
	public function index($id_jenislaporan=null)
    {
        if(!cekjenislapor3(dc($id_jenislaporan))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $id_jenislaporan=dc($id_jenislaporan);
		$arrLink=array(
			array("Kajian Akhir",route('m_kajianakhir.index').'/'.$ec_id_jenislaporan)
		);
		$title='Daftar Kajian Akhir';
		$tambah = 'href="'.route('m_kajianakhir.add').'/'.$ec_id_jenislaporan.'"';
		return view('be.m_kajianakhir_list',compact('arrLink','title','tambah','ec_id_jenislaporan'));
    }
	function list_result($id_jenislaporan=null,Request $request):JsonResponse
	{
		//if($request->ajax()){
			$id_jenislaporan=dc($id_jenislaporan);
			$params['locus'] = session('be_uwilayah');
			$params['id_jenislaporan'] = $id_jenislaporan;
			$params['id_periode']=DB::table('m_periode')->select('id')->where('aktif','=',1)->get()[0]->id;
			$collection = M_kajianakhir::daftar_index($params);
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->addColumn('notes', function ($arrData){
				$s=substr($arrData->note,0,50).'...<br>';
				if($arrData->dokumen!=''){
					$s.='<a href="'.route("download.be_ka_dk").'/'.rawurlencode($arrData->dokumen).'" class="btn btn-primary btn-xs"><i class=" ti-download"></i> Download</a>';
				}
				return $s;
			})
			->addColumn('aksi', function ($arrData){
				$s='<br>
					<div align="center dropdown">
                        <button class="btn btn-primary dropdown-toggle btn-sm" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          Aksi
                        </button>
                      <ul class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                          <li><a class="dropdown-item btn-sm" href="'.route('m_kajianakhir.view').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa fa-file-archive-o"></i> Tampil</a></li>
						  <li><a class="dropdown-item btn-sm" href="'.route('m_kajianakhir.daftar_dokumen').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa fa-file-archive-o"></i> Dokumen</a></li>
						  ';
						  if (session('be_urole')==3){
						  	$s.='<li><a class="dropdown-item btn-sm" href="'.route('m_kajianakhir.trend').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa ti-write"></i> Ubah Trend</a></li>';
						  }
						  if (session('be_urole')!=4){
						  	if ($arrData->locus==session('be_uwilayah')||session('be_urole')==3){
							  $s.='<li><a class="dropdown-item btn-sm" href="'.route('m_kajianakhir.add').'/'.ec($arrData->id_jenislaporan).'/'.ec($arrData->id).'"><i class="fa ti-write"></i> Ubah</a>
							       <li><a class="dropdown-item btn-sm item_delete" data-id="'.ec($arrData->id).'" data-nm="'.$arrData->no.'"><i class="fa fa-trash-o"></i> Hapus</a></li>';
                          	}
						  }
                      $s.='</ul>
                    </div>
				';
				return $s;
			})
			->make(true);
		//}
    }
    function add_ajax_kat($id){
		$query=DB::table('m_kajianakhir_kategori')->where('parent_id',$id)->get();
        $data = "<option value=''>- Pilih Kategori -</option>";
        foreach ($query as $value) {
            $data .= "<option value='".$value->id."'>".$value->nama."</option>";
        }
        echo $data;
    }
	function daftar_dokumen($id_jenislaporan=null,$id_kajianakhir=null){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_kajianakhir))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id_kajianakhir=$id_kajianakhir;
        $id_jenislaporan=dc($id_jenislaporan);
        $id_kajianakhir=dc($id_kajianakhir);
        $paramsgetlap['id']=$id_kajianakhir;
        $no='';$locus='';$stsposisi='';
		$datalap=null;$tambah=null;
		
        if($paramsgetlap['id']!=""){
            $datalap=M_kajianakhir::getlaporan($paramsgetlap);
            $no=$datalap->no;
            $locus=$datalap->locus;
            $stsposisi=$datalap->stsposisi;
            $id_jenislaporan=$datalap->id_jenislaporan;
        }
        $title = 'Dokumen Kajian Akhir <br><font class=subjudul>'.$no.'</font>';
        $main = 'be.m_kajianakhirdok_list';
        $arrLink=array(
                array("Kajian Akhir",route('m_kajianakhir.index').'/'.$ec_id_jenislaporan),
                array("Dokumen",route('m_kajianakhir.daftar_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_kajianakhir),
                );
        if($locus==session('be_uwilayah')||session('be_urole')==3){
            $tambah = 'href="'.route('m_kajianakhir.add_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_kajianakhir.'"';
        }
        $params['id_kajianakhir'] = $id_kajianakhir;
        $list = M_kajianakhir::daftar_dokumen($params);
		return view($main,compact('arrLink','title','id_jenislaporan','id_kajianakhir','tambah','datalap','no','locus','stsposisi','list'));
    }
    function add($id_jenislaporan=null,$id = NULL){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekintnull(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
		$data=null;$tambah=null;
		$m_kajiankategori=null;
		
        if(isset($id)){
            $paramsdt['id']=$id;
            $data = M_kajianakhir::daftar($paramsdt);
            if($data){
                $locus=$data->locus;
                $stsposisi=$data->stsposisi;
                $id_jenislaporan=$data->id_jenislaporan;
                
                if(General::cekaksesedit($locus)){
                    //do nothing
                }
                else{
                    return redirect()->route('denied');
                }
            }
            $paramskat['id_kajianakhir']=$id;
            $m_kajiankategori = M_kajianakhir::daftar_kategori($paramskat);
        }
        $title = 'Tambah Kajian Akhir';
        $main = 'be.m_kajianakhir_add';
        $arrLink=array(
                array("Kajian Akhir",route('m_kajianakhir.index').'/'.$ec_id_jenislaporan)
                );
        $tambah = 'href="'.route('m_kajianakhir.add').'/'.$ec_id_jenislaporan.'"';
        $params['id_jenislaporan'] = $id_jenislaporan;
        $params['table'] = 't_kajianakhir';
        $params['stsposisi'] = 'Pemeriksaan';
        $params['locus'] = session('be_uwilayah');
        $params['id_periode']=DB::table('m_periode')->selectRaw('id,nama')->where('aktif',1)->first()->id;
        $listlaporan = M_laporan::daftardengannoreg($params);
        
        $paramskat1['level']=1;
        $m_kat1 = M_kajianakhir_kategori::daftar($paramskat1);
        $m_trendpelanggaran = M_trendpelanggaran::daftar();
		
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','data','listlaporan','m_kat1','m_trendpelanggaran','m_kajiankategori'));
    }
    function view($id_jenislaporan=null,$id = NULL){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
		$data=null;$tambah=null;
		
        if(isset($id)){
            $paramsdt['id']=$id;
            $data = M_kajianakhir::daftar($paramsdt);
            if($data){
                $id_jenislaporan=$data->id_jenislaporan;
                
                if(!General::cekaksesview($data->locus)){
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
            $paramskat['id_kajianakhir']=$id;
            $m_kajiankategori = M_kajianakhir::daftar_kategori($paramskat);
        }
        else{
            return redirect()->route('denied');
        }
        $title = 'Kajian Akhir';
        $main = 'be.m_kajianakhir_view';
        $arrLink=array(
                array("Kajian Akhir",route('m_kajianakhir.index').'/'.$ec_id_jenislaporan)
                );
        $tambah = 'href="'.route('m_kajianakhir.add').'/'.$ec_id_jenislaporan.'"';
        $params['id_jenislaporan'] = $id_jenislaporan;
        
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','data','m_kajiankategori'));
    }
    function trend($id_jenislaporan=null,$id = NULL){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
		$data=null;$tambah=null;
		
        if(isset($id)){
            $paramsdt['id']=$id;
            $data = M_kajianakhir::daftar($paramsdt);
            if($data){
                $id_jenislaporan=$data->id_jenislaporan;
                
                if(!General::cekaksesview($data->locus)){
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
            $paramskat['id_kajianakhir']=$id;
            $m_kajiankategori = M_kajianakhir::daftar_kategori($paramskat);
        }
        else{
            return redirect()->route('denied');
        }
        $title = 'Kajian Akhir';
         $main = 'be.m_kajianakhir_trend';
         $arrLink=array(
                array("Kajian Akhir",route('m_kajianakhir.index').'/'.$ec_id_jenislaporan)
                );
        $tambah = 'href="'.route('m_kajianakhir.add').'/'.$ec_id_jenislaporan.'"';
        $params['id_jenislaporan'] = $id_jenislaporan;
        $m_trendpelanggaran = M_trendpelanggaran::daftar();
        
		return view($main,compact('arrLink','title','id_jenislaporan','tambah','data','m_kajiankategori','m_trendpelanggaran'));
    }
    function add_dokumen($id_jenislaporan=null,$id_kajianakhir = NULL, $id=NULL){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_kajianakhir))||!cekintnull(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id_kajianakhir=$id_kajianakhir;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id_kajianakhir=dc($id_kajianakhir);
        $id=dc($id);
		$datalap=null;$tambah=null;$data=null;
        
        $paramsgetlap['id']=$id_kajianakhir;
        $no='';
        if($paramsgetlap['id']!=""){
            $datalap=M_kajianakhir::getlaporan($paramsgetlap);
            $no=$datalap->no;
            $locus=$datalap->locus;
            $stsposisi=$datalap->stsposisi;
            //$id_jenislaporan=$datalap->d_jenislaporan;
            
            if(General::cekaksesedit($locus)){
            }
            else{
                return redirect()->route('denied');
            }
        }
        else{
            return redirect()->route('denied');
        }
        
        $title = 'Dokumen Kajian Akhir <br><font class=subjudul>'.$no.'</font>';
        $main = 'be.m_kajianakhirdok_add';
        $arrLink=array(
                array("Kajian Akhir",route('m_kajianakhir.index').'/'.$ec_id_jenislaporan),
                array("Dokumen",route('m_kajianakhir.daftar_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_kajianakhir),
                );
        $tambah = 'href="'.route('m_kajianakhir.add_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_kajianakhir.'"';
        $paramskat1['level']=1;
        
        if(isset($id)){
            $params['id']=$id;
            $data = M_kajianakhir::daftar_dokumen($params);
        }
        
		return view($main,compact('arrLink','title','id_jenislaporan','id_kajianakhir','tambah','datalap','data','no'));
    }
    function view_dokumen($id_jenislaporan=null,$id_kajianakhir = NULL, $id=NULL){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_kajianakhir))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $ec_id_kajianakhir=$id_kajianakhir;
        $ec_id=$id;
        $id_jenislaporan=dc($id_jenislaporan);
        $id_kajianakhir=dc($id_kajianakhir);
        $id=dc($id);
		$datalap=null;$tambah=null;$data=null;
        
        $paramsgetlap['id']=$id_kajianakhir;
        $no='';$locus='';$stsposisi='';
        if($paramsgetlap['id']!=""){
            $datalap=M_kajianakhir::getlaporan($paramsgetlap);
            $no=$datalap->no;
            $locus=$datalap->locus;
            $stsposisi=$datalap->stsposisi;
            $id_jenislaporan=$datalap->id_jenislaporan;
            if($locus){
                
                if(!General::cekaksesview($locus)){
                    return redirect()->route('denied');
                }
            }
        }
        else{
            return redirect()->route('denied');
        }
        
        $title = 'Dokumen Kajian Akhir <br><font class=subjudul>'.$no.'</font>';
        $main = 'be.m_kajianakhirdok_view';
        $arrLink=array(
                array("Kajian Akhir",route('m_kajianakhir.index').'/'.$ec_id_jenislaporan),
                array("Dokumen",route('m_kajianakhir.daftar_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_kajianakhir),
                );
        if($locus==session('be_uwilayah')||session('be_urole')==3){
            $tambah = 'href="'.route('m_kajianakhir.add_dokumen').'/'.$ec_id_jenislaporan.'/'.$ec_id_kajianakhir.'"';
        }
        $paramskat1['level']=1;
        
        if(isset($id)){
            $params['id']=$id;
            $data = M_kajianakhir::daftar_dokumen($params);
        }
		return view($main,compact('arrLink','title','id_jenislaporan','id_kajianakhir','tambah','no','locus','stsposisi','data'));
    }
    function save_trend(Request $request){
        $id = getinp($request->id);
        $id_jenislaporan = getinp($request->id_jenislaporan);
        $id_laporan = getinp($request->id_laporan);
        if(!cekjenislapor2($id_jenislaporan)||!cekint($id_laporan)||!cekintnull($id)){
            return redirect()->route('denied');
        }
        $trend= $request->trendpelanggaran;
		DB::table('t_kajianakhir_trend')->where('id_kajianakhir',$id)->delete();
        if($trend!=''){
            $urut=1;
            foreach($trend as $item_trend){
                if($item_trend!=''){
					DB::table('t_kajianakhir_trend')->insert([
						'id_kajianakhir'=>$id,
						'urut'=>$urut,
						'id_trend'=>$item_trend,
						'create_by'=>session('be_uid'),
						'create_date'=>date("Y-m-d H:i:s")
					]);
                }
                $urut++;
            }
        }
        $datalap=M_laporan::select('no')->where("id",$id_laporan)->first();
        $no=$datalap->no;
		
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Kajian Akhir::Trend Pelanggaran',
               'aksi' => "Ubah",
               'note' => 'ID:'.$id.', Title: Trend Pelanggaran Kajian akhir dengan pelaporan no '.$no.' sudah diubah',
               'ip' => $request->ip()
           )
        );
        echo route('m_kajianakhir.index').'/'.ec($id_jenislaporan);
        exit;
    }
    function save(Request $request){
        $id = getinp($request->id);
        $params['id'] = $id;
        $id_jenislaporan = getinp($request->id_jenislaporan);
        $params['id_laporan'] = getinp($request->id_laporan);
		
        if(!cekjenislapor2($id_jenislaporan)||!cekint($params['id_laporan'])||!cekintnull($id)){
            return redirect()->route('denied');
        }
        $params['note'] = getinpb($request->note);
        $dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
        $paramslaporan['id']=$params['id_laporan'];
        $paramslaporan['stsposisi']='Kajian Akhir';
        M_laporan::setposisi($paramslaporan);
        
        if($dt['operation']=='Ubah'){
			$datalap=DB::table("t_kajianakhir as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					 ->where('a.id','=',$id)
					 ->selectRaw('b.no,b.locus,b.stsposisi')->first();
            if(!empty($datalap)){
                $no=$datalap->no;
                $stsposisi=$datalap->stsposisi;
                $ceklocus=$datalap->locus;
                
                if(General::cekaksesedit($ceklocus)){
                    //do nothing
                }
                else{
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
        }
        else{
			$datalap=DB::table("t_laporan")->selectRaw('no,locus,stsposisi')->where('id','=',$params['id_laporan'])->first();
            if(!empty($datalap)){
                $no=$datalap->no;
                $ceklocus=$datalap->locus;
                $cekstsposisi=$datalap->stsposisi;
                
                if(!General::cekaksesedit($ceklocus)){
                    return redirect()->route('denied');
                }
            }
            else{
                return redirect()->route('denied');
            }
        }
        
        if($dt['operation']=='Tambah'){
            $params['create_by'] =  session('be_uid');
            $params['create_date'] =  date("Y-m-d H:i:s");
        }
        elseif($dt['operation']=='Ubah'){
            $params['edit_by'] =  session('be_uid');
            $params['edit_date'] =  date("Y-m-d H:i:s");
        }
        $data=M_kajianakhir::add($params);
        if($data){
            $id=$data;
        }
        
        $trend= $request->trendpelanggaran;
		DB::table('t_kajianakhir_trend')->where('id_kajianakhir',$id)->delete();
        if($trend!=''){
            $urut=1;
            foreach($trend as $item_trend){
                if($item_trend!=''){
                    DB::table('t_kajianakhir_trend')->insert([
						'id_kajianakhir'=>$id,
						'urut'=>$urut,
						'id_trend'=>$item_trend,
						'create_by'=>session('be_uid'),
						'create_date'=>date("Y-m-d H:i:s")
					]);
				}
                $urut++;
            }
        }
        
        $dokumen='';
		if (!empty($request->file('dokumen'))){
			$file=$request->file('dokumen');
			$file_name=$file->getClientOriginalName();
			$file_ext=$file->extension();
			$date=new DateTime();
			$namafile=aksi_upload($file,'kajianakhir',$no.'-'.$date->format('Y-m-d-H-i-s').'-dokumen',$file_ext);
			$paramsupd['dokumen'] = $namafile;
			$paramsupd['id']=$id;
            $dokumen=$namafile;
            $data=M_kajianakhir::add($paramsupd);
		}
		if (!empty($request->file('rekomendasi_file'))){
			$file=$request->file('rekomendasi_file');
			$file_name=$file->getClientOriginalName();
			$file_ext=$file->extension();
			$date=new DateTime();
			$namafile=aksi_upload($file,'kajianakhir',$no.'-'.$date->format('Y-m-d-H-i-s').'-rekomendasi',$file_ext);
			$paramsupd['rekomendasi_file'] = $namafile;
			$paramsupd['id']=$id;
            $data=M_kajianakhir::add($paramsupd);
		}
        if(isset($id)&&$dt['operation']=='Tambah'){
            $paramsdokumen['id_kajianakhir'] = $id;
            $paramsdokumen['dokumen']=$dokumen;
            $paramsdokumen['note']=$params['note'];
            $paramsdokumen['create_by'] =  session('be_uid');
            $paramsdokumen['create_date'] =  date("Y-m-d H:i:s");
            $data=M_kajianakhir::add_dokumen($paramsdokumen);
        }
        $id_kat1=$request->id_kat1;
        $id_kat2=$request->id_kat2;
        $id_kat3=$request->id_kat3;
        $id_kat_trend=$request->id_kat_trend;
        $rekomendasi_fileidx=$request->rekomendasi_fileidx;
        $rekomendasi_no=$request->rekomendasi_no;
        $index = 0;
        $urut=1;
        $data = array();
        $date=new DateTime();
        if(isset($id_kat_trend)){
            foreach($id_kat_trend as $item){
                if($item!=''){
					$item_trend=null;
                    $idkattrend = explode(', ', getinpb($item));
					if($idkattrend[0]!=getinpb($item)){
						$item_trend=$idkattrend[1];
					}
					else{
						$idkattrend[0]=str_replace(",","",$idkattrend[0]);
					}
					$file=null;$file_name=null;
					if(!empty($request->file('rekomendasi_file'.$rekomendasi_fileidx[$index]))){
						$file=$request->file('rekomendasi_file'.$rekomendasi_fileidx[$index]);
						$file_name=$file->getClientOriginalName().'.'.$file->extension();
					}
                    array_push($data, array(
                    'urut'=>$urut,
                    'id_kajianakhir'=>getinpb($id),
                    'id_kat1'=>$idkattrend[0],
                    'id_trend'=>$item_trend,
                    'rekomendasi_no'=>getinpb($rekomendasi_no[$index]),
                    'rekomendasi_file'=>(!empty($file_name)?aksi_upload($file,'kajianakhir',$date->format('Y-m-d-H-i-s').'-'.$file_name):$request->input('rekomendasi_fileold'.$rekomendasi_fileidx[$index])),
                    ));
                    $urut++;
                }
                $index++;
            }
            $params1['id_kajianakhir'] = $id;
            $data1=M_kajianakhir::add_kategori($params1,$data);
        }
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Kajian Akhir',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: Kajian akhir dengan pelaporan no '.$no.' sudah di '.strtolower($dt['operation']),
               'ip' => $request->ip()
           )
        );
        return redirect()->route('m_kajianakhir.index',[ec($id_jenislaporan)]);
    }
    function save_dokumen(Request $request){
        $id = getinp($request->id);
        $params['id'] = $id;
        $id_jenislaporan = getinp($request->id_jenislaporan);
        $params['id_kajianakhir'] = getinp($request->id_kajianakhir);
        
        if(!cekjenislapor2($id_jenislaporan)||!cekint($params['id_kajianakhir'])||!cekintnull($id)){
            return redirect()->route('denied');
        }
        $datalap=DB::table("t_kajianakhir as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					 ->where('a.id','=',$params['id_kajianakhir'])
					 ->selectRaw('b.no,b.locus,b.stsposisi')->first();
        if(!empty($datalap)){
            $no=$datalap->no;
            $stsposisi=$datalap->stsposisi;
            $ceklocus=$datalap->locus;
            
            if(General::cekaksesedit($ceklocus)){
                //do nothing
            }
            else{
                return redirect()->route('denied');
            }
        }
        else{
            return redirect()->route('denied');
        }
        
        $params['note'] = getinp($request->note);
        $dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
        if($params['id']!=""){
            $params['edit_by'] =  session('be_uid');
            $params['edit_date'] =  date("Y-m-d H:i:s");
        }
        else{
            $params['create_by'] =  session('be_uid');
            $params['create_date'] =  date("Y-m-d H:i:s");
        }
        $data=M_kajianakhir::add_dokumen($params);
        $paramsupd['dokumen']=null;
        if($data){
            $id=$data;
        }
        if (!empty($request->file('dokumen'))){
			$file=$request->file('dokumen');
			$file_name=$file->getClientOriginalName();
			$file_ext=$file->extension();
			$date=new DateTime();
			$namafile=aksi_upload($file,'kajianakhir',$no.'-'.$date->format('Y-m-d-H-i-s').'-dokumen',$file_ext);
			$paramsupd['dokumen'] = $namafile;
			$paramsupd['id']=$id;
            $data=M_kajianakhir::add_dokumen($paramsupd);
		}
        if(isset($id)){
            $paramsupdkajian['id'] = $params['id_kajianakhir'];
            $paramsupdkajian['note'] = $params['note'];
            $paramsupdkajian['dokumen']=$paramsupd['dokumen'];
            $paramsupdkajian['edit_by'] =  session('be_uid');
            $paramsupdkajian['edit_date'] =  date("Y-m-d H:i:s");
            $data=M_kajianakhir::add($paramsupdkajian);
        }
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Kajian Akhir:Dokumen',
               'aksi' => $dt['operation'],
               'note' => 'ID:'.$id.', Title: Kajian akhir dengan pelaporan no '.$no.', dokumen '.$params['note'].' sudah di '.strtolower($dt['operation']),
               'ip' => $request->ip()
           )
        );
		
        echo route('m_kajianakhir.daftar_dokumen').'/'.ec($id_jenislaporan).'/'.ec($params['id_kajianakhir']);
    }
    function del($id_jenislaporan=null,$id = NULL,Request $request){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $id_jenislaporan=dc($id_jenislaporan);
        $id=dc($id);
        $datalap=DB::table("t_kajianakhir as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					 ->where('a.id','=',$id)
					 ->selectRaw('b.id,b.id_jenislaporan,b.no,b.locus,b.stsposisi')->first();
		$no='';
        if(!empty($datalap)){
            $idlap=$datalap->id;
            $id_jenislaporan=$datalap->id_jenislaporan;
            $no=$datalap->no;
            $ceklocus=$datalap->locus;
            $stsposisi=$datalap->stsposisi;
            
            if(General::cekaksesedit($ceklocus)){
                //do nothing
            }
            else{
                return redirect()->route('denied');
            }
        }
        else{
            return redirect()->route('denied');
        }
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Kajian Akhir',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Kajian akhir dengan pelaporan no '.$no.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
        $data=M_kajianakhir::del($id);
        
        $params['id']=$idlap;
        $params['edit_by'] =  session('be_uid');
        $params['edit_date'] =  date("Y-m-d H:i:s");
        $params['stsposisi']='Pemeriksaan';
        M_laporan::add($params);
		
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Kajian Akhir',
               'aksi' => 'Ubah',
               'note' => 'ID:'.$idlap.', Title: Pelaporan no '.$no.' diubah status posisinya menjadi '.$params['stsposisi'],
               'ip' => $request->ip()
           )
        );
        
		return redirect()->route('m_kajianakhir.index',[$ec_id_jenislaporan]);
    }
    function del_dokumen($id_jenislaporan=null,$id_kajianakhir=NULL, $id = NULL,Request $request){
        if(!cekjenislapor2(dc($id_jenislaporan))||!cekint(dc($id_kajianakhir))||!cekint(dc($id))){
            return redirect()->route('denied');
        }
        $ec_id_jenislaporan=$id_jenislaporan;
        $id_jenislaporan=dc($id_jenislaporan);
        $ec_id_kajianakhir=$id_kajianakhir;
        $id_kajianakhir=dc($id_kajianakhir);
        $id=dc($id);
        
        $datalap=DB::table("t_kajianakhir as a")->join('t_laporan as b','a.id_laporan','=','b.id')
					 ->where('a.id','=',$id_kajianakhir)
					 ->selectRaw('b.no,b.locus,b.stsposisi')->first();
        $no='';
        if(!empty($datalap)){
            $no=$datalap->no;
            $ceklocus=$datalap->locus;
            $stsposisi=$datalap->stsposisi;
            
            if(General::cekaksesedit($ceklocus)){
                //do nothing
            }
            else{
                return redirect()->route('denied');
            }
        }
        else{
            return redirect()->route('denied');
        }
        
        $dok_note=DB::table('t_kajianakhir_dokumen')->select('note')->where('id',$id)->first()->note;
        M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'Kajian Akhir',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: Kajian akhir dengan pelaporan no '.$no.', dokumen '.$dok_note.' sudah dihapus ',
               'ip' => $request->ip()
           )
        );
        
        $data=M_kajianakhir::del_dokumen($id);
        
        $doklast=DB::table('t_kajianakhir_dokumen')->where('id_kajianakhir',$id_kajianakhir)->orderBy('id', 'desc')->first();
		if($doklast){
            $paramskajian['note']=$doklast->note;
            $paramskajian['dokumen']=$doklast->dokumen;
        }
        else{
            $paramskajian['note']=null;
            $paramskajian['dokumen']=null;
        }
        $paramskajian['id']=$id_kajianakhir;
        $paramskajian['edit_by'] =  session('be_uid');
        $paramskajian['edit_date'] =  date("Y-m-d H:i:s");
        M_kajianakhir::upd($paramskajian);
		return redirect()->route('m_kajianakhir.daftar_dokumen',[$ec_id_jenislaporan,$ec_id_kajianakhir]);
    }
}
