<?php

namespace App\Http\Controllers;

use DB;
use App\Models\M_jabatan;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_JabatanController extends Controller
{
	public function __construct()
    {
    }
	public function index()
    {
		$arrLink=array(
			array("Jabatan",route('m_jabatan.index'))
		);
		$title='Daftar Jabatan';
		$tambah = 'href="'.route('m_jabatan.add').'"';
		return view('be.m_jabatan_list',compact('arrLink','title','tambah'));
    }
	function add($id = NULL)
    {
		if(!cekintnull(dc($id))){
			return redirect()->route('denied.index');
		}
		$id=dc($id);
		$operation = is_null($id) ? 'Tambah' : 'Ubah';
		$title = $operation.' Jabatan';
		$arrLink=array(
				array("Jabatan",route('m_user.index'))
				);
		$params['id'] =$id;
		$data=null;
		if(isset($id)){
			$data=M_jabatan::daftar($params);
		}
		return view('be.m_jabatan_add',compact('arrLink','operation','title','data'));
	}
	function view($id = NULL){
		if(!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$id=dc($id);
		$operation = 'View';
		$title = $operation.' Jabatan';
		$arrLink=array(
				array("Jabatan",route('m_jabatan.index'))
				);
		$params['id'] =$id;
		$data=null;
		if(isset($id)){
			$data=M_jabatan::daftar($params);
		}
		return view('be.m_jabatan_view',compact('arrLink','operation','title','data'));
	}
	public function save(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$params['nama'] = getinp($request->nama);
		
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		if($params['nama']!=""&&!is_null($params['nama'])){
			$data=M_jabatan::add($params);
	        M_log::add(
	           array(
	               'stsfrom' => 2,
	               'modul' => 'User',
	               'aksi' => $dt['operation'],
	               'note' => 'ID:'.$id.', Title: User '.$params['nama'].' sudah di '.strtolower($dt['operation']),
	               'ip' => $request->ip()
	           )
	        );
			$request->session()->flash('success', $dt['operation'] . ' Data Berhasil');
		}
		return redirect()->route('m_jabatan.index')->with('success', $dt['operation'] . ' Data Berhasil');
	}
	function del($id = NULL,Request $request)
	{
		if(!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$id=dc($id);
		$str="select 1 from m_user where jabatan=".$id." limit 1";
		$data=DB::select($str);
		if($data){
			return redirect()->route('m_jabatan.index')->with('failed', 'Hapus Data Tidak Berhasil');
		}
		else{
			$str="select nama from m_jabatan where id=".$id." limit 1";
			$nama=DB::select($str)[0]->nama;
			M_log::add(
	           array(
	               'stsfrom' => 2,
	               'modul' => 'User',
	               'aksi' => 'Hapus',
	               'note' => 'ID:'.$id.', Title: Jabatan '.$nama.' sudah dihapus',
	               'ip' => $request->ip()
	           )
	        );
			M_jabatan::del($id);
			return redirect()->route('m_jabatan.index')->with('success', 'Hapus Data Berhasil');
		}
	}
	function list_result(Request $request):JsonResponse
	{
		if($request->ajax()){
			$str="select id,nama
			from m_jabatan";
			$collection = DB::select($str);
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->make(true);
		}
    }
}
