<?php

namespace App\Http\Controllers;

use DB;
use App\Models\M_content;
use App\Models\M_log;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Yajra\DataTables\DataTables;

class M_ContentController extends Controller
{
	public function __construct()
    {
    }
	public function index()
    {
		$arrLink=array(
			array("Content",route('m_content.index'))
		);
		$title='Daftar Content';
		$tambah = 'href="'.route('m_content.add').'"';
		return view('be.m_content_list',compact('arrLink','title','tambah'));
    }
	function add($id = NULL)
    {
		if(!cekintnull(dc($id))){
			return redirect()->route('denied.index');
		}
		$id=dc($id);
		$operation = is_null($id) ? 'Tambah' : 'Ubah';
		$title = $operation.' content Pemilihan/Pemilu';
		$arrLink=array(
				array("content",route('m_user.index'))
				);
		$params['id'] =$id;
		$data=null;
		if(isset($id)){
			$data=M_content::daftar($params);
		}
		return view('be.m_content_add',compact('arrLink','operation','title','data'));
	}
	function view($id = NULL){
		if(!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$id=dc($id);
		$operation = 'View';
		$title = $operation.' Content';
		$arrLink=array(
				array("content",route('m_content.index'))
				);
		$params['id'] =$id;
		$data=null;
		if(isset($id)){
			$data=M_content::daftar($params);
		}
		return view('be.m_content_view',compact('arrLink','operation','title','data'));
	}
	public function save(Request $request){
		$id = getinp($request->id);
		$params['id'] = $id;
		$params['nama'] = getinp($request->nama);
		$params['isi'] = getinp($request->isi);
		
		$dt['operation'] = (empty($id)) ? 'Tambah' : 'Ubah';
		if($params['nama']!=""&&!is_null($params['nama'])){
			$data=M_content::add($params);
	        M_log::add(
	           array(
	               'stsfrom' => 2,
	               'modul' => 'User',
	               'aksi' => $dt['operation'],
	               'note' => 'ID:'.$id.', Title: User '.$params['nama'].' sudah di '.strtolower($dt['operation']),
	               'ip' => $request->ip()
	           )
	        );
			$request->session()->flash('success', $dt['operation'] . ' Data Berhasil');
		}
		return redirect()->route('m_content.index')->with('success', $dt['operation'] . ' Data Berhasil');
	}
	function del($id = NULL,Request $request)
	{
		if(!cekint(dc($id))){
			return redirect()->route('denied');
		}
		$id=dc($id);
		$str="select nama from t_content where id=".$id." limit 1";
		$nama=DB::select($str)[0]->nama;
		M_log::add(
           array(
               'stsfrom' => 2,
               'modul' => 'User',
               'aksi' => 'Hapus',
               'note' => 'ID:'.$id.', Title: content '.$nama.' sudah dihapus',
               'ip' => $request->ip()
           )
        );
		M_content::del($id);
		return redirect()->route('m_content.index')->with('success', 'Hapus Data Berhasil');
	}
	function list_result(Request $request):JsonResponse
	{
		//if($request->ajax()){
			$collection = M_content::daftar();
			return DataTables::of($collection)
			->addColumn('id_ec', function ($arrData){
				return ec($arrData->id);
			})
			->make(true);
		//}
    }
}
